/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getTCL() {
        if (System.getSecurityManager() != null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setTCL(final ClassLoader tcl) {
        if (System.getSecurityManager() != null) {
            Thread.currentThread().setContextClassLoader(tcl);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(tcl);
                    return null;
                }
            });
        }
    }
}

