/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.samples.chat.client;

import java.util.ArrayList;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.invocation.RemoteInvocation;
import org.jboss.remoting.samples.chat.client.ChatMessage;
import org.jboss.remoting.samples.chat.client.TalkFrame;

public class ChatReceiverHandler
implements InvokerCallbackHandler {
    private TalkFrame talkFrame;

    public ChatReceiverHandler(TalkFrame tf) {
        this.talkFrame = tf;
    }

    @Override
    public void handleCallback(Callback callback) throws HandleCallbackException {
        if (!(callback.getParameter() instanceof RemoteInvocation)) {
            throw new HandleCallbackException("invalid request format: expecting RemoteInvocation");
        }
        RemoteInvocation request = (RemoteInvocation)callback.getParameter();
        String methodName = request.getMethodName();
        Object[] args = request.getParameters();
        if (methodName.equals("send")) {
            this.send(args);
        } else if (methodName.equals("sendMultiple")) {
            this.sendMultiple(args);
        } else if (methodName.equals("setKey")) {
            this.setKey(args);
        } else if (methodName.equals("shuttingDown")) {
            this.shuttingDown(args);
        } else {
            throw new HandleCallbackException("unrecognized method name: " + methodName);
        }
    }

    protected void send(Object[] args) {
        ChatMessage mesg = (ChatMessage)args[0];
        this.talkFrame.appendMessage(mesg);
    }

    protected void sendMultiple(Object[] args) {
        ArrayList messages = (ArrayList)args[0];
        this.talkFrame.appendMessages(messages);
    }

    protected void setKey(Object[] args) {
        String key = (String)args[0];
        this.talkFrame.registerChatKey(key);
    }

    protected void shuttingDown(Object[] args) {
    }
}

