/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.remoting.util.SecurityUtility;

public class Version {
    public static final byte VERSION_1 = 1;
    public static final byte VERSION_2 = 2;
    public static final byte VERSION_2_2 = 22;
    public static final String VERSION = "2.5.3.SP1 (Flounder)";
    private static final byte byteVersion = 22;
    private static byte defaultByteVersion = (byte)22;
    private static boolean performVersioning = true;
    public static final String PRE_2_0_COMPATIBLE = "jboss.remoting.pre_2_0_compatible";
    public static final String REMOTING_VERSION_TO_USE = "jboss.remoting.version";

    public static void main(String[] arg) {
        System.out.println("JBossRemoting Version 2.5.3.SP1 (Flounder)");
    }

    public static int getDefaultVersion() {
        return defaultByteVersion;
    }

    public static boolean performVersioning() {
        return performVersioning;
    }

    public static boolean performVersioning(int version) {
        return version >= 2;
    }

    public static boolean isValidVersion(int version) {
        return version == 1 || version == 2 || version == 22;
    }

    private static String getSystemProperty(final String name) {
        if (SecurityUtility.skipAccessControl()) {
            return System.getProperty(name);
        }
        String value = null;
        try {
            value = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.getProperty(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
        return value;
    }

    private static void setSystemProperty(final String name, final String value) {
        if (SecurityUtility.skipAccessControl()) {
            System.setProperty(name, value);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.setProperty(name, value);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    private static ClassLoader getClassLoader() {
        if (SecurityUtility.skipAccessControl()) {
            return Version.class.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Version.class.getClassLoader();
            }
        });
    }

    static {
        try {
            ClassLoader cl = Version.getClassLoader();
            Class<?> c = cl.loadClass("org.jboss.logging.Logger");
            Method getLogger = c.getMethod("getLogger", String.class);
            Object logger = getLogger.invoke(null, "org.jboss.remoting");
            Method debug = c.getMethod("debug", Object.class);
            debug.invoke(logger, "Remoting version: 2.5.3.SP1 (Flounder)");
        }
        catch (Throwable t) {
            // empty catch block
        }
        boolean precompatibleFlag = false;
        String precompatible = Version.getSystemProperty(PRE_2_0_COMPATIBLE);
        if (precompatible != null && precompatible.length() > 0) {
            precompatibleFlag = Boolean.valueOf(precompatible);
        }
        if (precompatibleFlag) {
            defaultByteVersion = 1;
            performVersioning = false;
        } else {
            String userDefinedVersion = Version.getSystemProperty(REMOTING_VERSION_TO_USE);
            if (userDefinedVersion != null && userDefinedVersion.length() > 0) {
                byte userByteVersion = new Byte(userDefinedVersion);
                if (userByteVersion > 0) {
                    defaultByteVersion = userByteVersion;
                    if (defaultByteVersion < 2) {
                        performVersioning = false;
                    }
                } else {
                    System.err.println("Can not set remoting version to value less than 1.  System property value set for 'jboss.remoting.version' was " + userDefinedVersion);
                }
            } else {
                Version.setSystemProperty(REMOTING_VERSION_TO_USE, new Byte(defaultByteVersion).toString());
            }
        }
    }
}

