/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.ext;

import java.net.InetAddress;
import org.apache.log4j.ext.SnmpTrapSenderFacade;
import org.apache.log4j.helpers.LogLog;
import org.opennms.protocols.snmp.SnmpIPAddress;
import org.opennms.protocols.snmp.SnmpObjectId;
import org.opennms.protocols.snmp.SnmpOctetString;
import org.opennms.protocols.snmp.SnmpParameters;
import org.opennms.protocols.snmp.SnmpPduEncodingException;
import org.opennms.protocols.snmp.SnmpPduPacket;
import org.opennms.protocols.snmp.SnmpPduTrap;
import org.opennms.protocols.snmp.SnmpPeer;
import org.opennms.protocols.snmp.SnmpSyntax;
import org.opennms.protocols.snmp.SnmpTrapHandler;
import org.opennms.protocols.snmp.SnmpTrapSession;
import org.opennms.protocols.snmp.SnmpVarBind;

public class JoeSNMPTrapSender
implements SnmpTrapHandler,
SnmpTrapSenderFacade {
    private String managementHost = "127.0.0.1";
    private int managementHostTrapListenPort = 162;
    private String enterpriseOID = "1.3.6.1.2.1.1.2.0";
    private String localIPAddress = "127.0.0.1";
    private int localTrapSendPort = 161;
    private int genericTrapType = 0;
    private int specificTrapType = 6;
    private String applicationTrapOID = "1.3.6.1.2.1.1.2.0.0.0.0";
    private String communityString = "public";
    private long sysUpTime = 0L;
    private SnmpPduTrap pdu = null;
    private SnmpTrapSession session = null;
    private boolean isInitialized = false;

    public void snmpReceivedTrap(SnmpTrapSession parm1, InetAddress parm2, int parm3, SnmpOctetString parm4, SnmpPduPacket parm5) {
        LogLog.error((String)"This appender does not support receiving traps", (Throwable)new UnsupportedOperationException("Method snmpReceivedTrap() not implemented."));
    }

    public void snmpReceivedTrap(SnmpTrapSession parm1, InetAddress parm2, int parm3, SnmpOctetString parm4, SnmpPduTrap parm5) {
        LogLog.error((String)"This appender does not support receiving traps", (Throwable)new UnsupportedOperationException("Method snmpReceivedTrap() not implemented."));
    }

    public void snmpTrapSessionError(SnmpTrapSession parm1, int parm2, Object parm3) {
        LogLog.error((String)"There was a fatal error at the SNMP session layer.");
    }

    @Override
    public void initialize(String managementHostValue, int managementHostTrapListenPortValue, String enterpriseOIDValue, String localIPAddressValue, int localTrapSendPortValue, int genericTrapTypeValue, int specificTrapTypeValue, String communityStringValue, long sysUpTimeValue) {
        this.managementHost = managementHostValue;
        this.managementHostTrapListenPort = managementHostTrapListenPortValue;
        this.enterpriseOID = enterpriseOIDValue;
        this.localIPAddress = localIPAddressValue;
        this.localTrapSendPort = localTrapSendPortValue;
        this.genericTrapType = genericTrapTypeValue;
        this.specificTrapType = specificTrapTypeValue;
        this.communityString = communityStringValue;
        this.sysUpTime = sysUpTimeValue;
        this.pdu = new SnmpPduTrap();
        this.isInitialized = true;
    }

    @Override
    public void addTrapMessageVariable(String applicationTrapOIDValue, String value) {
        if (!this.isInitialized) {
            LogLog.error((String)"The initialize() method must be called before calling addTrapMessageVariable()");
            return;
        }
        if (applicationTrapOIDValue != null) {
            this.applicationTrapOID = applicationTrapOIDValue;
        }
        SnmpObjectId oid = new SnmpObjectId(this.applicationTrapOID);
        SnmpOctetString msg = new SnmpOctetString();
        msg.setString(value);
        try {
            SnmpVarBind varbind = new SnmpVarBind(oid, (SnmpSyntax)msg);
            this.pdu.addVarBind(varbind);
        }
        catch (Exception e) {
            LogLog.error((String)("Unexpected error creating SNMP bind variable: " + oid + " with value: " + value), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendTrap() {
        if (!this.isInitialized) {
            LogLog.error((String)"The initialize() method must be called before calling sendTrap()");
            return;
        }
        try {
            this.session = new SnmpTrapSession((SnmpTrapHandler)this, this.localTrapSendPort);
            SnmpPeer peer = new SnmpPeer(InetAddress.getByName(this.managementHost));
            peer.setPort(this.managementHostTrapListenPort);
            SnmpParameters snmpParms = new SnmpParameters();
            snmpParms.setReadCommunity(this.communityString);
            snmpParms.setVersion(0);
            peer.setParameters(snmpParms);
            if (this.pdu != null) {
                this.pdu.setEnterprise(this.enterpriseOID);
                SnmpOctetString addr = new SnmpOctetString();
                addr.setString(InetAddress.getByName(this.localIPAddress).getAddress());
                SnmpIPAddress ipAddr = new SnmpIPAddress(addr);
                this.pdu.setAgentAddress(ipAddr);
                this.pdu.setGeneric(this.genericTrapType);
                this.pdu.setSpecific(this.specificTrapType);
                this.pdu.setTimeStamp(this.sysUpTime);
                if (this.pdu.getLength() > 0) {
                    this.session.send(peer, this.pdu);
                }
            }
        }
        catch (SnmpPduEncodingException ex) {
            LogLog.error((String)"There were problems with the SNMP parameters -- could not create and send trap", (Throwable)ex);
        }
        catch (Exception e) {
            LogLog.error((String)"There was an unexpected error", (Throwable)e);
        }
        finally {
            if (null != this.session && !this.session.isClosed()) {
                this.session.close();
            }
        }
    }
}

