/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.clustered.jndiregistrar;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.ClusterChooserInterceptor;
import org.jboss.aspects.remoting.ClusteredPojiProxy;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.ejb3.proxy.clustered.registry.ProxyClusteringInfo;
import org.jboss.ejb3.proxy.clustered.registry.ProxyClusteringRegistry;
import org.jboss.ejb3.proxy.clustered.registry.ProxyClusteringRegistryListener;
import org.jboss.ejb3.proxy.impl.factory.ProxyFactory;
import org.jboss.ejb3.proxy.impl.jndiregistrar.JndiReferenceBinding;
import org.jboss.ejb3.proxy.impl.jndiregistrar.JndiReferenceBindingSet;
import org.jboss.ejb3.proxy.impl.jndiregistrar.JndiSessionRegistrarBase;
import org.jboss.ejb3.proxy.impl.remoting.IsLocalProxyFactoryInterceptor;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.ha.framework.interfaces.FamilyClusterInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.ClusterConfigMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.naming.Util;
import org.jboss.remoting.InvokerLocator;

public abstract class JndiClusteredSessionRegistrarBase
extends JndiSessionRegistrarBase
implements ProxyClusteringRegistryListener {
    private static final Logger log = Logger.getLogger(JndiClusteredSessionRegistrarBase.class);
    private final ProxyClusteringRegistry registry;
    private final Map<String, BeanClusteringRegistryInfo> bindingsByContainer = new ConcurrentHashMap<String, BeanClusteringRegistryInfo>();

    public JndiClusteredSessionRegistrarBase(String sessionProxyObjectFactoryType, ProxyClusteringRegistry registry) {
        super(sessionProxyObjectFactoryType);
        assert (registry != null) : "registry is null";
        this.registry = registry;
        this.registry.registerListener(this);
    }

    public void clusterTopologyChanged(ProxyClusteringInfo beanClusteringInfo) {
        RefAddr refAddr;
        JndiReferenceBindingSet bindings = null;
        BeanClusteringRegistryInfo registryEntry = this.bindingsByContainer.get(beanClusteringInfo.getContainerName());
        if (registryEntry != null) {
            bindings = registryEntry.bindings;
        }
        if (bindings == null) {
            return;
        }
        Context context = bindings.getContext();
        FamilyClusterInfo fci = beanClusteringInfo.getFamilyWrapper().get();
        String familyName = fci.getFamilyName();
        log.debug((Object)("Cluster topology changed for family " + familyName + " new view id " + fci.getCurrentViewId() + " - Updating JNDI bindings for container " + beanClusteringInfo.getContainerName()));
        for (JndiReferenceBinding binding : bindings.getDefaultRemoteBindings()) {
            refAddr = this.getFirstRefAddr(binding.getReference(), "Cluster Family Name");
            if (refAddr != null && familyName.equals(refAddr.getContent())) {
                this.redecorateReferenceForClusteringTargets(binding.getReference(), fci);
                this.rebind(context, binding.getJndiName(), binding.getReference());
            }
            String proxyFactoryKey = this.getSingleRequiredRefAddr(binding.getReference(), "ProxyFactoryKey");
            ProxyFactory existingProxyFactoryInJNDI = null;
            try {
                existingProxyFactoryInJNDI = (ProxyFactory)context.lookup(proxyFactoryKey);
            }
            catch (NamingException ne) {
                log.debug((Object)("Could not update the cluster topology changes to proxyfactory at key " + proxyFactoryKey));
                continue;
            }
            ProxyFactory updatedProxyToProxyFactory = this.updateProxyForRemoteProxyFactory(proxyFactoryKey, binding.getReference(), existingProxyFactoryInJNDI, beanClusteringInfo);
            try {
                Util.rebind((Context)context, (String)proxyFactoryKey, (Object)updatedProxyToProxyFactory);
                log.debug((Object)("Bound an updated proxyfactory at key " + proxyFactoryKey));
            }
            catch (NamingException ne) {
                log.warn((Object)("Exception while rebinding a new proxyfactory at key " + proxyFactoryKey + " with updated clustered topology"), (Throwable)ne);
            }
        }
        for (JndiReferenceBinding binding : bindings.getHomeRemoteBindings()) {
            refAddr = this.getFirstRefAddr(binding.getReference(), "Cluster Family Name");
            if (refAddr == null || !familyName.equals(refAddr.getContent())) continue;
            this.redecorateReferenceForClusteringTargets(binding.getReference(), fci);
            this.rebind(context, binding.getJndiName(), binding.getReference());
        }
        for (Set businessBindings : bindings.getBusinessRemoteBindings().values()) {
            for (JndiReferenceBinding binding : businessBindings) {
                RefAddr refAddr2 = this.getFirstRefAddr(binding.getReference(), "Cluster Family Name");
                if (refAddr2 == null || !familyName.equals(refAddr2.getContent())) continue;
                this.redecorateReferenceForClusteringTargets(binding.getReference(), fci);
                this.rebind(context, binding.getJndiName(), binding.getReference());
            }
        }
    }

    public void beanClusteringInfoAdded(ProxyClusteringInfo beanClusteringInfo) {
        BeanClusteringRegistryInfo info = this.getBeanClusteringRegistryInfo(beanClusteringInfo.getContainerName());
        info.familyCount.incrementAndGet();
    }

    public void beanClusteringInfoRemoved(ProxyClusteringInfo beanClusteringInfo) {
        String containerName = beanClusteringInfo.getContainerName();
        BeanClusteringRegistryInfo info = this.getBeanClusteringRegistryInfo(containerName);
        if (info.familyCount.decrementAndGet() == 0) {
            this.bindingsByContainer.remove(containerName);
        }
    }

    public ProxyClusteringRegistry getRegistry() {
        return this.registry;
    }

    public String getProxyFactoryRegistryKey(String jndiName, JBossSessionBeanMetaData smd, boolean isLocal) {
        String key = super.getProxyFactoryRegistryKey(jndiName, smd, isLocal);
        if (!isLocal) {
            ClusterConfigMetaData ccmd = smd.getClusterConfig();
            assert (ccmd != null) : ClusterConfigMetaData.class.getSimpleName() + " not found in metadata, specified only in XML? [EJBTHREE-1539]";
            key = key + "/" + ProxyClusteringRegistry.getPartitionName(smd.getClusterConfig());
        }
        return key;
    }

    protected JndiReferenceBindingSet createJndiReferenceBindingSet(Context context, JBossSessionBeanMetaData smd, ClassLoader cl, String containerName, String containerGuid, Advisor advisor) {
        JndiReferenceBindingSet bindings = super.createJndiReferenceBindingSet(context, smd, cl, containerName, containerGuid, advisor);
        this.decorateReferencesForClustering(bindings);
        BeanClusteringRegistryInfo registryInfo = this.getBeanClusteringRegistryInfo(containerName);
        registryInfo.bindings = bindings;
        return bindings;
    }

    protected ProxyFactory createProxyToProxyFactory(String proxyFactoryKey, String remotingUrl, ProxyFactory proxyFactory, ClassLoader cl, JBossEnterpriseBeanMetaData smd) {
        LoadBalancePolicy loadBalancePolicy;
        InvokerLocator locator = null;
        try {
            locator = new InvokerLocator(remotingUrl);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("Unable to create a remoting proxy for ProxyFactory " + proxyFactoryKey + " with remoting url " + remotingUrl, mue);
        }
        ProxyClusteringInfo bci = this.registry.getBeanClusteringInfo(proxyFactoryKey);
        if (bci == null) {
            throw new IllegalStateException("Cannot find " + ProxyClusteringInfo.class.getSimpleName() + " for proxyFactoryKey " + proxyFactoryKey);
        }
        String partitionName = bci.getPartitionName();
        assert (partitionName != null && !partitionName.trim().equals("")) : " Partition name is required, but is not available in ProxyClusteringInfo";
        String lbpClass = bci.getHomeLoadBalancePolicy().getName();
        assert (lbpClass != null && !lbpClass.trim().equals("")) : LoadBalancePolicy.class.getSimpleName() + " class name is required, but is not available in ProxyClusteringInfo";
        try {
            log.debug((Object)("Instantiating loadbalancer policy " + lbpClass + " for remote proxyfactory bound at key " + proxyFactoryKey));
            loadBalancePolicy = (LoadBalancePolicy)cl.loadClass(lbpClass).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load loadbalancer policy " + lbpClass + " while creating a proxy to remote proxyfactory", e);
        }
        FamilyWrapper wrapper = bci.getFamilyWrapper();
        FamilyClusterInfo familyClusterInfo = wrapper.get();
        log.debug((Object)("Remote proxyfactory for key " + proxyFactoryKey + " will be associated with family name " + familyClusterInfo.getFamilyName() + " view id " + familyClusterInfo.getCurrentViewId() + " with available targets " + familyClusterInfo.getTargets()));
        Class[] interfaces = this.getAllProxyFactoryInterfaces(proxyFactory.getClass());
        Interceptor[] interceptors = new Interceptor[]{IsLocalProxyFactoryInterceptor.singleton, ClusterChooserInterceptor.singleton, InvokeRemoteInterceptor.singleton};
        ClusteredPojiProxy handler = new ClusteredPojiProxy((Object)proxyFactoryKey, locator, interceptors, wrapper, loadBalancePolicy, partitionName, null);
        return (ProxyFactory)Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)handler);
    }

    private BeanClusteringRegistryInfo getBeanClusteringRegistryInfo(String containerName) {
        BeanClusteringRegistryInfo registryInfo = this.bindingsByContainer.get(containerName);
        if (registryInfo == null) {
            registryInfo = new BeanClusteringRegistryInfo();
            this.bindingsByContainer.put(containerName, registryInfo);
        }
        return registryInfo;
    }

    private void decorateReferencesForClustering(JndiReferenceBindingSet bindings) {
        for (JndiReferenceBinding binding : bindings.getDefaultRemoteBindings()) {
            this.decorateReferenceForClustering(binding.getReference());
        }
        for (JndiReferenceBinding binding : bindings.getHomeRemoteBindings()) {
            this.decorateReferenceForClustering(binding.getReference());
        }
        for (Set businessBindings : bindings.getBusinessRemoteBindings().values()) {
            for (JndiReferenceBinding binding : businessBindings) {
                this.decorateReferenceForClustering(binding.getReference());
            }
        }
    }

    private void decorateReferenceForClustering(Reference ref) {
        String proxyFactoryKey = this.getSingleRequiredRefAddr(ref, "ProxyFactoryKey");
        ProxyClusteringInfo bci = this.registry.getBeanClusteringInfo(proxyFactoryKey);
        if (bci == null) {
            throw new IllegalStateException("Cannot find " + ProxyClusteringInfo.class.getSimpleName() + " for proxyFactoryKey " + proxyFactoryKey);
        }
        StringRefAddr partitionRef = new StringRefAddr("Cluster Partition Name", bci.getPartitionName());
        this.addRefAddrToReference(ref, partitionRef);
        StringRefAddr lbpRef = new StringRefAddr("Cluster Proxy Factory Load Balance Policy", bci.getHomeLoadBalancePolicy().getName());
        this.addRefAddrToReference(ref, lbpRef);
        FamilyClusterInfo fci = bci.getFamilyWrapper().get();
        StringRefAddr familyNameRef = new StringRefAddr("Cluster Family Name", fci.getFamilyName());
        this.addRefAddrToReference(ref, familyNameRef);
        this.decorateReferenceForClusteringTargets(ref, fci);
    }

    private void redecorateReferenceForClusteringTargets(Reference ref, FamilyClusterInfo fci) {
        for (int i = 0; i < ref.size(); ++i) {
            RefAddr refAddr = ref.get(i);
            if (!"Cluster Target Remoting Host URL".equals(refAddr.getType())) continue;
            ref.remove(i);
            --i;
        }
        this.decorateReferenceForClusteringTargets(ref, fci);
    }

    private void decorateReferenceForClusteringTargets(Reference ref, FamilyClusterInfo fci) {
        List targets = fci.getTargets();
        for (Object target : targets) {
            boolean correctType = target instanceof InvokerLocator;
            assert (correctType) : target + " is not an instance of InvokerLocator";
            if (!correctType) {
                throw new IllegalStateException(target + " is not an instance of InvokerLocator");
            }
            String url = ((InvokerLocator)target).getOriginalURI();
            StringRefAddr targetRef = new StringRefAddr("Cluster Target Remoting Host URL", url);
            this.addRefAddrToReference(ref, targetRef);
        }
    }

    private void addRefAddrToReference(Reference ref, RefAddr refAddr) {
        log.debug((Object)("Adding " + RefAddr.class.getSimpleName() + " to " + Reference.class.getSimpleName() + ": Type \"" + refAddr.getType() + "\", Content \"" + refAddr.getContent() + "\""));
        ref.add(refAddr);
    }

    private String getSingleRequiredRefAddr(Reference ref, String refAddrType) {
        RefAddr result = null;
        for (int i = 0; i < ref.size(); ++i) {
            RefAddr refAddr = ref.get(i);
            if (!refAddr.getType().equals(refAddrType)) continue;
            if (result == null) {
                result = refAddr;
                continue;
            }
            throw new IllegalStateException(ref + " has multiple RefAddr objects of type " + refAddrType);
        }
        if (result == null) {
            throw new IllegalStateException(ref + " has no RefAddr object of type " + refAddrType);
        }
        return (String)result.getContent();
    }

    private RefAddr getFirstRefAddr(Reference ref, String refAddrType) {
        for (int i = 0; i < ref.size(); ++i) {
            RefAddr refAddr = ref.get(i);
            if (!refAddr.getType().equals(refAddrType)) continue;
            return refAddr;
        }
        return null;
    }

    private ProxyFactory updateProxyForRemoteProxyFactory(String proxyFactoryKey, Reference reference, ProxyFactory proxyFactory, ProxyClusteringInfo clusteringInfo) {
        InvokerLocator locator;
        String url = this.getSingleRequiredRefAddr(reference, "Remoting Host URL");
        assert (url != null && !url.trim().equals("")) : InvokerLocator.class.getSimpleName() + " URL is required, but is not specified; improperly bound reference in JNDI";
        try {
            locator = new InvokerLocator(url);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException("Unable to create a remoting proxy for ProxyFactory " + proxyFactoryKey + " with remoting url " + url, mue);
        }
        String partitionName = clusteringInfo.getPartitionName();
        assert (partitionName != null && !partitionName.trim().equals("")) : " Partition name is required, but was not available in ProxyClusteringInfo " + clusteringInfo;
        Class<? extends LoadBalancePolicy> lbpClass = clusteringInfo.getHomeLoadBalancePolicy();
        assert (lbpClass != null) : " LoadBalancePolicy is required, but is not available in the ProxyClusteringInfo " + clusteringInfo;
        LoadBalancePolicy loadBalancePolicyInstance = null;
        try {
            loadBalancePolicyInstance = lbpClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create loadbalancer policy instance for " + lbpClass + " while creating a proxy to remote proxyfactory", e);
        }
        FamilyWrapper wrapper = clusteringInfo.getFamilyWrapper();
        Class[] interfaces = this.getAllProxyFactoryInterfaces(proxyFactory.getClass());
        Interceptor[] interceptors = new Interceptor[]{IsLocalProxyFactoryInterceptor.singleton, ClusterChooserInterceptor.singleton, InvokeRemoteInterceptor.singleton};
        ClusteredPojiProxy handler = new ClusteredPojiProxy((Object)proxyFactoryKey, locator, interceptors, wrapper, loadBalancePolicyInstance, partitionName, null);
        return (ProxyFactory)Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)handler);
    }

    private static class BeanClusteringRegistryInfo {
        private final AtomicInteger familyCount = new AtomicInteger();
        private JndiReferenceBindingSet bindings;

        private BeanClusteringRegistryInfo() {
        }
    }
}

