/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.home;

import org.apache.commons.logging.Log;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.modules.ejb.AbstractEjbCodeGeneratorSubTask;
import xdoclet.modules.ejb.XDocletModulesEjbMessages;
import xdoclet.modules.ejb.home.HomeTagsHandler;
import xdoclet.modules.ejb.intf.InterfaceTagsHandler;
import xdoclet.tagshandler.PackageTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xjavadoc.XClass;
import xjavadoc.XTag;

public class LocalHomeInterfaceSubTask
extends AbstractEjbCodeGeneratorSubTask {
    public static final String DEFAULT_LOCALHOMEINTERFACE_CLASS_PATTERN = "{0}LocalHome";
    protected static final String DEFAULT_TEMPLATE_FILE = "resources/home-local.xdt";
    protected String localHomeClassPattern;

    public LocalHomeInterfaceSubTask() {
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(this.getLocalHomeClassPattern() + ".java");
        this.addOfType("javax.ejb.EntityBean");
        this.addOfType("javax.ejb.SessionBean");
    }

    public String getLocalHomeClassPattern() {
        if (this.localHomeClassPattern != null) {
            return this.localHomeClassPattern;
        }
        return DEFAULT_LOCALHOMEINTERFACE_CLASS_PATTERN;
    }

    public void setPattern(String new_pattern) {
        this.localHomeClassPattern = new_pattern;
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (this.getLocalHomeClassPattern() == null || this.getLocalHomeClassPattern().trim().equals("")) {
            throw new XDocletException(Translator.getString(XDocletMessages.class, (String)"PARAMETER_MISSING_OR_EMPTY", (String[])new String[]{"pattern"}));
        }
        if (this.getLocalHomeClassPattern().indexOf("{0}") == -1) {
            throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"PATTERN_HAS_NO_PLACEHOLDER"));
        }
    }

    protected String getGeneratedFileName(XClass clazz) throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor((String)HomeTagsHandler.getHomeInterface("local", this.getCurrentClass())) + ".java";
    }

    protected boolean matchesGenerationRules(XClass clazz) throws XDocletException {
        if (!super.matchesGenerationRules(clazz)) {
            return false;
        }
        Log log = LogUtil.getLog(LocalHomeInterfaceSubTask.class, (String)"matchesGenerationRules");
        if (!InterfaceTagsHandler.isLocalEjb(this.getCurrentClass())) {
            log.debug((Object)("Reject file " + clazz.getQualifiedName() + " because of different view-type"));
            return false;
        }
        XTag interfaceTag = this.getCurrentClass().getDoc().getTag("ejb:home");
        if (interfaceTag == null) {
            return true;
        }
        String generate = interfaceTag.getAttributeValue("generate");
        if (generate != null && generate.indexOf("local") == -1) {
            log.debug((Object)("Skip local home interface for " + clazz.getQualifiedName() + " because of generate=" + generate + " flag."));
            return false;
        }
        return true;
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString(XDocletModulesEjbMessages.class, (String)"GENERATING_LOCALHOME_FOR", (String[])new String[]{this.getCurrentClass().getQualifiedName()}));
    }
}

