/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.entity;

import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import xdoclet.DocletContext;
import xdoclet.DocletTask;
import xdoclet.XDocletException;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.XDocletModulesEjbMessages;
import xdoclet.modules.ejb.entity.ValueObjectSubTask;
import xdoclet.modules.ejb.intf.InterfaceTagsHandler;
import xdoclet.tagshandler.MethodTagsHandler;
import xdoclet.util.LogUtil;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;
import xjavadoc.XClass;
import xjavadoc.XMethod;
import xjavadoc.XTag;

public class ValueObjectTagsHandler
extends EjbTagsHandler {
    private XTag currentTag;
    private String currentValueObjectClass;
    private String currentValueObjectAttribute;
    private String currentValueObjectMatch;
    private String currentAggregateType;
    private String currentAggregateName;
    private String currentAggregateNamePlural;
    private String currentRelationBeanClass;

    public static boolean isValueObjectRelation(XMethod method, String valueObject) {
        Log log = LogUtil.getLog(ValueObjectTagsHandler.class, (String)"isValueObjectRelation");
        boolean ret = method.getDoc().hasTag("ejb:value-object");
        if (log.isDebugEnabled()) {
            log.debug((Object)(method.getName() + " has a ejb:value-object Tag " + ret));
        }
        if (ret) {
            List tags = method.getDoc().getTags("ejb:value-object");
            if (tags.size() == 0 && !"*".equals(valueObject)) {
                ret = false;
            } else {
                ret = false;
                boolean excluded = true;
                for (XTag tag : tags) {
                    String exclude = tag.getAttributeValue("exclude");
                    String aggreg = tag.getAttributeValue("aggregate");
                    String comp = tag.getAttributeValue("compose");
                    if ("true".equals(exclude) || aggreg == null && comp == null) {
                        excluded = true;
                        ret = false;
                        break;
                    }
                    ret = ValueObjectTagsHandler.matches(tag, valueObject);
                    if (!ret) continue;
                    break;
                }
                if ("*".equals(valueObject) && !excluded) {
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static boolean isGenerationNeeded(XClass clazz) {
        return true;
    }

    public static String getCurrentValueObjectClass(XClass clazz, XTag tag) throws XDocletException {
        String name = ValueObjectTagsHandler.getCurrentValueObjectName(tag);
        String _currentValueObjectClass = MessageFormat.format(ValueObjectTagsHandler.getSubTask().getValueObjectClassPattern(), name != null ? name : ValueObjectTagsHandler.getShortEjbNameFor(clazz));
        String packageName = clazz.getContainingPackage().getName();
        packageName = ValueObjectTagsHandler.choosePackage(packageName, null, DocletTask.getSubTaskName(ValueObjectSubTask.class));
        _currentValueObjectClass = packageName + '.' + _currentValueObjectClass;
        return _currentValueObjectClass;
    }

    public static String getCurrentValueObjectName(XTag tag) throws XDocletException {
        String name = tag.getAttributeValue("name");
        if (name != null) {
            return name;
        }
        for (XClass clazz = ValueObjectTagsHandler.getCurrentClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Iterator i = clazz.getDoc().getTags(tag.getName()).iterator();
            while (i.hasNext()) {
                if (!tag.equals(i.next())) continue;
                name = EjbTagsHandler.getShortEjbNameFor(clazz);
                if (name == null) {
                    throw new XDocletException("unable to determine value object name in class " + clazz.getName());
                }
                return name;
            }
        }
        throw new XDocletException("class defining value object is not EJB");
    }

    public static String getCurrentValueObjectAttribute(XTag tag) throws XDocletException {
        String name = ValueObjectTagsHandler.getCurrentValueObjectName(tag);
        String _currentValueObjectAttribute = name == null ? "Value" : MessageFormat.format(ValueObjectTagsHandler.getSubTask().getValueObjectClassPattern(), name);
        return _currentValueObjectAttribute;
    }

    public static String getCurrentValueObjectMatch(XTag tag) {
        String match = tag.getAttributeValue("match");
        if (match == null) {
            match = "*";
        }
        return match;
    }

    public static String getCurrentValueObjectImplements(XTag tag) {
        String toImplement = tag.getAttributeValue("implements");
        return toImplement != null ? "," + toImplement : "";
    }

    public static String getCurrentValueObjectExtends(XTag tag) {
        String toImplement = tag.getAttributeValue("extends");
        return toImplement != null ? toImplement : "java.lang.Object";
    }

    private static ValueObjectSubTask getSubTask() {
        ValueObjectSubTask subtask = (ValueObjectSubTask)DocletContext.getInstance().getSubTaskBy(DocletTask.getSubTaskName(ValueObjectSubTask.class));
        return subtask;
    }

    private static boolean matches(XTag tag, String valueObject) {
        Log log = LogUtil.getLog(ValueObjectTagsHandler.class, (String)"matches");
        String value = tag.getAttributeValue("match");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Match=" + value + "==" + valueObject));
        }
        if (value == null) {
            return "*".equals(valueObject);
        }
        return value.equals(valueObject) || value.equals("*") || "*".equals(valueObject);
    }

    public boolean isAbstractValueObject(String valueObjectName, XClass currentClass) throws XDocletException {
        boolean isAbstract = false;
        List valueObjectTags = currentClass.getDoc().getTags("ejb:value-object");
        Iterator i = valueObjectTags.iterator();
        while (i.hasNext() && !isAbstract) {
            XTag tag = (XTag)i.next();
            isAbstract = this.isAbstractValueObject(valueObjectName, tag);
        }
        return isAbstract;
    }

    public String getValueMostSuperObjectClass(XClass clazz) throws XDocletException {
        String currentDataClass = this.currentValueObjectClass;
        XClass cur_clazz = clazz.getSuperclass();
        block0: do {
            List methods = cur_clazz.getMethods();
            boolean found = false;
            for (XMethod method : methods) {
                if (method.getName().equals("get" + this.currentValueObjectAttribute)) {
                    found = true;
                    currentDataClass = ValueObjectTagsHandler.getCurrentValueObjectClass(cur_clazz, this.currentTag);
                }
                if (!found) continue;
                continue block0;
            }
        } while ((cur_clazz = cur_clazz.getSuperclass()) != null);
        return currentDataClass;
    }

    public void ifGeneratePKConstructor(String template, Properties attributes) throws XDocletException {
        if (ValueObjectTagsHandler.getSubTask().getGeneratePKConstructor()) {
            this.generate(template);
        }
    }

    public void ifIsAbstractValueObject(String template) throws XDocletException {
        if (this.isAbstractValueObject(this.valueObjectName(), ValueObjectTagsHandler.getCurrentClass())) {
            this.generate(template);
        }
    }

    public void ifNotIsAbstractValueObject(String template) throws XDocletException {
        if (!this.isAbstractValueObject(this.valueObjectName(), ValueObjectTagsHandler.getCurrentClass())) {
            this.generate(template);
        }
    }

    public String valueObjectClass() throws XDocletException {
        ValueObjectTagsHandler.getSubTask();
        return ValueObjectSubTask.getCurrentValueObjectClass();
    }

    public String valueObjectName() throws XDocletException {
        ValueObjectTagsHandler.getSubTask();
        return ValueObjectSubTask.getCurrentValueObjectName();
    }

    public String valueObjectMatch() throws XDocletException {
        ValueObjectTagsHandler.getSubTask();
        return ValueObjectSubTask.getCurrentValueObjectMatch();
    }

    public String extendsFrom(Properties attributes) throws XDocletException {
        ValueObjectTagsHandler.getSubTask();
        return ValueObjectSubTask.getCurrentValueObjectExtends();
    }

    public void forAllValueObjects(String pTemplate) throws XDocletException {
        Log log = LogUtil.getLog(ValueObjectTagsHandler.class, (String)"forAllValueObjects");
        List dos = ValueObjectTagsHandler.getCurrentClass().getDoc().getTags("ejb:value-object", true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of tags ejb:value-object in " + ValueObjectTagsHandler.getCurrentClass() + " = " + dos.size()));
        }
        for (XTag this.currentTag : dos) {
            if (this.isAbstractValueObject(ValueObjectTagsHandler.getCurrentValueObjectName(this.currentTag), this.currentTag)) continue;
            this.currentValueObjectClass = ValueObjectTagsHandler.getCurrentValueObjectClass(ValueObjectTagsHandler.getCurrentClass(), this.currentTag);
            this.currentValueObjectAttribute = ValueObjectTagsHandler.getCurrentValueObjectAttribute(this.currentTag);
            this.currentValueObjectMatch = ValueObjectTagsHandler.getCurrentValueObjectMatch(this.currentTag);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Generate for " + this.currentValueObjectClass + " attr=" + this.currentValueObjectAttribute + " match=" + this.currentValueObjectMatch));
            }
            this.generate(pTemplate);
        }
    }

    public String currentValueObjectClass() {
        return this.currentValueObjectClass;
    }

    public String currentValueObjectAttribute() {
        return this.currentValueObjectAttribute;
    }

    public String currentValueObjectMatch() {
        return this.currentValueObjectMatch;
    }

    public String currentAggregateType(Properties attributes) {
        String sh = attributes.getProperty("short");
        String ret = "";
        if (sh == null) {
            ret = this.currentAggregateType;
        } else {
            StringTokenizer st = new StringTokenizer(this.currentAggregateType, ".");
            while (st.hasMoreTokens()) {
                ret = st.nextToken();
            }
        }
        return ret;
    }

    public String valueObjectImplements() {
        ValueObjectTagsHandler.getSubTask();
        return ValueObjectSubTask.getCurrentValueObjectImplements();
    }

    public String currentAggregateName(Properties attributes) {
        String name;
        String plural = attributes.getProperty("plural");
        String decapitalize = attributes.getProperty("decapitalize");
        String string = name = "true".equals(plural) ? this.currentAggregateNamePlural : this.currentAggregateName;
        if ("true".equals(decapitalize) && name != null && name.length() > 0) {
            name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return name;
    }

    public String currentRelationBeanClass() {
        return this.currentRelationBeanClass;
    }

    public String concreteCollectionType() throws XDocletException {
        String currentReturnType;
        String concreteType = ValueObjectTagsHandler.getCurrentMethod().getDoc().getTagAttributeValue("ejb.value-object", "concrete-type");
        Class<?> concreteClass = null;
        if (concreteType != null) {
            try {
                concreteClass = Class.forName(concreteType);
            }
            catch (ClassNotFoundException e) {
                throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"VALUE_OBJECT_CONCRETE_TYPE_NOT_FOUND", (String[])new String[]{concreteType}));
            }
            if (concreteClass.isInterface()) {
                throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"VALUE_OBJECT_CONCRETE_TYPE_IS_INTF", (String[])new String[]{concreteType}));
            }
            if (Modifier.isAbstract(concreteClass.getModifiers())) {
                throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"VALUE_OBJECT_CONCRETE_TYPE_IS_ABSTRACT", (String[])new String[]{concreteType}));
            }
        }
        if ((currentReturnType = ValueObjectTagsHandler.getCurrentMethod().getReturnType().getType().getQualifiedName()).equals("java.util.Collection")) {
            if (concreteClass == null) {
                return "java.util.ArrayList";
            }
            if (!Collection.class.isAssignableFrom(concreteClass)) {
                throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"VALUE_OBJECT_CONCRETE_TYPE_INVALID", (String[])new String[]{concreteType, "java.util.Collection"}));
            }
            return concreteType;
        }
        if (currentReturnType.equals("java.util.Set")) {
            if (concreteClass == null) {
                return "java.util.HashSet";
            }
            if (!Set.class.isAssignableFrom(concreteClass)) {
                throw new XDocletException(Translator.getString(XDocletModulesEjbMessages.class, (String)"VALUE_OBJECT_CONCRETE_TYPE_INVALID", (String[])new String[]{concreteType, "java.util.Set"}));
            }
            return concreteType;
        }
        throw new XDocletException("Invalid return type (" + currentReturnType + " on aggregate or composition.");
    }

    public String collectionType() throws XDocletException {
        return ValueObjectTagsHandler.getCurrentMethod().getReturnType().getType().getQualifiedName();
    }

    public void ifIsCollection(String template) throws XDocletException {
        if (this.isCollection()) {
            this.generate(template);
        }
    }

    public void ifIsNotCollection(String template) throws XDocletException {
        if (!this.isCollection()) {
            this.generate(template);
        }
    }

    public String valueMostSuperObjectClass() throws XDocletException {
        return this.getValueMostSuperObjectClass(ValueObjectTagsHandler.getCurrentClass());
    }

    public void forAllSuperSetValue(String template) throws XDocletException {
        XClass oldClass = ValueObjectTagsHandler.getCurrentClass();
        XClass superclass = null;
        do {
            List dos = ValueObjectTagsHandler.getCurrentClass().getDoc().getTags("ejb:value-object", false);
            for (XTag this.currentTag : dos) {
                this.currentValueObjectClass = ValueObjectTagsHandler.getCurrentValueObjectClass(ValueObjectTagsHandler.getCurrentClass(), this.currentTag);
                this.currentValueObjectAttribute = ValueObjectTagsHandler.getCurrentValueObjectAttribute(this.currentTag);
                this.currentValueObjectMatch = ValueObjectTagsHandler.getCurrentValueObjectMatch(this.currentTag);
                this.forAllSetters(template, "set" + this.currentValueObjectAttribute);
            }
            superclass = ValueObjectTagsHandler.getCurrentClass().getSuperclass();
            if (superclass == null) continue;
            ValueObjectTagsHandler.pushCurrentClass((XClass)superclass);
        } while (superclass != null);
        ValueObjectTagsHandler.setCurrentClass((XClass)oldClass);
    }

    public void forAllAggregates(String template, Properties attributes) throws XDocletException {
        String superclasses_str = attributes.getProperty("superclasses");
        boolean superclasses = TypeConversionUtil.stringToBoolean((String)superclasses_str, (boolean)true);
        String valueObject = attributes.getProperty("valueobject");
        this.forAllRelations(template, superclasses, valueObject, "aggregate");
    }

    public void forAllComposes(String template, Properties attributes) throws XDocletException {
        String superclasses_str = attributes.getProperty("superclasses");
        boolean superclasses = TypeConversionUtil.stringToBoolean((String)superclasses_str, (boolean)true);
        String valueObject = attributes.getProperty("valueobject");
        this.forAllRelations(template, superclasses, valueObject, "compose");
    }

    public void forAllRelations(String template, Properties attributes) throws XDocletException {
        String superclasses_str = attributes.getProperty("superclasses");
        boolean superclasses = TypeConversionUtil.stringToBoolean((String)superclasses_str, (boolean)true);
        String valueObject = attributes.getProperty("valueobject");
        this.forAllRelations(template, superclasses, valueObject, "aggregate");
        this.forAllRelations(template, superclasses, valueObject, "compose");
    }

    public void ifUsingValueObject(String template) throws XDocletException {
        if (DocletContext.getInstance().isSubTaskDefined(DocletTask.getSubTaskName(ValueObjectSubTask.class))) {
            this.generate(template);
        }
    }

    protected void forAllSetters(String template, String methodName) throws XDocletException {
        Log log = LogUtil.getLog(ValueObjectTagsHandler.class, (String)"forAllSetters");
        if (log.isDebugEnabled()) {
            log.debug((Object)methodName);
        }
        List methods = ValueObjectTagsHandler.getCurrentClass().getMethods();
        XMethod methodFound = null;
        for (XMethod method : methods) {
            if (method.getName().equals(methodName)) {
                methodFound = method;
            }
            if (methodFound == null) continue;
            if (!log.isDebugEnabled()) break;
            log.debug((Object)methodFound);
            break;
        }
        if (methodFound != null) {
            this.generate(template);
        }
    }

    private boolean isCollection() {
        String currentReturnType = ValueObjectTagsHandler.getCurrentMethod().getReturnType().getType().getQualifiedName();
        return "java.util.Collection".equals(currentReturnType) || "java.util.Set".equals(currentReturnType);
    }

    private boolean isAbstractValueObject(String valueObjectName, XTag tag) {
        boolean isAbstract = false;
        String attr = tag.getAttributeValue("abstract");
        if (valueObjectName.equals(tag.getAttributeValue("name")) && attr != null) {
            isAbstract = TypeConversionUtil.stringToBoolean((String)attr, (boolean)false);
        }
        return isAbstract;
    }

    private void forAllRelations(String template, boolean superclasses, String valueObject, String type) throws XDocletException {
        Log log = LogUtil.getLog(ValueObjectTagsHandler.class, (String)"forAllRelations");
        HashMap<String, String> foundFields = new HashMap<String, String>();
        XClass currentClass = ValueObjectTagsHandler.getCurrentClass();
        XMethod oldMethod = ValueObjectTagsHandler.getCurrentMethod();
        if (log.isDebugEnabled()) {
            log.debug((Object)("*** forAllRelations on class=" + currentClass.getName() + " valueobject=" + valueObject));
        }
        while (true) {
            ValueObjectTagsHandler.pushCurrentClass((XClass)currentClass);
            if (log.isDebugEnabled()) {
                log.debug((Object)("****** CurrentClass=" + ValueObjectTagsHandler.getCurrentClass()));
            }
            List methods = ValueObjectTagsHandler.getCurrentClass().getMethods();
            for (XMethod method : methods) {
                ValueObjectTagsHandler.setCurrentMethod((XMethod)method);
                if (!MethodTagsHandler.isGetter((String)ValueObjectTagsHandler.getCurrentMethod().getName()) || foundFields.containsKey(ValueObjectTagsHandler.getCurrentMethod().getName()) || !ValueObjectTagsHandler.isValueObjectRelation(ValueObjectTagsHandler.getCurrentMethod(), valueObject)) continue;
                boolean ret = ValueObjectTagsHandler.getCurrentMethod().getDoc().hasTag("ejb:value-object");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("****** Method " + ValueObjectTagsHandler.getCurrentMethod().getName() + " has VO tag : " + ret));
                }
                if (!ret) continue;
                List tags = ValueObjectTagsHandler.getCurrentMethod().getDoc().getTags("ejb:value-object");
                for (XTag tag : tags) {
                    if (!ValueObjectTagsHandler.matches(tag, valueObject)) continue;
                    String aggreg = tag.getAttributeValue(type);
                    String aggregName = tag.getAttributeValue(type + "-name");
                    String aggregNamePlural = tag.getAttributeValue(type + "s-name");
                    if (aggregNamePlural == null) {
                        aggregNamePlural = aggregName + "s";
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("********* " + method.getName() + " ejb:value-object Tag - Type = " + type + " - Value = " + aggreg + " - Name = " + aggregName));
                    }
                    if (aggreg == null) continue;
                    String currentReturnType = ValueObjectTagsHandler.getCurrentMethod().getReturnType().getType().getQualifiedName();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("********* METHOD=" + ValueObjectTagsHandler.getCurrentMethod().getName() + " " + currentReturnType));
                    }
                    foundFields.put(ValueObjectTagsHandler.getCurrentMethod().getName(), ValueObjectTagsHandler.getCurrentMethod().getName());
                    if (currentReturnType.equals("java.util.Collection") || currentReturnType.equals("java.util.Set")) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"********* Type Collection or Set");
                        }
                        this.currentAggregateType = aggreg;
                        this.currentAggregateName = aggregName;
                        this.currentAggregateNamePlural = aggregNamePlural;
                        String relationInterface = tag.getAttributeValue("members");
                        if (log.isDebugEnabled()) {
                            log.debug((Object)relationInterface);
                        }
                        if (relationInterface != null && !relationInterface.equals("")) {
                            this.currentRelationBeanClass = InterfaceTagsHandler.getBeanClassNameFromInterfaceNameFor(relationInterface);
                        }
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("********* Type " + ValueObjectTagsHandler.getCurrentMethod().getReturnType().getType().toString()));
                        }
                        this.currentAggregateType = aggreg;
                        this.currentAggregateName = aggregName;
                        this.currentAggregateNamePlural = aggregNamePlural;
                        this.currentRelationBeanClass = InterfaceTagsHandler.getBeanClassNameFromInterfaceNameFor(ValueObjectTagsHandler.getCurrentMethod().getReturnType().getType().getQualifiedName());
                    }
                    this.generate(template);
                    this.currentAggregateType = null;
                    this.currentAggregateName = null;
                    this.currentAggregateNamePlural = null;
                    this.currentRelationBeanClass = null;
                }
            }
            XClass superclass = ValueObjectTagsHandler.getCurrentClass().getSuperclass();
            if (superclass == null) {
                ValueObjectTagsHandler.popCurrentClass();
                break;
            }
            if (superclass.getQualifiedName().equals("java.lang.Object")) {
                ValueObjectTagsHandler.popCurrentClass();
                break;
            }
            ValueObjectTagsHandler.popCurrentClass();
            if (superclasses) {
                currentClass = currentClass.getSuperclass();
                continue;
            }
            if (!this.shouldTraverseSuperclassForDependentClass(currentClass.getSuperclass(), this.getDependentClassTagName())) break;
            currentClass = currentClass.getSuperclass();
        }
        ValueObjectTagsHandler.setCurrentMethod((XMethod)oldMethod);
        log.debug((Object)"Finished.");
    }
}

