/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.ejb.dao;

import java.text.MessageFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import xdoclet.DocletContext;
import xdoclet.DocletTask;
import xdoclet.XDocletException;
import xdoclet.modules.ejb.EjbTagsHandler;
import xdoclet.modules.ejb.dao.DaoSubTask;
import xdoclet.modules.ejb.home.HomeTagsHandler;
import xdoclet.util.LogUtil;
import xjavadoc.XClass;
import xjavadoc.XMethod;

public class DaoTagsHandler
extends EjbTagsHandler {
    public static String getDaoClassFor(XClass clazz) {
        Log log = LogUtil.getLog(DaoTagsHandler.class, (String)"getDaoClassFor");
        String fileName = clazz.getContainingPackage().getName();
        String daoPattern = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("dao for " + clazz.getQualifiedName()));
        }
        daoPattern = DaoTagsHandler.getDaoClassPattern();
        String daoClass = clazz.getDoc().getTagAttributeValue("ejb.dao", "class", false);
        if (daoClass != null) {
            return daoClass;
        }
        String ejbName = null;
        String packagePattern = null;
        ejbName = daoPattern.indexOf("{0}") != -1 ? MessageFormat.format(daoPattern, DaoTagsHandler.getShortEjbNameFor(clazz)) : daoPattern;
        fileName = DaoTagsHandler.choosePackage(fileName, packagePattern, DocletTask.getSubTaskName(DaoSubTask.class));
        fileName = fileName + "." + ejbName;
        return fileName;
    }

    public static boolean isDaoMethod(XMethod method) throws XDocletException {
        Log log = LogUtil.getLog(DaoTagsHandler.class, (String)"isDaoMethod");
        boolean include = method.getDoc().hasTag("dao.call");
        if (log.isDebugEnabled()) {
            log.debug((Object)("method " + method.getName() + " has " + (include ? "a" : "no") + " dao.call tag"));
        }
        if (HomeTagsHandler.isCreateMethod(method)) {
            String createMethods = DaoTagsHandler.getTagValue((int)0, (String)"ejb.dao", (String)"create-methods", null, (String)"true", (boolean)false, (boolean)false);
            log.debug((Object)("createMethods=" + createMethods));
            if ("true".equals(createMethods)) {
                include = false;
            }
        }
        if (HomeTagsHandler.isFinderMethod(method)) {
            String finderMethods = DaoTagsHandler.getTagValue((int)0, (String)"ejb.dao", (String)"finder-methods", null, (String)"true", (boolean)false, (boolean)false);
            log.debug((Object)("finderMethods=" + finderMethods));
            if ("true".equals(finderMethods)) {
                include = false;
            }
        }
        return include;
    }

    protected static String getDaoClassPattern() {
        DaoSubTask daoSubtask = (DaoSubTask)DocletContext.getInstance().getSubTaskBy(DocletTask.getSubTaskName(DaoSubTask.class));
        if (daoSubtask != null) {
            return daoSubtask.getDaoClassPattern();
        }
        return "{0}DAO";
    }

    private static boolean isDaoSubTaskActive() {
        return DocletContext.getInstance().isSubTaskDefined(DocletTask.getSubTaskName(DaoSubTask.class));
    }

    public String daoClass(Properties attributes) throws XDocletException {
        return DaoTagsHandler.getDaoClassFor(DaoTagsHandler.getCurrentClass());
    }

    public void ifUsingDao(String template) throws XDocletException {
        if (DaoTagsHandler.isDaoSubTaskActive() && DaoTagsHandler.getCurrentClass().getDoc().hasTag("ejb.dao", false)) {
            this.generate(template);
        }
    }

    public void ifDaoMethod(String template) throws XDocletException {
        if (DaoTagsHandler.isDaoMethod(DaoTagsHandler.getCurrentMethod())) {
            this.generate(template);
        }
    }
}

