/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.StringTokenizer;
import org.jboss.wsf.framework.deployment.ContextRootDeploymentAspect;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.EJBArchiveMetaData;
import org.jboss.wsf.spi.metadata.j2ee.EJBMetaData;

public class BackwardCompatibleContextRootDeploymentAspect
extends ContextRootDeploymentAspect {
    @Override
    protected String getExplicitContextRoot(Deployment dep) {
        String contextRoot = super.getExplicitContextRoot(dep);
        if (contextRoot == null) {
            for (Endpoint ep : dep.getService().getEndpoints()) {
                StringTokenizer st;
                String urlPattern = this.getUrlPattern(dep, ep);
                if (urlPattern == null || (st = new StringTokenizer(urlPattern, "/")).countTokens() <= 1) continue;
                String firstToken = st.nextToken();
                if (contextRoot != null && !contextRoot.equals(firstToken)) {
                    throw new IllegalStateException("All endpoints must share the same <context-root>: " + contextRoot + "!=" + firstToken);
                }
                contextRoot = firstToken;
            }
        }
        return contextRoot;
    }

    private String getUrlPattern(Deployment dep, Endpoint ep) {
        String urlPattern = null;
        EJBArchiveMetaData appMetaData = (EJBArchiveMetaData)dep.getAttachment(EJBArchiveMetaData.class);
        if (appMetaData != null && appMetaData.getBeanByEjbName(ep.getShortName()) != null) {
            EJBMetaData bmd = appMetaData.getBeanByEjbName(ep.getShortName());
            urlPattern = bmd.getPortComponentURI();
        }
        return urlPattern;
    }
}

