/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.vfs.helpers.LazyInputStream;
import org.xml.sax.InputSource;

public class VFSInputSource
extends InputSource {
    private VirtualFile file;

    public VFSInputSource(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.file = file;
    }

    public String getSystemId() {
        try {
            return this.file.toURI().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getByteStream() {
        return new LazyInputStream(this.file);
    }

    public Reader getCharacterStream() {
        return new InputStreamReader(this.getByteStream());
    }

    public String toString() {
        return this.file.getPathName();
    }
}

