/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.web;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.tools.ant.types.EnumeratedAttribute;
import xdoclet.XDocletException;
import xdoclet.XDocletMessages;
import xdoclet.XmlSubTask;
import xdoclet.util.Translator;

public class WebXmlSubTask
extends XmlSubTask {
    private static final String DEFAULT_TEMPLATE_FILE = "resources/web_xml.xdt";
    private static final String GENERATED_FILE_NAME = "web.xml";
    private static final String WEBXML_PUBLICID_2_4 = "http://java.sun.com/xml/ns/j2ee";
    private static final String WEBXML_PUBLICID_2_3 = "-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN";
    private static final String WEBXML_PUBLICID_2_2 = "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN";
    private static final String WEBXML_SYSTEMID_2_4 = "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd";
    private static final String WEBXML_SYSTEMID_2_3 = "http://java.sun.com/dtd/web-app_2_3.dtd";
    private static final String WEBXML_SYSTEMID_2_2 = "http://java.sun.com/j2ee/dtds/web-app_2_2.dtd";
    private static final String WEBXML_XSD_FILE_NAME_2_4 = "resources/web-app_2_4.xsd";
    private static final String WEBXML_DTD_FILE_NAME_2_3 = "resources/web-jar-23.dtd";
    private static final String WEBXML_DTD_FILE_NAME_2_2 = "resources/web-jar-22.dtd";
    private static final String XSD_LOCATION_24 = "http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd";
    protected String servletSpec = "2.3";
    protected String smallIcon = "";
    protected String largeIcon = "";
    protected String displayName = "";
    protected String description = "";
    protected boolean distributable = true;
    protected ArrayList contextParams = new ArrayList();
    protected Integer sessionTimeout = null;
    protected ArrayList welcomeFiles = new ArrayList();
    protected ArrayList tagLibs = new ArrayList();

    public WebXmlSubTask() {
        this.setTemplateURL(((Object)((Object)this)).getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_FILE_NAME);
    }

    public String getServletspec() {
        return this.servletSpec;
    }

    public ArrayList getContextParams() {
        return this.contextParams;
    }

    public String getSmallicon() {
        return this.smallIcon;
    }

    public String getLargeicon() {
        return this.largeIcon;
    }

    public String getDisplayname() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public Integer getSessiontimeout() {
        return this.sessionTimeout;
    }

    public ArrayList getWelcomeFiles() {
        return this.welcomeFiles;
    }

    public ArrayList getTagLibs() {
        return this.tagLibs;
    }

    public void setServletspec(ServletVersionTypes servletSpec) {
        this.servletSpec = servletSpec.getValue();
    }

    public void setSmallicon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    public void setLargeicon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    public void setDisplayname(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public void setSessiontimeout(Integer session_timeout) {
        this.sessionTimeout = session_timeout;
    }

    public void setTagLibs(ArrayList tagLibs) {
        this.tagLibs = tagLibs;
    }

    public void setWelcomeFiles(ArrayList welcomeFiles) {
        this.welcomeFiles = welcomeFiles;
    }

    public void setContextParams(ArrayList contextParams) {
        this.contextParams = contextParams;
    }

    public void addConfiguredContextparam(ContextParam cp) {
        this.contextParams.add(cp);
    }

    public void addConfiguredWelcomefile(WelcomeFile file) {
        this.welcomeFiles.add(file);
    }

    public void addConfiguredTaglib(TagLib taglib) {
        this.tagLibs.add(taglib);
    }

    public void execute() throws XDocletException {
        if (this.getServletspec().equals("2.2")) {
            this.setPublicId(WEBXML_PUBLICID_2_2);
            this.setSystemId(WEBXML_SYSTEMID_2_2);
            this.setDtdURL(((Object)((Object)this)).getClass().getResource(WEBXML_DTD_FILE_NAME_2_2));
        } else if (this.getServletspec().equals("2.4")) {
            this.setSchema(XSD_LOCATION_24);
            this.setSchemaURL(((Object)((Object)this)).getClass().getResource(WEBXML_XSD_FILE_NAME_2_4));
        } else {
            this.setPublicId(WEBXML_PUBLICID_2_3);
            this.setSystemId(WEBXML_SYSTEMID_2_3);
            this.setDtdURL(((Object)((Object)this)).getClass().getResource(WEBXML_DTD_FILE_NAME_2_3));
        }
        this.startProcess();
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString(XDocletMessages.class, (String)"GENERATING_SOMETHING", (String[])new String[]{this.getDestinationFile()}));
    }

    public static class ServletVersionTypes
    extends EnumeratedAttribute {
        public static final String VERSION_2_2 = "2.2";
        public static final String VERSION_2_3 = "2.3";
        public static final String VERSION_2_4 = "2.4";

        public String[] getValues() {
            return new String[]{VERSION_2_2, VERSION_2_3, VERSION_2_4};
        }
    }

    public static class WelcomeFile
    implements Serializable {
        private String file = null;

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }
    }

    public static class TagLib
    implements Serializable {
        private String taglibUri = null;
        private String taglibLocation = null;

        public String getUri() {
            return this.taglibUri;
        }

        public String getLocation() {
            return this.taglibLocation;
        }

        public void setUri(String uri) {
            this.taglibUri = uri;
        }

        public void setLocation(String location) {
            this.taglibLocation = location;
        }
    }

    public static class ContextParam
    implements Serializable {
        private String paramName = null;
        private String paramValue = null;
        private String description = "";

        public String getName() {
            return this.paramName;
        }

        public String getValue() {
            return this.paramValue;
        }

        public String getDescription() {
            return this.description;
        }

        public void setName(String name) {
            this.paramName = name;
        }

        public void setValue(String value) {
            this.paramValue = value;
        }

        public void setDescription(String desc) {
            this.description = desc;
        }
    }
}

