/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.xml.impl;

import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.XsEChoice;
import org.apache.ws.jaxme.xs.xml.XsEComplexContent;
import org.apache.ws.jaxme.xs.xml.XsESequence;
import org.apache.ws.jaxme.xs.xml.XsESimpleContent;
import org.apache.ws.jaxme.xs.xml.XsGAttrDecls;
import org.apache.ws.jaxme.xs.xml.XsGComplexTypeModel;
import org.apache.ws.jaxme.xs.xml.XsGTypeDefParticle;
import org.apache.ws.jaxme.xs.xml.XsObject;
import org.apache.ws.jaxme.xs.xml.XsObjectFactory;
import org.apache.ws.jaxme.xs.xml.XsTAll;
import org.apache.ws.jaxme.xs.xml.XsTAttribute;
import org.apache.ws.jaxme.xs.xml.XsTAttributeGroupRef;
import org.apache.ws.jaxme.xs.xml.XsTGroupRef;
import org.apache.ws.jaxme.xs.xml.XsTTypeDefParticle;
import org.apache.ws.jaxme.xs.xml.XsTWildcard;
import org.xml.sax.SAXException;

public class XsGComplexTypeModelImpl
implements XsGComplexTypeModel {
    private final XsObject owner;
    private XsESimpleContent simpleContent;
    private XsEComplexContent complexContent;
    private boolean otherContent;
    private final XsGTypeDefParticle typeDefParticle;
    private final XsGAttrDecls attrDecls;

    protected XsGComplexTypeModelImpl(XsObject pOwner) {
        this.owner = pOwner;
        XsObjectFactory factory = this.owner.getObjectFactory();
        this.typeDefParticle = factory.newXsGTypeDefParticle(this.owner);
        this.attrDecls = factory.newXsGAttrDecls(this.owner);
    }

    @Override
    public XsESimpleContent createSimpleContent() {
        if (this.simpleContent != null) {
            throw new IllegalStateException("Multiple 'simpleContent' child elements are forbidden.");
        }
        if (this.complexContent != null) {
            throw new IllegalStateException("The 'simpleContent' and 'complexContent' child elements are mutually exclusive.");
        }
        if (this.otherContent) {
            throw new IllegalStateException("The 'simpleContent' child element and the child elements 'all', 'choice', 'sequence', 'group', 'attribute', and 'attributeGroup' are mutually exclusive.");
        }
        this.simpleContent = this.owner.getObjectFactory().newXsESimpleContent(this.owner);
        return this.simpleContent;
    }

    @Override
    public XsESimpleContent getSimpleContent() {
        return this.simpleContent;
    }

    @Override
    public XsEComplexContent createComplexContent() {
        if (this.complexContent != null) {
            throw new IllegalStateException("Multiple 'complexContent' child elements are forbidden.");
        }
        if (this.simpleContent != null) {
            throw new IllegalStateException("The 'complexContent' and 'simpleContent' child elements are mutually exclusive.");
        }
        if (this.otherContent) {
            throw new IllegalStateException("The 'complexContent' child element and the child elements 'all', 'choice', 'sequence', 'group', 'attribute', and 'attributeGroup' are mutually exclusive.");
        }
        this.complexContent = this.owner.getObjectFactory().newXsEComplexContent(this.owner);
        return this.complexContent;
    }

    @Override
    public XsEComplexContent getComplexContent() {
        return this.complexContent;
    }

    protected void validateOtherContent() {
        if (this.simpleContent != null) {
            throw new IllegalStateException("The child elements 'all', 'choice', 'sequence', 'group', 'attribute', 'attributeGroup', and the child element 'simpleContent' are mutually exclusive.");
        }
        if (this.complexContent != null) {
            throw new IllegalStateException("The child elements 'all', 'choice', 'sequence', 'group', 'attribute', 'attributeGroup', and the child element 'complexContent' are mutually exclusive.");
        }
    }

    @Override
    public XsTAttribute createAttribute() {
        this.validateOtherContent();
        return this.attrDecls.createAttribute();
    }

    @Override
    public XsTAttribute[] getAttributes() {
        return this.attrDecls.getAttributes();
    }

    @Override
    public XsTAttributeGroupRef createAttributeGroup() {
        this.validateOtherContent();
        return this.attrDecls.createAttributeGroup();
    }

    @Override
    public XsTAttributeGroupRef[] getAttributeGroups() {
        return this.attrDecls.getAttributeGroups();
    }

    @Override
    public XsTWildcard createAnyAttribute() {
        this.validateOtherContent();
        return this.attrDecls.createAnyAttribute();
    }

    @Override
    public XsTWildcard getAnyAttribute() {
        return this.attrDecls.getAnyAttribute();
    }

    @Override
    public Object[] getAllAttributes() {
        return this.attrDecls.getAllAttributes();
    }

    public void validate() throws SAXException {
        if (!this.otherContent && this.simpleContent == null && this.complexContent == null) {
            throw new LocSAXException("You must specify either of the 'simpleContent', 'complexContent', 'all', 'choice', 'sequence', or 'group' child elements.", this.owner.getLocator());
        }
    }

    @Override
    public XsTGroupRef createGroup() {
        return this.typeDefParticle.createGroup();
    }

    @Override
    public XsTAll createAll() {
        return this.typeDefParticle.createAll();
    }

    @Override
    public XsESequence createSequence() {
        return this.typeDefParticle.createSequence();
    }

    @Override
    public XsEChoice createChoice() {
        return this.typeDefParticle.createChoice();
    }

    @Override
    public XsTTypeDefParticle getTypeDefParticle() {
        return this.typeDefParticle.getTypeDefParticle();
    }
}

