/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.parser.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.ws.jaxme.xs.XSParser;
import org.apache.ws.jaxme.xs.parser.AttributeSetter;
import org.apache.ws.jaxme.xs.parser.XSContext;
import org.apache.ws.jaxme.xs.parser.XsSAXParser;
import org.xml.sax.SAXException;

public class AttributeSetterImpl
implements AttributeSetter {
    static final Class[] ONE_STRING_CLASS = new Class[]{String.class};
    private static final Class[] FOUR_STRING_CLASSES = new Class[]{String.class, String.class, String.class, String.class};
    private static final ParameterClass[] knownClasses = new ParameterClass[]{new BooleanClass(), new StringClass(), new ValueOfParameterClass(), new StringConstructorClass(), new CharacterClass(), new PrimitiveParameterClass(Long.TYPE, Long.class), new PrimitiveParameterClass(Integer.TYPE, Integer.class), new PrimitiveParameterClass(Short.TYPE, Short.class), new PrimitiveParameterClass(Byte.TYPE, Byte.class), new PrimitiveParameterClass(Double.TYPE, Double.class), new PrimitiveParameterClass(Float.TYPE, Float.class), new CharacterClass()};

    protected XSContext getData() {
        XSContext result = XSParser.getRunningInstance().getContext();
        if (result == null) {
            throw new IllegalStateException("Parser data is not set.");
        }
        return result;
    }

    @Override
    public void setAttribute(String pQName, String pNamespaceURI, String pLocalName, String pValue) throws SAXException {
        XsSAXParser handler = (XsSAXParser)this.getData().getCurrentContentHandler();
        if (handler == null) {
            throw new IllegalStateException("Current XsSAXParser is null.");
        }
        Object bean = ((XsSAXParser)this.getData().getCurrentContentHandler()).getBean();
        try {
            Method m = bean.getClass().getMethod("setAttribute", FOUR_STRING_CLASSES);
            if (Modifier.isPublic(m.getModifiers())) {
                Object[] o = new Object[]{pQName, pNamespaceURI, pLocalName, pValue};
                Object result = this.invokeMethod(bean, m, pQName, o);
                if (!Boolean.TYPE.equals(m.getReturnType()) || ((Boolean)result).booleanValue()) {
                    return;
                }
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (!this.setProperty(bean, pQName, pLocalName, pValue)) {
            throw new IllegalStateException("Unknown attribute of " + bean.getClass().getName() + ": " + pQName);
        }
    }

    protected Object invokeMethod(Object pBean, Method pMethod, String pName, Object[] pArgs) throws SAXException {
        try {
            return pMethod.invoke(pBean, pArgs);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof SAXException) {
                throw (SAXException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        catch (IllegalAccessException e) {
            StringBuffer sb = new StringBuffer("Failed to invoke method ");
            sb.append(pMethod.getName()).append(" of class ").append(pBean.getClass().getName());
            sb.append(" with argument ");
            for (int i = 0; i < pArgs.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(pArgs[i]);
            }
            sb.append(": ").append(e.getClass().getName()).append(", ").append(e.getMessage());
            throw new IllegalStateException(sb.toString());
        }
    }

    protected boolean setProperty(Object pBean, String pQName, String pName, String pValue) throws SAXException {
        Class<?> c = pBean.getClass();
        String s = "set" + Character.toUpperCase(pName.charAt(0)) + pName.substring(1);
        int parameterClassNum = knownClasses.length;
        Method[] methods = c.getMethods();
        Method method = null;
        Object methodObject = null;
        block0: for (int i = 0; i < methods.length; ++i) {
            Class<?>[] params;
            Method m = methods[i];
            if (!s.equals(m.getName()) || !Modifier.isPublic(m.getModifiers()) || (params = m.getParameterTypes()).length != 1) continue;
            Class<?> paramsClass = params[0];
            for (int j = 0; j < parameterClassNum; ++j) {
                ParameterClass parameterClass = knownClasses[j];
                Object o = parameterClass.matches(paramsClass);
                if (o == null) continue;
                parameterClassNum = j;
                method = m;
                methodObject = o;
                continue block0;
            }
        }
        if (method == null) {
            return false;
        }
        knownClasses[parameterClassNum].invoke(this, pBean, pValue, method, methodObject, pQName);
        return true;
    }

    private static class BooleanClass
    implements ParameterClass {
        private BooleanClass() {
        }

        @Override
        public Object matches(Class pClass) {
            return Boolean.TYPE.equals(pClass) || Boolean.class.equals((Object)pClass) ? Boolean.TRUE : null;
        }

        @Override
        public void invoke(AttributeSetterImpl pAttributeSetter, Object pBean, String pValue, Method pMethod, Object pMethodObject, String pQName) throws SAXException {
            Boolean b = "true".equals(pValue) || "1".equals(pValue) ? Boolean.TRUE : Boolean.FALSE;
            pAttributeSetter.invokeMethod(pBean, pMethod, pQName, new Object[]{b});
        }
    }

    private static class CharacterClass
    implements ParameterClass {
        private CharacterClass() {
        }

        @Override
        public Object matches(Class pClass) {
            return Character.TYPE.equals(pClass) || Character.class.equals((Object)pClass) ? Boolean.TRUE : null;
        }

        @Override
        public void invoke(AttributeSetterImpl pAttributeSetter, Object pBean, String pValue, Method pMethod, Object pMethodObject, String pQName) throws SAXException {
            if (pValue.length() != 1) {
                throw new IllegalArgumentException("Invalid value for '" + pQName + "': " + pValue + "; must have exactly one character.");
            }
            pAttributeSetter.invokeMethod(pBean, pMethod, pQName, new Object[]{new Character(pValue.charAt(0))});
        }
    }

    private static class PrimitiveParameterClass
    extends StringConstructorClass {
        private final Class primitiveClass;
        private final Class nonPrimitiveClass;
        private final Constructor stringConstructor;

        private PrimitiveParameterClass(Class pPrimitiveClass, Class pNonPrimitiveClass) {
            this.primitiveClass = pPrimitiveClass;
            this.nonPrimitiveClass = pNonPrimitiveClass;
            try {
                this.stringConstructor = pNonPrimitiveClass.getConstructor(ONE_STRING_CLASS);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("The primitive class " + pNonPrimitiveClass.getName() + " doesn't have a string valued constructor!");
            }
        }

        @Override
        public Object matches(Class pClass) {
            return this.primitiveClass.equals(pClass) || this.nonPrimitiveClass.equals(pClass) ? this.stringConstructor : null;
        }
    }

    private static class StringConstructorClass
    implements ParameterClass {
        private StringConstructorClass() {
        }

        @Override
        public Object matches(Class pClass) {
            try {
                Constructor con = pClass.getConstructor(ONE_STRING_CLASS);
                if (Modifier.isPublic(con.getModifiers())) {
                    return con;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void invoke(AttributeSetterImpl pAttributeSetter, Object pBean, String pValue, Method pMethod, Object pMethodObject, String pQName) throws SAXException {
            Object o;
            Constructor con = (Constructor)pMethodObject;
            try {
                o = con.newInstance(pValue);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Illegal argument for attribute '" + pQName + "': " + pValue + "; " + e.getTargetException().getClass().getName() + ", " + e.getTargetException().getMessage());
            }
            catch (InstantiationException e) {
                throw new IllegalStateException("Invalid access to constructor " + pBean.getClass().getName() + "(): " + e.getClass().getName() + ", " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Invalid access to constructor " + pBean.getClass().getName() + "(): " + e.getClass().getName() + ", " + e.getMessage());
            }
            pAttributeSetter.invokeMethod(pBean, pMethod, pQName, new Object[]{o});
        }
    }

    private static class ValueOfParameterClass
    implements ParameterClass {
        private ValueOfParameterClass() {
        }

        @Override
        public Object matches(Class pClass) {
            try {
                Method valueOfMethod = pClass.getMethod("valueOf", ONE_STRING_CLASS);
                if (Modifier.isPublic(valueOfMethod.getModifiers()) && !Void.TYPE.equals(valueOfMethod.getReturnType())) {
                    return valueOfMethod;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void invoke(AttributeSetterImpl pAttributeSetter, Object pBean, String pValue, Method pMethod, Object pMethodObject, String pQName) throws SAXException {
            Object o;
            Method m = (Method)pMethodObject;
            try {
                o = m.invoke(null, pValue);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Illegal argument for attribute '" + pQName + "': " + pValue + "; " + e.getTargetException().getClass().getName() + ", " + e.getTargetException().getMessage());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Invalid access to method " + m.getName() + " of class " + pBean.getClass() + ": IllegalAccessException, " + e.getMessage());
            }
            pAttributeSetter.invokeMethod(pBean, pMethod, pQName, new Object[]{o});
        }
    }

    private static class StringClass
    implements ParameterClass {
        private StringClass() {
        }

        @Override
        public Object matches(Class pClass) {
            return String.class.equals((Object)pClass) ? Boolean.TRUE : null;
        }

        @Override
        public void invoke(AttributeSetterImpl pAttributeSetter, Object pBean, String pValue, Method pMethod, Object pMethodObject, String pQName) throws SAXException {
            pAttributeSetter.invokeMethod(pBean, pMethod, pQName, new Object[]{pValue});
        }
    }

    private static interface ParameterClass {
        public Object matches(Class var1);

        public void invoke(AttributeSetterImpl var1, Object var2, String var3, Method var4, Object var5, String var6) throws SAXException;
    }
}

