/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.ws.jaxme.xs.XSModelGroup;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XSModelGroupImpl
implements XSModelGroup {
    private final XSModelGroup.Compositor compositor;
    private final List particles = new ArrayList();
    private final Locator locator;

    public XSModelGroupImpl(XSModelGroup.Compositor pCompositor, Locator pLocator) {
        if (pCompositor == null) {
            throw new NullPointerException("The model group compositor must not be null.");
        }
        this.compositor = pCompositor;
        this.locator = pLocator;
    }

    @Override
    public XSModelGroup.Compositor getCompositor() {
        return this.compositor;
    }

    @Override
    public boolean isSequence() {
        return XSModelGroup.SEQUENCE.equals(this.compositor);
    }

    @Override
    public boolean isChoice() {
        return XSModelGroup.CHOICE.equals(this.compositor);
    }

    @Override
    public boolean isAll() {
        return XSModelGroup.ALL.equals(this.compositor);
    }

    public void addParticle(XSParticle pParticle) throws SAXException {
        if (this.isAll() && (pParticle.getMaxOccurs() == -1 || pParticle.getMaxOccurs() > 1)) {
            throw new LocSAXException("Illegal 'maxOccurs' value inside 'all' group: " + pParticle.getMaxOccurs(), pParticle.getLocator());
        }
        if (pParticle.getMaxOccurs() != -1 && pParticle.getMaxOccurs() < pParticle.getMinOccurs()) {
            throw new LocSAXException("Illegal 'maxOccurs' value, which is lower than 'minOccurs' value: " + pParticle.getMaxOccurs() + " < " + pParticle.getMinOccurs(), pParticle.getLocator());
        }
        this.particles.add(pParticle);
    }

    @Override
    public XSParticle[] getParticles() {
        return this.particles.toArray(new XSParticle[this.particles.size()]);
    }

    @Override
    public void validate() throws SAXException {
        if (this.isChoice() && this.particles.size() == 0) {
            throw new LocSAXException("A 'choice' model group must have at least one 'group', 'any', or 'element'.", this.getLocator());
        }
        for (XSParticle particle : this.particles) {
            if (particle.isElement()) {
                particle.getElement().validate();
                continue;
            }
            if (particle.isGroup()) {
                particle.getGroup().validate();
                continue;
            }
            if (particle.isWildcard()) {
                particle.getWildcard().validate();
                continue;
            }
            throw new IllegalStateException("Invalid particle");
        }
    }

    @Override
    public Locator getLocator() {
        return this.locator;
    }
}

