/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.TransactionRequiredException;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.AssertionFailure;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.ejb.HibernateEntityManagerImplementor;
import org.hibernate.ejb.QueryImpl;
import org.hibernate.ejb.TransactionImpl;
import org.hibernate.ejb.transaction.JoinableCMTTransaction;
import org.hibernate.ejb.util.ConfigurationHelper;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.JTAHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityManagerImpl
implements HibernateEntityManagerImplementor,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityManagerImpl.class);
    protected transient TransactionImpl tx = new TransactionImpl(this);
    protected PersistenceContextType persistenceContextType;
    private FlushModeType flushModeType = FlushModeType.AUTO;
    private PersistenceUnitTransactionType transactionType;
    private Map properties;

    protected AbstractEntityManagerImpl(PersistenceContextType type, PersistenceUnitTransactionType transactionType, Map properties) {
        this.persistenceContextType = type;
        this.transactionType = transactionType;
        this.properties = properties != null ? properties : CollectionHelper.EMPTY_MAP;
    }

    protected void postInit() {
        Object flushMode;
        if (PersistenceUnitTransactionType.JTA.equals((Object)this.transactionType)) {
            this.joinTransaction(true);
        }
        if ((flushMode = this.properties.get("org.hibernate.flushMode")) != null) {
            this.getSession().setFlushMode(ConfigurationHelper.getFlushMode(flushMode));
        }
        this.properties = null;
    }

    public javax.persistence.Query createQuery(String ejbqlString) {
        try {
            return new QueryImpl(this.getSession().createQuery(ejbqlString), this);
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query createNamedQuery(String name) {
        Query namedQuery;
        try {
            namedQuery = this.getSession().getNamedQuery(name);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException("Named query not found: " + name);
        }
        try {
            return new QueryImpl(namedQuery, this);
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString) {
        try {
            SQLQuery q = this.getSession().createSQLQuery(sqlString);
            return new QueryImpl((Query)q, this);
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString, Class resultClass) {
        try {
            SQLQuery q = this.getSession().createSQLQuery(sqlString);
            q.addEntity("alias1", resultClass.getName(), LockMode.READ);
            return new QueryImpl((Query)q, this);
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return null;
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString, String resultSetMapping) {
        try {
            SQLQuery q = this.getSession().createSQLQuery(sqlString);
            q.setResultSetMapping(resultSetMapping);
            return new QueryImpl((Query)q, this);
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return null;
        }
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        try {
            return (T)this.getSession().load(entityClass, (Serializable)primaryKey);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return null;
        }
    }

    public <A> A find(Class<A> entityClass, Object primaryKey) {
        try {
            return (A)this.getSession().get(entityClass, (Serializable)primaryKey);
        }
        catch (ObjectDeletedException e) {
            return null;
        }
        catch (ObjectNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return null;
        }
    }

    private void checkTransactionNeeded() {
        if (this.persistenceContextType == PersistenceContextType.TRANSACTION && !this.isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress for a TRANSACTION type persistence context");
        }
    }

    public void persist(Object entity) {
        this.checkTransactionNeeded();
        try {
            this.getSession().persist(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
        }
    }

    public <A> A merge(A entity) {
        this.checkTransactionNeeded();
        try {
            return (A)this.getSession().merge(entity);
        }
        catch (ObjectDeletedException sse) {
            throw new IllegalArgumentException(sse);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return null;
        }
    }

    public void remove(Object entity) {
        this.checkTransactionNeeded();
        try {
            this.getSession().delete(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
        }
    }

    public void refresh(Object entity) {
        this.checkTransactionNeeded();
        try {
            if (!this.getSession().contains(entity)) {
                throw new IllegalArgumentException("Entity not managed");
            }
            this.getSession().refresh(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
        }
    }

    public boolean contains(Object entity) {
        try {
            if (entity != null && !(entity instanceof HibernateProxy) && this.getSession().getSessionFactory().getClassMetadata(entity.getClass()) == null) {
                throw new IllegalArgumentException("Not an entity:" + entity.getClass());
            }
            return this.getSession().contains(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return false;
        }
    }

    public void flush() {
        try {
            if (!this.isTransactionInProgress()) {
                throw new TransactionRequiredException("no transaction is in progress");
            }
            this.getSession().flush();
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
        }
    }

    @Override
    public abstract Session getSession();

    protected abstract Session getRawSession();

    public EntityTransaction getTransaction() {
        if (this.transactionType == PersistenceUnitTransactionType.JTA) {
            throw new IllegalStateException("A JTA EntityManager cannot use getTransaction()");
        }
        return this.tx;
    }

    public void setFlushMode(FlushModeType flushModeType) {
        this.flushModeType = flushModeType;
        if (flushModeType == FlushModeType.AUTO) {
            this.getSession().setFlushMode(FlushMode.AUTO);
        } else if (flushModeType == FlushModeType.COMMIT) {
            this.getSession().setFlushMode(FlushMode.COMMIT);
        } else {
            throw new AssertionFailure("Unknown FlushModeType: " + flushModeType);
        }
    }

    public void clear() {
        try {
            this.getSession().clear();
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
        }
    }

    public FlushModeType getFlushMode() {
        FlushMode mode = this.getSession().getFlushMode();
        if (mode == FlushMode.AUTO) {
            this.flushModeType = FlushModeType.AUTO;
        } else if (mode == FlushMode.COMMIT) {
            this.flushModeType = FlushModeType.COMMIT;
        } else {
            return null;
        }
        return this.flushModeType;
    }

    public void lock(Object entity, LockModeType lockMode) {
        try {
            if (!this.isTransactionInProgress()) {
                throw new TransactionRequiredException("no transaction is in progress");
            }
            if (!this.contains(entity)) {
                throw new IllegalArgumentException("entity not in the persistence context");
            }
            this.getSession().lock(entity, this.getLockMode(lockMode));
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
        }
    }

    private LockMode getLockMode(LockModeType lockMode) {
        switch (lockMode) {
            case READ: {
                return LockMode.UPGRADE;
            }
            case WRITE: {
                return LockMode.FORCE;
            }
        }
        throw new AssertionFailure("Unknown LockModeType: " + lockMode);
    }

    @Override
    public boolean isTransactionInProgress() {
        return ((SessionImplementor)this.getRawSession()).isTransactionInProgress();
    }

    protected void markAsRollback() {
        log.debug("mark transaction for rollback");
        if (this.tx.isActive()) {
            this.tx.setRollbackOnly();
        } else if (PersistenceUnitTransactionType.JTA == this.transactionType) {
            TransactionManager transactionManager = ((SessionFactoryImplementor)this.getRawSession().getSessionFactory()).getTransactionManager();
            if (transactionManager == null) {
                throw new PersistenceException("Using a JTA persistence context wo setting hibernate.transaction.manager_lookup_class");
            }
            try {
                transactionManager.setRollbackOnly();
            }
            catch (SystemException e) {
                throw new PersistenceException("Unable to set the JTA transaction as RollbackOnly", (Throwable)e);
            }
        }
    }

    public void joinTransaction() {
        this.joinTransaction(false);
    }

    private void joinTransaction(boolean ignoreNotJoining) {
        block10: {
            this.getSession().isOpen();
            if (this.transactionType == PersistenceUnitTransactionType.JTA) {
                try {
                    log.debug("Looking for a JTA transaction to join");
                    final Session session = this.getSession();
                    Transaction transaction = session.getTransaction();
                    if (transaction != null && transaction instanceof JoinableCMTTransaction) {
                        JoinableCMTTransaction joinableCMTTransaction = (JoinableCMTTransaction)transaction;
                        if (joinableCMTTransaction.getStatus() == JoinableCMTTransaction.JoinStatus.JOINED) {
                            log.debug("Transaction already joined");
                            return;
                        }
                        joinableCMTTransaction.markForJoined();
                        session.isOpen();
                        if (joinableCMTTransaction.getStatus() == JoinableCMTTransaction.JoinStatus.NOT_JOINED) {
                            if (ignoreNotJoining) {
                                log.debug("No JTA transaction found");
                                return;
                            }
                            throw new TransactionRequiredException("No active JTA transaction on joinTransaction call");
                        }
                        if (joinableCMTTransaction.getStatus() == JoinableCMTTransaction.JoinStatus.MARKED_FOR_JOINED) {
                            throw new AssertionFailure("Transaction MARKED_FOR_JOINED after isOpen() call");
                        }
                        log.trace("Adding flush() and close() synchronization");
                        joinableCMTTransaction.registerSynchronization(new Synchronization(){

                            public void beforeCompletion() {
                                boolean flush = false;
                                TransactionFactory.Context ctx = null;
                                try {
                                    ctx = (TransactionFactory.Context)session;
                                    JoinableCMTTransaction joinable = (JoinableCMTTransaction)session.getTransaction();
                                    javax.transaction.Transaction transaction = joinable.getTransaction();
                                    if (transaction == null) {
                                        log.warn("Transaction not available on beforeCompletionPhase: assuming valid");
                                    }
                                    flush = !ctx.isFlushModeNever() && (transaction == null || !JTAHelper.isRollback((int)transaction.getStatus()));
                                }
                                catch (SystemException se) {
                                    log.error("could not determine transaction status", (Throwable)se);
                                    AbstractEntityManagerImpl.this.throwPersistenceException(new PersistenceException("could not determine transaction status in beforeCompletion()", (Throwable)se));
                                }
                                catch (HibernateException he) {
                                    AbstractEntityManagerImpl.this.throwPersistenceException(he);
                                }
                                try {
                                    if (flush) {
                                        log.trace("automatically flushing session");
                                        ctx.managedFlush();
                                    } else {
                                        log.trace("skipping managed flushing");
                                    }
                                }
                                catch (RuntimeException re) {
                                    if (re instanceof HibernateException) {
                                        AbstractEntityManagerImpl.this.throwPersistenceException((HibernateException)((Object)re));
                                    }
                                    AbstractEntityManagerImpl.this.throwPersistenceException(new PersistenceException((Throwable)re));
                                }
                            }

                            public void afterCompletion(int status) {
                                try {
                                    if (4 == status && AbstractEntityManagerImpl.this.transactionType == PersistenceUnitTransactionType.JTA && session.isOpen()) {
                                        session.clear();
                                    }
                                    if (session.isOpen()) {
                                        JoinableCMTTransaction joinable = (JoinableCMTTransaction)session.getTransaction();
                                        joinable.resetStatus();
                                    }
                                }
                                catch (HibernateException e) {
                                    AbstractEntityManagerImpl.this.throwPersistenceException(e);
                                }
                            }
                        });
                        break block10;
                    }
                    log.warn("Cannot join transaction: do not override {}", (Object)"hibernate.transaction.factory_class");
                }
                catch (HibernateException he) {
                    this.throwPersistenceException(he);
                }
            } else if (!ignoreNotJoining) {
                log.warn("Calling joinTransaction() on a non JTA EntityManager");
            }
        }
    }

    public Object getDelegate() {
        return this.getSession();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.tx = new TransactionImpl(this);
    }

    @Override
    public void throwPersistenceException(PersistenceException e) {
        if (!(e instanceof NoResultException) && !(e instanceof javax.persistence.NonUniqueResultException)) {
            try {
                this.markAsRollback();
            }
            catch (Exception ne) {
                log.error("Unable to mark for rollback on PersistenceException: ", (Throwable)ne);
            }
        }
        throw e;
    }

    @Override
    public void throwPersistenceException(HibernateException e) {
        if (e instanceof StaleStateException) {
            PersistenceException pe = this.wrapStaleStateException((StaleStateException)e);
            this.throwPersistenceException(pe);
        } else if (e instanceof ObjectNotFoundException) {
            this.throwPersistenceException((PersistenceException)new EntityNotFoundException(e.getMessage()));
        } else if (e instanceof NonUniqueResultException) {
            this.throwPersistenceException((PersistenceException)new javax.persistence.NonUniqueResultException(e.getMessage()));
        } else if (e instanceof UnresolvableObjectException) {
            this.throwPersistenceException((PersistenceException)new EntityNotFoundException(e.getMessage()));
        } else {
            if (e instanceof QueryException) {
                throw new IllegalArgumentException(e);
            }
            if (e instanceof TransientObjectException) {
                try {
                    this.markAsRollback();
                }
                catch (Exception ne) {
                    log.error("Unable to mark for rollback on TransientObjectException: ", (Throwable)ne);
                }
                throw new IllegalStateException(e);
            }
            this.throwPersistenceException(new PersistenceException((Throwable)e));
        }
    }

    @Override
    public PersistenceException wrapStaleStateException(StaleStateException e) {
        OptimisticLockException pe;
        block7: {
            if (e instanceof StaleObjectStateException) {
                StaleObjectStateException sose = (StaleObjectStateException)e;
                Serializable identifier = sose.getIdentifier();
                if (identifier != null) {
                    try {
                        Object entity = this.getRawSession().load(sose.getEntityName(), identifier);
                        if (entity instanceof Serializable) {
                            pe = new OptimisticLockException(null, (Throwable)e, entity);
                            break block7;
                        }
                        pe = new OptimisticLockException((Throwable)e);
                    }
                    catch (EntityNotFoundException enfe) {
                        pe = new OptimisticLockException((Throwable)e);
                    }
                } else {
                    pe = new OptimisticLockException((Throwable)e);
                }
            } else {
                pe = new OptimisticLockException((Throwable)e);
            }
        }
        return pe;
    }
}

