/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractComponentDeployer;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeploymentVisitor;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.ejb3.common.deployers.spi.AttachmentNames;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBsDeployer
extends AbstractComponentDeployer<JBossMetaData, JBossEnterpriseBeanMetaData> {
    private static final Logger log = Logger.getLogger(EJBsDeployer.class);
    private static final JBossDeploymentVisitor deploymentVisitor = new JBossDeploymentVisitor();
    private String attachmentName = AttachmentNames.PROCESSED_METADATA;

    public EJBsDeployer() {
        this.addInput(this.attachmentName);
        this.setOutput(deploymentVisitor.getComponentType());
        this.setDeploymentVisitor((DeploymentVisitor)deploymentVisitor);
    }

    protected <U> void deploy(DeploymentUnit unit, DeploymentVisitor<U> visitor) throws DeploymentException {
        Object deployment = unit.getAttachment(this.attachmentName, visitor.getVisitorType());
        try {
            visitor.deploy(unit, deployment);
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + unit.getName()), (Throwable)t);
        }
    }

    protected <U> void undeploy(DeploymentUnit unit, DeploymentVisitor<U> visitor) {
        if (visitor == null) {
            return;
        }
        Object deployment = unit.getAttachment(this.attachmentName, visitor.getVisitorType());
        visitor.undeploy(unit, deployment);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JBossDeploymentVisitor
    extends AbstractDeploymentVisitor<JBossEnterpriseBeanMetaData, JBossMetaData> {
        private JBossDeploymentVisitor() {
        }

        public Class<JBossEnterpriseBeanMetaData> getComponentType() {
            return JBossEnterpriseBeanMetaData.class;
        }

        protected List<? extends JBossEnterpriseBeanMetaData> getComponents(JBossMetaData deployment) {
            if (deployment == null || !deployment.isEJB3x()) {
                return null;
            }
            JBossEnterpriseBeansMetaData enterpriseBeans = deployment.getEnterpriseBeans();
            if (enterpriseBeans == null) {
                log.warn((Object)("EJBTHREE-2095: did not find any beans in " + deployment + " which is a violation of the xsd"));
                return null;
            }
            return new ArrayList(enterpriseBeans);
        }

        protected String getComponentName(JBossEnterpriseBeanMetaData attachment) {
            return JBossEnterpriseBeanMetaData.class.getName() + "." + attachment.getEjbName();
        }

        public Class<JBossMetaData> getVisitorType() {
            return JBossMetaData.class;
        }
    }
}

