/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sourceforge.cobertura.util.Source;
import org.apache.log4j.Logger;

public class FileFinder {
    private static Logger LOGGER = Logger.getLogger(FileFinder.class);
    private Set sourceDirectories = new HashSet();
    private Map sourceFilesMap = new HashMap();

    public void addSourceDirectory(String directory) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Adding sourceDirectory=[" + directory + "]"));
        }
        directory = this.getCorrectedPath(directory);
        this.sourceDirectories.add(directory);
    }

    public void addSourceFile(String baseDir, String file) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Adding sourceFile baseDir=[" + baseDir + "] file=[" + file + "]"));
        }
        if (baseDir == null || file == null) {
            throw new NullPointerException();
        }
        file = this.getCorrectedPath(file);
        HashSet<String> container = (HashSet<String>)this.sourceFilesMap.get(baseDir = this.getCorrectedPath(baseDir));
        if (container == null) {
            container = new HashSet<String>();
            this.sourceFilesMap.put(baseDir, container);
        }
        container.add(file);
    }

    public File getFileForSource(String fileName) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Searching for file, name=[" + fileName + "]"));
        }
        fileName = this.getCorrectedPath(fileName);
        for (String directory : this.sourceDirectories) {
            File file = new File(directory, fileName);
            if (!file.isFile()) continue;
            LOGGER.debug((Object)"Found inside sourceDirectories");
            return file;
        }
        for (String directory : this.sourceFilesMap.keySet()) {
            File file;
            Set container = (Set)this.sourceFilesMap.get(directory);
            if (!container.contains(fileName) || !(file = new File(directory, fileName)).isFile()) continue;
            LOGGER.debug((Object)"Found inside sourceFilesMap");
            return file;
        }
        LOGGER.debug((Object)"File not found");
        throw new IOException("Cannot find source file, name=[" + fileName + "]");
    }

    public Source getSource(String fileName) {
        File file = null;
        try {
            file = this.getFileForSource(fileName);
            return new Source(new FileInputStream(file), file);
        }
        catch (IOException e) {
            return this.searchJarsForSource(fileName);
        }
    }

    private Source searchJarsForSource(String fileName) {
        for (String directory : this.sourceDirectories) {
            File file = new File(directory);
            String[] jars = file.list(new JarZipFilter());
            if (jars == null) continue;
            for (String jar : jars) {
                try {
                    LOGGER.debug((Object)("Looking for: " + fileName + " in " + jar));
                    JarFile jf = new JarFile(directory + "/" + jar);
                    Enumeration<JarEntry> files = jf.entries();
                    while (files.hasMoreElements()) {
                        JarEntry entry = files.nextElement();
                        if (!entry.getName().equals(fileName)) continue;
                        return new Source(jf.getInputStream(entry), jf);
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn((Object)("Error while reading " + jar), t);
                }
            }
        }
        return null;
    }

    public List getSourceDirectoryList() {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator<Object> it = this.sourceDirectories.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        it = this.sourceFilesMap.keySet().iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    private String getCorrectedPath(String path) {
        return path.replace('\\', '/');
    }

    public String toString() {
        return "FileFinder, source directories: " + this.getSourceDirectoryList().toString();
    }

    private class JarZipFilter
    implements FilenameFilter {
        private JarZipFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".jar") || name.endsWith(".zip");
        }
    }
}

