/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.client;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.ws.addressing.EndpointReference;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.Version;
import org.jboss.remoting.marshal.MarshalFactory;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.MessageAbstraction;
import org.jboss.ws.core.MessageTrace;
import org.jboss.ws.core.WSTimeoutException;
import org.jboss.ws.core.client.EndpointInfo;
import org.jboss.ws.core.client.RemoteConnection;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.feature.FastInfosetFeature;
import org.jboss.ws.metadata.config.CommonConfig;
import org.jboss.ws.metadata.umdm.EndpointMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPRemotingConnection
implements RemoteConnection {
    private static Logger log = Logger.getLogger(HTTPRemotingConnection.class);
    private Map<String, Object> clientConfig = new HashMap<String, Object>();
    private static Map<String, String> metadataMap = new HashMap<String, String>();
    private static Map<String, String> configMap;
    private boolean closed;
    private Integer chunkedLength;

    public HTTPRemotingConnection() {
        this.clientConfig.put("enableLease", false);
        this.clientConfig.put("unmarshalNullStream", "true");
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public Integer getChunkedLength() {
        return this.chunkedLength;
    }

    public void setChunkedLength(Integer chunkedLength) {
        this.chunkedLength = chunkedLength;
    }

    @Override
    public MessageAbstraction invoke(MessageAbstraction reqMessage, Object endpoint, boolean oneway) throws IOException {
        String targetAddress;
        if (endpoint == null) {
            throw new IllegalArgumentException("Given endpoint cannot be null");
        }
        if (this.closed) {
            throw new IOException("Connection is already closed");
        }
        Object timeout = null;
        Map<Object, Object> callProps = new HashMap();
        if (endpoint instanceof EndpointInfo) {
            EndpointInfo epInfo = (EndpointInfo)endpoint;
            targetAddress = epInfo.getTargetAddress();
            callProps = epInfo.getProperties();
            if (callProps.containsKey("org.jboss.ws.timeout")) {
                timeout = callProps.get("org.jboss.ws.timeout");
                this.clientConfig.put("timeout", timeout.toString());
            }
        } else if (endpoint instanceof EndpointReference) {
            EndpointReference epr = (EndpointReference)endpoint;
            targetAddress = epr.getAddress().toString();
        } else {
            targetAddress = endpoint.toString();
        }
        Map<String, Object> metadata = this.createRemotingMetaData(reqMessage, callProps);
        Marshaller marshaller = this.getMarshaller();
        UnMarshaller unmarshaller = this.getUnmarshaller();
        InvokerLocator locator = null;
        try {
            log.debug((Object)("Get locator for: " + endpoint));
            String version = this.getRemotingVersion();
            if (version.startsWith("1.4")) {
                targetAddress = this.addURLParameter(targetAddress, "datatype", "JBossWSMessage");
                MarshalFactory.addMarshaller((String)"JBossWSMessage", (Marshaller)marshaller, (UnMarshaller)unmarshaller);
            }
            locator = new InvokerLocator(targetAddress);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed endpoint address", e);
        }
        try {
            Client client = new Client(locator, "jbossws", this.clientConfig);
            client.connect();
            client.setMarshaller(marshaller);
            client.setUnMarshaller(unmarshaller);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remoting metadata: " + metadata));
            }
            MessageTrace.traceMessage("Outgoing Request Message", reqMessage);
            MessageAbstraction resMessage = null;
            if (oneway) {
                client.invokeOneway((Object)reqMessage, metadata, false);
            } else {
                resMessage = (MessageAbstraction)client.invoke((Object)reqMessage, metadata);
            }
            client.disconnect();
            callProps.clear();
            callProps.putAll(metadata);
            MessageTrace.traceMessage("Incoming Response Message", resMessage);
            return resMessage;
        }
        catch (Throwable th) {
            if (timeout != null && th.getCause() instanceof SocketTimeoutException) {
                throw new WSTimeoutException("Timeout after: " + timeout + "ms", new Long(timeout.toString()));
            }
            IOException io = new IOException("Could not transmit message");
            io.initCause(th);
            throw io;
        }
    }

    private String addURLParameter(String urlStr, String key, String value) throws MalformedURLException {
        URL url = new URL(urlStr);
        urlStr = urlStr + (url.getQuery() == null ? "?" : "&") + key + "=" + value;
        return urlStr;
    }

    private String getRemotingVersion() {
        String version = null;
        try {
            Field field = Version.class.getDeclaredField("VERSION");
            version = (String)field.get(null);
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot obtain remoting version", ex);
        }
        if (version == null) {
            URL codeURL = Version.class.getProtectionDomain().getCodeSource().getLocation();
            throw new RuntimeException("Cannot obtain remoting version from: " + codeURL);
        }
        return version;
    }

    private Map<String, Object> createRemotingMetaData(MessageAbstraction reqMessage, Map callProps) {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("NoThrowOnError", "true");
        if (reqMessage != null) {
            String sizeValue;
            this.populateHeaders(reqMessage, metadata);
            int chunkSizeValue = this.chunkedLength != null ? this.chunkedLength : 1024;
            boolean fastInfosetEnabled = false;
            if (msgContext != null) {
                EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
                CommonConfig config = epMetaData.getConfig();
                String sizeValue2 = config.getProperty("http://org.jboss.ws/http#chunksize");
                if (sizeValue2 != null) {
                    chunkSizeValue = Integer.valueOf(sizeValue2);
                }
                if (epMetaData.isFeatureEnabled(FastInfosetFeature.class)) {
                    fastInfosetEnabled = true;
                    chunkSizeValue = 0;
                }
            }
            if (!fastInfosetEnabled && (sizeValue = (String)callProps.get("http://org.jboss.ws/http#chunksize")) != null) {
                chunkSizeValue = Integer.valueOf(sizeValue);
            }
            if (chunkSizeValue > 0) {
                this.clientConfig.put("chunkedLength", String.valueOf(chunkSizeValue));
            } else {
                this.clientConfig.remove("chunkedLength");
            }
        } else {
            metadata.put("TYPE", "GET");
        }
        if (callProps != null) {
            Iterator it = callProps.entrySet().iterator();
            String authType = (String)callProps.get("org.jboss.ws.authType");
            if (authType == null) {
                authType = "org.jboss.ws.authType.basic";
            }
            while (it.hasNext()) {
                String remotingKey;
                Map.Entry entry = it.next();
                String key = (String)entry.getKey();
                Object val = entry.getValue();
                if (metadataMap.containsKey(key)) {
                    remotingKey = metadataMap.get(key);
                    if ("http.basic.username".equals(remotingKey) || "http.basic.password".equals(remotingKey)) {
                        if (authType.equals("org.jboss.ws.authType.basic")) {
                            metadata.put(remotingKey, val);
                        } else {
                            log.warn((Object)("Ignore '" + key + "' with auth typy: " + authType));
                        }
                    } else {
                        metadata.put(remotingKey, val);
                    }
                }
                if (!configMap.containsKey(key)) continue;
                remotingKey = configMap.get(key);
                this.clientConfig.put(remotingKey, val);
            }
        }
        return metadata;
    }

    protected void populateHeaders(MessageAbstraction reqMessage, Map<String, Object> metadata) {
        MimeHeaders mimeHeaders = reqMessage.getMimeHeaders();
        Properties props = new Properties();
        metadata.put("HEADER", props);
        Iterator i = mimeHeaders.getAllHeaders();
        while (i.hasNext()) {
            MimeHeader header = (MimeHeader)i.next();
            String currentValue = props.getProperty(header.getName());
            if (currentValue != null) {
                props.put(header.getName(), currentValue + "," + header.getValue());
                continue;
            }
            props.put(header.getName(), header.getValue());
        }
    }

    static {
        metadataMap.put("javax.xml.rpc.security.auth.username", "http.basic.username");
        metadataMap.put("javax.xml.rpc.security.auth.password", "http.basic.password");
        metadataMap.put("javax.xml.ws.security.auth.username", "http.basic.username");
        metadataMap.put("javax.xml.ws.security.auth.password", "http.basic.password");
        configMap = new HashMap<String, String>();
        configMap.put("org.jboss.ws.keyAlias", "org.jboss.remoting.keyAlias");
        configMap.put("org.jboss.ws.keyStore", "org.jboss.remoting.keyStore");
        configMap.put("org.jboss.ws.keyStoreAlgorithm", "org.jboss.remoting.keyStoreAlgorithm");
        configMap.put("org.jboss.ws.keyStorePassword", "org.jboss.remoting.keyStorePassword");
        configMap.put("org.jboss.ws.keyStoreType", "org.jboss.remoting.keyStoreType");
        configMap.put("org.jboss.ws.socketFactory", "socketFactoryClassName");
        configMap.put("org.jboss.ws.sslProtocol", "org.jboss.remoting.sslProtocol");
        configMap.put("org.jboss.ws.sslProviderName", "org.jboss.remoting.sslProviderName");
        configMap.put("org.jboss.ws.trustStore", "org.jboss.remoting.trustStore");
        configMap.put("org.jboss.ws.trustStoreAlgorithm", "org.jboss.remoting.truststoreAlgorithm");
        configMap.put("org.jboss.ws.trustStorePassword", "org.jboss.remoting.trustStorePassword");
        configMap.put("org.jboss.ws.trustStoreType", "org.jboss.remoting.trustStoreType");
    }
}

