/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.threads.InterruptHandler;
import org.jboss.threads.JBossThread;

public final class JBossThreadFactory
implements ThreadFactory {
    private final ThreadGroup threadGroup;
    private final Boolean daemon;
    private final Integer initialPriority;
    private final List<Appender> nameAppenderList;
    private final InterruptHandler[] interruptHandlers;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final Long stackSize;
    private final AtomicLong factoryThreadIndexSequence = new AtomicLong(1L);
    private final long factoryIndex;
    private static final AtomicLong globalThreadIndexSequence = new AtomicLong(1L);
    private static final AtomicLong factoryIndexSequence = new AtomicLong(1L);
    private static final Appender globalThreadIndexAppender = new Appender(){

        public void appendTo(StringBuilder target, ThreadSequenceInfo info) {
            target.append(info.getGlobalThreadNum());
        }
    };
    private static final Appender factoryIndexAppender = new Appender(){

        public void appendTo(StringBuilder target, ThreadSequenceInfo info) {
            target.append(info.getFactoryNum());
        }
    };
    private static final Appender perFactoryThreadIndexAppender = new Appender(){

        public void appendTo(StringBuilder target, ThreadSequenceInfo info) {
            target.append(info.getPerFactoryThreadNum());
        }
    };
    private static final Appender percentAppender = new Appender(){

        public void appendTo(StringBuilder target, ThreadSequenceInfo info) {
            target.append('%');
        }
    };
    private final Appender groupPathAppender;

    private static void appendParent(ThreadGroup group, StringBuilder builder) {
        ThreadGroup parent = group.getParent();
        if (parent != null) {
            JBossThreadFactory.appendParent(parent, builder);
            builder.append(':');
        }
        builder.append(group.getName());
    }

    public JBossThreadFactory(ThreadGroup threadGroup, Boolean daemon, Integer initialPriority, String namePattern, InterruptHandler[] interruptHandlers, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, Long stackSize) {
        if (threadGroup == null) {
            SecurityManager sm = System.getSecurityManager();
            threadGroup = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }
        this.threadGroup = threadGroup;
        this.daemon = daemon;
        this.initialPriority = initialPriority;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.interruptHandlers = interruptHandlers;
        this.stackSize = stackSize;
        StringBuilder builder = new StringBuilder();
        JBossThreadFactory.appendParent(threadGroup, builder);
        String groupPath = builder.toString();
        this.groupPathAppender = new StringAppender(groupPath);
        this.factoryIndex = factoryIndexSequence.getAndIncrement();
        if (namePattern == null) {
            namePattern = "pool-%f-thread-%t";
        }
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        int len = namePattern.length();
        int i = 0;
        while (true) {
            int n;
            if ((n = namePattern.indexOf(37, i)) == -1) {
                if (i >= len) break;
                appenders.add(new StringAppender(namePattern.substring(i)));
                break;
            }
            if (n > i) {
                appenders.add(new StringAppender(namePattern.substring(i, n)));
            }
            if (n >= len - 1) break;
            char c = namePattern.charAt(n + 1);
            switch (c) {
                case 't': {
                    appenders.add(perFactoryThreadIndexAppender);
                    break;
                }
                case 'g': {
                    appenders.add(globalThreadIndexAppender);
                    break;
                }
                case 'f': {
                    appenders.add(factoryIndexAppender);
                    break;
                }
                case 'p': {
                    appenders.add(this.groupPathAppender);
                    break;
                }
                case '%': {
                    appenders.add(percentAppender);
                }
            }
            i = n + 2;
        }
        this.nameAppenderList = appenders;
    }

    public Thread newThread(Runnable target) {
        return AccessController.doPrivileged(new ThreadCreateAction(target));
    }

    private static interface Appender {
        public void appendTo(StringBuilder var1, ThreadSequenceInfo var2);
    }

    private static final class ThreadSequenceInfo {
        private final long globalThreadNum;
        private final long perFactoryThreadNum;
        private final long factoryNum;

        private ThreadSequenceInfo(long globalThreadNum, long perFactoryThreadNum, long factoryNum) {
            this.globalThreadNum = globalThreadNum;
            this.perFactoryThreadNum = perFactoryThreadNum;
            this.factoryNum = factoryNum;
        }

        public long getGlobalThreadNum() {
            return this.globalThreadNum;
        }

        public long getPerFactoryThreadNum() {
            return this.perFactoryThreadNum;
        }

        public long getFactoryNum() {
            return this.factoryNum;
        }
    }

    private static final class StringAppender
    implements Appender {
        private final String string;

        private StringAppender(String string) {
            this.string = string;
        }

        public void appendTo(StringBuilder target, ThreadSequenceInfo info) {
            target.append(this.string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ThreadCreateAction
    implements PrivilegedAction<Thread> {
        private final Runnable target;

        private ThreadCreateAction(Runnable target) {
            this.target = target;
        }

        @Override
        public Thread run() {
            ThreadSequenceInfo info = new ThreadSequenceInfo(globalThreadIndexSequence.getAndIncrement(), JBossThreadFactory.this.factoryThreadIndexSequence.getAndIncrement(), JBossThreadFactory.this.factoryIndex);
            StringBuilder nameBuilder = new StringBuilder();
            for (Appender appender : JBossThreadFactory.this.nameAppenderList) {
                appender.appendTo(nameBuilder, info);
            }
            JBossThread thread = JBossThreadFactory.this.stackSize != null ? new JBossThread(JBossThreadFactory.this.interruptHandlers, JBossThreadFactory.this.threadGroup, this.target, nameBuilder.toString(), JBossThreadFactory.this.stackSize) : new JBossThread(JBossThreadFactory.this.interruptHandlers, JBossThreadFactory.this.threadGroup, this.target, nameBuilder.toString());
            if (JBossThreadFactory.this.initialPriority != null) {
                thread.setPriority(JBossThreadFactory.this.initialPriority);
            }
            if (JBossThreadFactory.this.daemon != null) {
                thread.setDaemon(JBossThreadFactory.this.daemon);
            }
            if (JBossThreadFactory.this.uncaughtExceptionHandler != null) {
                thread.setUncaughtExceptionHandler(JBossThreadFactory.this.uncaughtExceptionHandler);
            }
            return thread;
        }
    }
}

