## Command Line Interface (cli)

The __VDB Builder__ provides a command line environment which allows the user to accomplish many design functions without requiring use of a graphical environment.  

Some of the capabilities of __VDB Builder__ :

- Create and edit VDBs
- Import/Export VDBs from the file system.
- Create and edit data source definitions.
- Import/Export data source definitions from the file system.
- Connect to a live teiid server (requires admin/user credentials).
- View VDBs, data sources, data source types and translators on the connected server.
- Deploy VDBs and data sources from the VDB Builder workspace to the connected server.
- Undeploy VDBs or data sources from the connected server.
- Retrieve VDBs and data sources from the connected server and copy to the VDB Builder workspace.
- Deploy JDBC drivers from the file system to the connected server.


Below are links to additional documents that demonstrate and provide samples of many of the capabilities described above:

- [Install VDB Builder](install-cli.md)
- [Create a VDB interactively](create-vdb.md)
- [Import and Edit a VDB](import-edit-vdb.md)
- [Import and Export VDBs and DDL](import-export-vdbs-ddl.md)
- [Import and Export data sources](import-export-datasources.md)
- [Record Session commands to a file](record-cli-session.md)
- [Execute a Command file](execute-command-script.md)
- [Connect to a Server](connect-to-server.md)
- [Interact with server VDBs](server-vdb-interactions.md)
- [Interact with server data sources](server-datasource-interactions.md)
- [Deploy a new data source driver to a server](server-datasource-type-interactions.md)
- [More cli examples and test files](more-examples.md)

