/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal.document;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import org.infinispan.marshall.SerializeWith;
import org.infinispan.schematic.document.Array;
import org.infinispan.schematic.document.Binary;
import org.infinispan.schematic.document.Bson;
import org.infinispan.schematic.document.Code;
import org.infinispan.schematic.document.CodeWithScope;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.Json;
import org.infinispan.schematic.document.MaxKey;
import org.infinispan.schematic.document.MinKey;
import org.infinispan.schematic.document.Null;
import org.infinispan.schematic.document.ObjectId;
import org.infinispan.schematic.document.Symbol;
import org.infinispan.schematic.internal.document.ArrayEditor;
import org.infinispan.schematic.internal.document.BsonUtils;
import org.infinispan.schematic.internal.document.DocumentEditor;
import org.infinispan.schematic.internal.document.DocumentExternalizer;
import org.infinispan.schematic.internal.document.ImmutableField;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.schematic.internal.schema.DocumentTransformer;

@SerializeWith(value=DocumentExternalizer.class)
public class BasicDocument
extends LinkedHashMap<String, Object>
implements MutableDocument {
    private static final long serialVersionUID = 1L;
    private transient Map<String, Object> unmodifiableView;

    public BasicDocument() {
    }

    public BasicDocument(Document document) {
        this.putAll(document);
    }

    public BasicDocument(int initialCapacity) {
        super(initialCapacity);
    }

    public BasicDocument(String name, Object value) {
        if (name != null) {
            this.put(name, value);
        }
    }

    public BasicDocument(String name1, Object value1, String name2, Object value2) {
        if (name1 != null) {
            this.put(name1, value1);
        }
        if (name2 != null) {
            this.put(name2, value2);
        }
    }

    public BasicDocument(String name1, Object value1, String name2, Object value2, String name3, Object value3) {
        if (name1 != null) {
            this.put(name1, value1);
        }
        if (name2 != null) {
            this.put(name2, value2);
        }
        if (name3 != null) {
            this.put(name3, value3);
        }
    }

    public BasicDocument(String name1, Object value1, String name2, Object value2, String name3, Object value3, String name4, Object value4) {
        if (name1 != null) {
            this.put(name1, value1);
        }
        if (name2 != null) {
            this.put(name2, value2);
        }
        if (name3 != null) {
            this.put(name3, value3);
        }
        if (name4 != null) {
            this.put(name4, value4);
        }
    }

    @Override
    public boolean containsField(String name) {
        return this.containsKey(name);
    }

    @Override
    public boolean containsAll(Document document) {
        if (document == null) {
            return true;
        }
        for (Document.Field field : document.fields()) {
            Object thatValue;
            Object thisValue = this.get(field.getName());
            if (BsonUtils.valuesAreEqual(thisValue, thatValue = field.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object get(String name) {
        return super.get(name);
    }

    public Map<String, ?> toMap() {
        if (this.unmodifiableView == null) {
            this.unmodifiableView = Collections.unmodifiableMap(this);
        }
        return this.unmodifiableView;
    }

    @Override
    public Iterable<Document.Field> fields() {
        return new Iterable<Document.Field>(){

            @Override
            public Iterator<Document.Field> iterator() {
                final Iterator iter = BasicDocument.this.entrySet().iterator();
                return new Iterator<Document.Field>(){

                    @Override
                    public boolean hasNext() {
                        return iter.hasNext();
                    }

                    @Override
                    public Document.Field next() {
                        Map.Entry entry = (Map.Entry)iter.next();
                        return new ImmutableField((String)entry.getKey(), entry.getValue());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Boolean getBoolean(String name) {
        Object value = this.get(name);
        return value instanceof Boolean ? (Boolean)value : null;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        Object value = this.get(name);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    @Override
    public Integer getInteger(String name) {
        Object value = this.get(name);
        return value instanceof Integer ? (Integer)value : null;
    }

    @Override
    public int getInteger(String name, int defaultValue) {
        Object value = this.get(name);
        return value instanceof Integer ? (Integer)value : defaultValue;
    }

    @Override
    public Long getLong(String name) {
        Object value = this.get(name);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return new Long(((Integer)value).longValue());
        }
        return null;
    }

    @Override
    public long getLong(String name, long defaultValue) {
        Object value = this.get(name);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        return defaultValue;
    }

    @Override
    public Double getDouble(String name) {
        Object value = this.get(name);
        return value instanceof Double ? (Double)value : null;
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        Object value = this.get(name);
        return value instanceof Double ? (Double)value : defaultValue;
    }

    @Override
    public Number getNumber(String name) {
        Object value = this.get(name);
        return value instanceof Number ? (Number)((Number)value) : (Number)null;
    }

    @Override
    public Number getNumber(String name, Number defaultValue) {
        Object value = this.get(name);
        return value instanceof Number ? (Number)((Number)value) : (Number)defaultValue;
    }

    @Override
    public String getString(String name) {
        return this.getString(name, null);
    }

    @Override
    public String getString(String name, String defaultValue) {
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof Symbol) {
                return ((Symbol)value).getSymbol();
            }
        }
        return defaultValue;
    }

    @Override
    public List<?> getArray(String name) {
        Object value = this.get(name);
        return value instanceof List ? (List)value : null;
    }

    @Override
    public Document getDocument(String name) {
        Object value = this.get(name);
        return value instanceof Document ? (Document)value : null;
    }

    @Override
    public boolean isNull(String name) {
        return this.get(name) instanceof Null;
    }

    @Override
    public boolean isNullOrMissing(String name) {
        return Null.matches(this.get(name));
    }

    @Override
    public MaxKey getMaxKey(String name) {
        Object value = this.get(name);
        return value instanceof MaxKey ? (MaxKey)value : null;
    }

    @Override
    public MinKey getMinKey(String name) {
        Object value = this.get(name);
        return value instanceof MinKey ? (MinKey)value : null;
    }

    @Override
    public Code getCode(String name) {
        Object value = this.get(name);
        return value instanceof Code ? (Code)value : null;
    }

    @Override
    public CodeWithScope getCodeWithScope(String name) {
        Object value = this.get(name);
        return value instanceof CodeWithScope ? (CodeWithScope)value : null;
    }

    @Override
    public ObjectId getObjectId(String name) {
        Object value = this.get(name);
        return value instanceof ObjectId ? (ObjectId)value : null;
    }

    @Override
    public Binary getBinary(String name) {
        Object value = this.get(name);
        return value instanceof Binary ? (Binary)value : null;
    }

    @Override
    public Symbol getSymbol(String name) {
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof Symbol) {
                return (Symbol)value;
            }
            if (value instanceof String) {
                return new Symbol((String)value);
            }
        }
        return null;
    }

    @Override
    public Pattern getPattern(String name) {
        Object value = this.get(name);
        return value instanceof Pattern ? (Pattern)value : null;
    }

    @Override
    public UUID getUuid(String name) {
        return this.getUuid(name, null);
    }

    @Override
    public UUID getUuid(String name, UUID defaultValue) {
        Object value = this.get(name);
        if (value != null) {
            if (value instanceof UUID) {
                return (UUID)value;
            }
            if (value instanceof String) {
                try {
                    return UUID.fromString((String)value);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    @Override
    public int getType(String name) {
        return Bson.getTypeForValue(this.get(name));
    }

    @Override
    public void putAll(Document object) {
        if (object != this) {
            Map<String, Object> original = object instanceof BasicDocument ? (BasicDocument)object : object.toMap();
            for (Map.Entry<String, Object> entry : original.entrySet()) {
                this.put(entry.getKey(), this.unwrap(entry.getValue()));
            }
        }
    }

    @Override
    public Object remove(String name) {
        return super.remove(name);
    }

    @Override
    public void removeAll() {
        super.clear();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Iterable) {
            return false;
        }
        if (obj instanceof Document) {
            Document that = (Document)obj;
            if (this.size() != that.size()) {
                return false;
            }
            for (Document.Field thisField : this.fields()) {
                Object thatValue;
                Object thisValue = thisField.getValue();
                if (BsonUtils.valuesAreEqual(thisValue, thatValue = that.get(thisField.getName()))) continue;
                return false;
            }
            return true;
        }
        if (obj instanceof Map) {
            Map that = (Map)obj;
            if (this.size() != that.size()) {
                return false;
            }
            if (!this.keySet().equals(that.keySet())) {
                return false;
            }
            for (Document.Field thisField : this.fields()) {
                Object thatValue;
                Object thisValue = thisField.getValue();
                if (BsonUtils.valuesAreEqual(thisValue, thatValue = that.get(thisField.getName()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return Json.write(this);
    }

    @Override
    public Document clone() {
        BasicDocument clone = new BasicDocument();
        for (Document.Field field : this.fields()) {
            Object value = this.unwrap(field.getValue());
            if (value instanceof Array) {
                value = ((Array)value).clone();
            } else if (value instanceof Document) {
                value = ((Document)value).clone();
            }
            clone.put(field.getName(), value);
        }
        return clone;
    }

    @Override
    public Document with(Map<String, Object> changedFields) {
        BasicDocument clone = new BasicDocument();
        for (Document.Field field : this.fields()) {
            String name = field.getName();
            Object newValue = this.unwrap(changedFields.get(name));
            if (newValue != null) {
                clone.put(name, newValue);
                continue;
            }
            Object oldValue = field.getValue();
            clone.put(name, oldValue);
        }
        return clone;
    }

    @Override
    public Document with(String fieldName, Object newValue) {
        BasicDocument clone = new BasicDocument();
        newValue = this.unwrap(newValue);
        for (Document.Field field : this.fields()) {
            String name = field.getName();
            if (name.equals(fieldName)) {
                clone.put(name, newValue);
                continue;
            }
            Object oldValue = field.getValue();
            clone.put(name, oldValue);
        }
        return clone;
    }

    @Override
    public Document with(Document.ValueTransformer transformer) {
        boolean transformed = false;
        BasicDocument clone = new BasicDocument();
        for (Document.Field field : this.fields()) {
            String name = field.getName();
            Object oldValue = field.getValue();
            Object newValue = null;
            newValue = oldValue instanceof Document ? ((Document)oldValue).with(transformer) : transformer.transform(name, oldValue);
            if (newValue != oldValue) {
                transformed = true;
            }
            clone.put(name, this.unwrap(newValue));
        }
        return transformed ? clone : this;
    }

    @Override
    public Document withVariablesReplaced(Properties properties) {
        return this.with(new DocumentTransformer.PropertiesTransformer(properties));
    }

    @Override
    public Document withVariablesReplacedWithSystemProperties() {
        return this.with(new DocumentTransformer.SystemPropertiesTransformer());
    }

    protected Object unwrap(Object value) {
        if (value instanceof DocumentEditor) {
            return this.unwrap(((DocumentEditor)value).unwrap());
        }
        if (value instanceof ArrayEditor) {
            return this.unwrap(((ArrayEditor)value).unwrap());
        }
        return value;
    }
}

