/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.schematic.internal;

import java.util.Collection;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.schematic.SchematicDb;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.internal.SchematicEntryLiteral;
import org.infinispan.schematic.internal.document.DocumentEditor;
import org.infinispan.schematic.internal.document.MutableDocument;
import org.infinispan.transaction.LockingMode;

public class CacheSchematicDb
implements SchematicDb {
    private final String name;
    private final AdvancedCache<String, SchematicEntry> store;
    private final AdvancedCache<String, SchematicEntry> lockingStore;
    private final boolean explicitLocking;

    public CacheSchematicDb(AdvancedCache<String, SchematicEntry> store) {
        this.store = store;
        this.name = store.getName();
        this.explicitLocking = store.getCacheConfiguration().transaction().lockingMode() == LockingMode.PESSIMISTIC;
        this.lockingStore = this.explicitLocking ? store.withFlags(new Flag[]{Flag.FAIL_SILENTLY}).getAdvancedCache() : store;
    }

    public void start() {
        this.store.start();
    }

    public void stop() {
        this.store.stop();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Cache<String, SchematicEntry> getCache() {
        return this.store;
    }

    @Override
    public SchematicEntry get(String key) {
        return (SchematicEntry)this.store.get((Object)key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.store.containsKey((Object)key);
    }

    @Override
    public SchematicEntry put(String key, Document document) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key, document);
        SchematicEntry oldValue = (SchematicEntry)this.store.put((Object)key, (Object)newEntry);
        return oldValue != null ? this.removedResult(key, oldValue) : null;
    }

    protected SchematicEntry removedResult(String key, SchematicEntry entry) {
        SchematicEntryLiteral literal = (SchematicEntryLiteral)entry;
        literal.markRemoved(true);
        return literal;
    }

    @Override
    public SchematicEntry put(Document entryDocument) {
        SchematicEntry oldValue;
        Document metadata = entryDocument.getDocument("metadata");
        Object content = entryDocument.get("content");
        if (metadata == null || content == null) {
            throw new IllegalArgumentException("The supplied document is not of the required format");
        }
        String key = metadata.getString("id");
        if (key == null) {
            throw new IllegalArgumentException("The supplied document is not of the required format");
        }
        SchematicEntryLiteral newEntry = null;
        if (content instanceof Document) {
            newEntry = new SchematicEntryLiteral(metadata, (Document)content);
        }
        return (oldValue = (SchematicEntry)this.store.put((Object)key, newEntry)) != null ? this.removedResult(key, oldValue) : null;
    }

    @Override
    public SchematicEntry putIfAbsent(String key, Document document) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key, document);
        SchematicEntry existingEntry = (SchematicEntry)this.store.putIfAbsent((Object)key, (Object)newEntry);
        return existingEntry;
    }

    @Override
    public SchematicEntry replace(String key, Document document) {
        SchematicEntryLiteral newEntry = new SchematicEntryLiteral(key, document);
        return this.removedResult(key, (SchematicEntry)this.store.replace((Object)key, (Object)newEntry));
    }

    @Override
    public SchematicEntry remove(String key) {
        SchematicEntry existing = (SchematicEntry)this.store.remove((Object)key);
        return existing == null ? null : this.removedResult(key, existing);
    }

    @Override
    public EditableDocument editContent(String key, boolean createIfMissing) {
        return this.editContent(key, createIfMissing, true);
    }

    @Override
    public EditableDocument editContent(String key, boolean createIfMissing, boolean acquireLock) {
        SchematicEntryLiteral literal = (SchematicEntryLiteral)this.store.get((Object)key);
        if (literal == null) {
            if (!createIfMissing) {
                return null;
            }
            literal = new SchematicEntryLiteral(key);
            this.store.put((Object)key, (Object)literal);
            return new DocumentEditor((MutableDocument)literal.getContent());
        }
        return literal.edit(key, this.store, this.shouldAcquireLock(acquireLock));
    }

    private AdvancedCache<String, SchematicEntry> shouldAcquireLock(boolean acquireLockRequested) {
        return this.explicitLocking && acquireLockRequested ? this.lockingStore : null;
    }

    @Override
    public boolean lock(Collection<String> keys) {
        return !this.explicitLocking || keys.isEmpty() ? true : this.lockingStore.lock(keys);
    }

    @Override
    public boolean lock(String key) {
        return !this.explicitLocking ? true : this.lockingStore.lock((Object[])new String[]{key});
    }
}

