/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Value;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.junit.SkipLongRunning;
import org.modeshape.jcr.sequencer.AbstractSequencerTest;
import org.modeshape.sequencer.teiid.VdbSequencer;

public class VdbSequencerTest
extends AbstractSequencerTest {
    protected InputStream getRepositoryConfigStream() {
        return this.resourceStream("config/repo-config.json");
    }

    @Test
    public void shouldHaveValidCnds() throws Exception {
        this.registerNodeTypes("org/modeshape/sequencer/teiid/xmi.cnd");
        this.registerNodeTypes("org/modeshape/sequencer/teiid/jdbc.cnd");
        this.registerNodeTypes("org/modeshape/sequencer/teiid/mmcore.cnd");
        this.registerNodeTypes("org/modeshape/sequencer/teiid/relational.cnd");
        this.registerNodeTypes("org/modeshape/sequencer/teiid/transformation.cnd");
        this.registerNodeTypes("org/modeshape/sequencer/teiid/vdb.cnd");
    }

    @Test
    public void shouldSequenceBooksVDB() throws Exception {
        this.createNodeWithContentFromFile("BooksVDB.vdb", "model/books/BooksVDB.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/BooksVDB.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
        Assert.assertThat((Object)outputNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"This is a VDB description"));
        Assert.assertThat((Object)outputNode.getProperty("vdb:version").getLong(), (Matcher)Is.is((Object)2L));
        Assert.assertThat((Object)outputNode.getProperty("vdb:preview").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)outputNode.getProperty("query-timeout").getLong(), (Matcher)Is.is((Object)10000L));
        Node modelNode = outputNode.getNode("BooksProcedures.xmi");
        Assert.assertThat((Object)modelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:model"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:pathInVdb").getString(), (Matcher)Is.is((Object)"TestRESTWarGen/BooksProcedures.xmi"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:visible").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)modelNode.getProperty("vdb:builtIn").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)modelNode.getProperty("vdb:checksum").getLong(), (Matcher)Is.is((Object)1855484649L));
        Assert.assertThat((Object)modelNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"This is a model description"));
        Assert.assertThat((Object)modelNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"VIRTUAL"));
        Assert.assertThat((Object)modelNode.getProperty("modelClass").getString(), (Matcher)Is.is((Object)"Relational"));
        Assert.assertThat((Object)modelNode.getProperty("indexName").getString(), (Matcher)Is.is((Object)"1159106455.INDEX"));
        modelNode = outputNode.getNode("MyBooks.xmi");
        Assert.assertThat((Object)modelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:model"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:pathInVdb").getString(), (Matcher)Is.is((Object)"TestRESTWarGen/MyBooks.xmi"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:visible").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)modelNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"PHYSICAL"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:builtIn").getBoolean(), (Matcher)Is.is((Object)false));
        Node sourcesNode = modelNode.getNode("vdb:sources");
        Assert.assertNotNull((Object)sourcesNode);
        Assert.assertThat((Object)sourcesNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:sources"));
        Node sourceNode = sourcesNode.getNode("MyBooks");
        Assert.assertNotNull((Object)sourceNode);
        Assert.assertThat((Object)sourceNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:source"));
        Assert.assertThat((Object)sourceNode.getProperty("vdb:sourceTranslator").getString(), (Matcher)Is.is((Object)"MyBooks_mysql5"));
        Assert.assertThat((Object)sourceNode.getProperty("vdb:sourceJndiName").getString(), (Matcher)Is.is((Object)"MyBooks"));
        Assert.assertThat((Object)modelNode.getProperty("modelClass").getString(), (Matcher)Is.is((Object)"Relational"));
        Assert.assertThat((Object)modelNode.getProperty("indexName").getString(), (Matcher)Is.is((Object)"718925066.INDEX"));
        modelNode = outputNode.getNode("MyBooksView.xmi");
        Assert.assertThat((Object)modelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:model"));
        Assert.assertThat((Object)modelNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"VIRTUAL"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:pathInVdb").getString(), (Matcher)Is.is((Object)"TestRESTWarGen/MyBooksView.xmi"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:visible").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)modelNode.getProperty("vdb:builtIn").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)modelNode.getProperty("vdb:checksum").getLong(), (Matcher)Is.is((Object)825941341L));
        Assert.assertThat((Object)modelNode.getProperty("modelClass").getString(), (Matcher)Is.is((Object)"Relational"));
        Assert.assertThat((Object)modelNode.getProperty("indexName").getString(), (Matcher)Is.is((Object)"2173178531.INDEX"));
        Node booksTable = modelNode.getNode("BOOKS");
        Assert.assertThat((Object)booksTable.isNodeType("transform:transformed"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)booksTable.hasProperty("transform:transformedFromNames"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)booksTable.getProperty("transform:transformedFromNames").getValues().length, (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)booksTable.getProperty("transform:transformedFromNames").getValues()[0].getString(), (Matcher)Is.is((Object)"BOOKS"));
        Node markersGroupNode = modelNode.getNode("vdb:markers");
        Assert.assertNotNull((Object)markersGroupNode);
        NodeIterator itr = markersGroupNode.getNodes();
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)3L));
        String message1 = "The name BOOKS is the same (ignoring case) as 1 other object(s) under the same parent";
        String message2 = "Group does not exist: MyBooksView.BOOKS";
        String message3 = "The name BOOKS is the same (ignoring case) as 1 other object(s) under the same parent";
        int messagesFound = 0;
        while (itr.hasNext()) {
            Node node = itr.nextNode();
            Assert.assertThat((Object)node.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:marker"));
            Assert.assertThat((Object)node.getProperty("vdb:path").getString(), (Matcher)Is.is((Object)"BOOKS"));
            Assert.assertThat((Object)node.getProperty("vdb:severity").getString(), (Matcher)Is.is((Object)"ERROR"));
            if (node.getProperty("vdb:message").getString().equals(message1)) {
                ++messagesFound;
                message1 = "message1 found";
                continue;
            }
            if (node.getProperty("vdb:message").getString().equals(message2)) {
                ++messagesFound;
                message2 = "message2 found";
                continue;
            }
            if (!node.getProperty("vdb:message").getString().equals(message3)) continue;
            ++messagesFound;
            message3 = "message3 found";
        }
        Assert.assertThat((Object)messagesFound, (Matcher)Is.is((Object)3));
        boolean entry1Found = false;
        boolean entry2Found = false;
        Node entriesGroupNode = outputNode.getNode("vdb:entries");
        Assert.assertNotNull((Object)entriesGroupNode);
        Assert.assertThat((Object)entriesGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:entries"));
        NodeIterator itr2 = entriesGroupNode.getNodes();
        Assert.assertThat((Object)itr2.getSize(), (Matcher)Is.is((Object)2L));
        while (itr2.hasNext()) {
            Node entryNode = itr2.nextNode();
            Assert.assertThat((Object)entryNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:entry"));
            if (!entry1Found && "path1".equals(entryNode.getProperty("vdb:path").getString())) {
                entry1Found = true;
                Assert.assertThat((Object)entryNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"This is entry 1 description"));
                Assert.assertThat((Object)entryNode.getProperty("drummer").getString(), (Matcher)Is.is((Object)"Ringo"));
                Assert.assertThat((Object)entryNode.getProperty("guitar").getString(), (Matcher)Is.is((Object)"John"));
                continue;
            }
            if (!entry2Found && "path2".equals(entryNode.getProperty("vdb:path").getString())) {
                entry2Found = true;
                Assert.assertThat((Object)entryNode.getProperty("vdb:path").getString(), (Matcher)Is.is((Object)"path2"));
                Assert.assertThat((Object)entryNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"This is entry 2 description"));
                Assert.assertThat((Object)entryNode.getProperty("bass").getString(), (Matcher)Is.is((Object)"Paul"));
                Assert.assertThat((Object)entryNode.getProperty("leadGuitar").getString(), (Matcher)Is.is((Object)"George"));
                continue;
            }
            Assert.fail();
        }
        Assert.assertThat((Object)(entry1Found && entry2Found ? 1 : 0), (Matcher)Is.is((Object)true));
        Node translatorsGroupNode = outputNode.getNode("vdb:translators");
        Assert.assertNotNull((Object)translatorsGroupNode);
        Assert.assertThat((Object)translatorsGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:translators"));
        Assert.assertThat((Object)translatorsGroupNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node translatorNode = translatorsGroupNode.getNode("MyBooks_mysql5");
        Assert.assertNotNull((Object)translatorNode);
        Assert.assertThat((Object)translatorNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:translator"));
        Assert.assertThat((Object)translatorNode.getProperty("vdb:type").getString(), (Matcher)Is.is((Object)"mysql5"));
        Assert.assertThat((Object)translatorNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"This is a translator description"));
        Assert.assertThat((Object)translatorNode.getProperty("nameInSource").getString(), (Matcher)Is.is((Object)"bogusName"));
        Assert.assertThat((Object)translatorNode.getProperty("supportsUpdate").getBoolean(), (Matcher)Is.is((Object)true));
        Node dataRolesGroupNode = outputNode.getNode("vdb:dataRoles");
        Assert.assertNotNull((Object)dataRolesGroupNode);
        Assert.assertThat((Object)dataRolesGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:dataRoles"));
        Assert.assertThat((Object)dataRolesGroupNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node dataRoleNode = dataRolesGroupNode.getNode("My Data Role");
        Assert.assertNotNull((Object)dataRoleNode);
        Assert.assertThat((Object)dataRoleNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:dataRole"));
        Assert.assertThat((Object)dataRoleNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"my data role description"));
        Assert.assertThat((Object)dataRoleNode.getProperty("vdb:allowCreateTemporaryTables").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)dataRoleNode.getProperty("vdb:anyAuthenticated").getBoolean(), (Matcher)Is.is((Object)true));
        Value[] roleNames = dataRoleNode.getProperty("vdb:mappedRoleNames").getValues();
        Assert.assertThat((Object)roleNames.length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)("Sledge".equals(roleNames[0].getString()) || "Sledge".equals(roleNames[1].getString()) ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)("Hammer".equals(roleNames[0].getString()) || "Hammer".equals(roleNames[1].getString()) ? 1 : 0), (Matcher)Is.is((Object)true));
        Node permissionsGroupNode = dataRoleNode.getNode("vdb:permissions");
        Assert.assertNotNull((Object)permissionsGroupNode);
        Assert.assertThat((Object)permissionsGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permissions"));
        Assert.assertThat((Object)permissionsGroupNode.getNodes().getSize(), (Matcher)Is.is((Object)3L));
        Node permNode = permissionsGroupNode.getNode("BooksProcedures");
        Assert.assertNotNull((Object)permNode);
        Assert.assertThat((Object)permNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permission"));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowCreate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowRead").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowUpdate").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowDelete").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowExecute").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowAlter").getBoolean(), (Matcher)Is.is((Object)false));
        permNode = permissionsGroupNode.getNode("sysadmin");
        Assert.assertNotNull((Object)permNode);
        Assert.assertThat((Object)permNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permission"));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowCreate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowRead").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowUpdate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowDelete").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowExecute").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowAlter").getBoolean(), (Matcher)Is.is((Object)false));
        permNode = permissionsGroupNode.getNode("MyBooks");
        Assert.assertNotNull((Object)permNode);
        Assert.assertThat((Object)permNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permission"));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowCreate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowRead").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowUpdate").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowDelete").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowExecute").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowAlter").getBoolean(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldExtractVersionInformation() {
        this.assertVersionInfo("something", "something", 1);
        this.assertVersionInfo("something.else", "something.else", 1);
        this.assertVersionInfo("something else", "something else", 1);
        this.assertVersionInfo("something.", "something", 1);
        this.assertVersionInfo("something.1", "something", 1);
        this.assertVersionInfo("something.12", "something", 12);
        this.assertVersionInfo("something.123", "something", 123);
        this.assertVersionInfo("something.4", "something", 4);
        this.assertVersionInfo("something.-4", "something", 4);
        this.assertVersionInfo("something.+4", "something", 4);
        this.assertVersionInfo("something. 4", "something", 4);
        this.assertVersionInfo("something.  4", "something", 4);
        this.assertVersionInfo("something.  -4", "something", 4);
        this.assertVersionInfo("something.  -1234  ", "something", 1234);
    }

    @Test
    public void shouldSequenceVdbTopPartsVDB() throws Exception {
        this.createNodeWithContentFromFile("vdb/TopPartsVDB.vdb", "vdb/TopPartsVDB.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/TopPartsVDB.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
        Node importVdbsGroupNode = outputNode.getNode("vdb:importVdbs");
        Assert.assertNotNull((Object)importVdbsGroupNode);
        Assert.assertThat((Object)importVdbsGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:importVdbs"));
        Assert.assertThat((Object)importVdbsGroupNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node importVdbNode = importVdbsGroupNode.getNode("PartsVDB");
        Assert.assertNotNull((Object)importVdbNode);
        Assert.assertThat((Object)importVdbNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:importVdb"));
        Assert.assertThat((Object)importVdbNode.getProperty("vdb:version").getLong(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)importVdbNode.getProperty("vdb:importDataPolicies").getBoolean(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldSequenceVdbBooksVdb() throws Exception {
        this.createNodeWithContentFromFile("vdb/BooksVdb.vdb", "vdb/BooksVdb.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/BooksVdb.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
        Assert.assertThat((Object)outputNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"This is a VDB description"));
        Assert.assertThat((Object)outputNode.getProperty("vdb:version").getLong(), (Matcher)Is.is((Object)1L));
        Assert.assertThat((Object)outputNode.getProperty("vdb:preview").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)outputNode.getProperty("query-timeout").getLong(), (Matcher)Is.is((Object)1000000L));
        Node modelNode = outputNode.getNode("Books_Oracle.xmi");
        Assert.assertThat((Object)modelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:model"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:pathInVdb").getString(), (Matcher)Is.is((Object)"BooksProject/Books_Oracle.xmi"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:visible").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)modelNode.getProperty("vdb:builtIn").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)modelNode.getProperty("vdb:checksum").getLong(), (Matcher)Is.is((Object)4164741764L));
        Assert.assertThat((Object)modelNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"PHYSICAL"));
        Assert.assertThat((Object)modelNode.getProperty("modelClass").getString(), (Matcher)Is.is((Object)"Relational"));
        Assert.assertThat((Object)modelNode.getProperty("indexName").getString(), (Matcher)Is.is((Object)"1388555674.INDEX"));
        Node sourcesNode = modelNode.getNode("vdb:sources");
        Assert.assertNotNull((Object)sourcesNode);
        Assert.assertThat((Object)sourcesNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:sources"));
        Node sourceNode = sourcesNode.getNode("Books_Oracle");
        Assert.assertNotNull((Object)sourceNode);
        Assert.assertThat((Object)sourceNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:source"));
        Assert.assertThat((Object)sourceNode.getProperty("vdb:sourceTranslator").getString(), (Matcher)Is.is((Object)"oracle"));
        Assert.assertThat((Object)sourceNode.getProperty("vdb:sourceJndiName").getString(), (Matcher)Is.is((Object)"Books_Oracle"));
        modelNode = outputNode.getNode("BooksView.xmi");
        Assert.assertThat((Object)modelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:model"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:pathInVdb").getString(), (Matcher)Is.is((Object)"BooksProject/BooksView.xmi"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:visible").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)modelNode.getProperty("vdb:builtIn").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)modelNode.getProperty("vdb:checksum").getLong(), (Matcher)Is.is((Object)2513252863L));
        Assert.assertThat((Object)modelNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"VIRTUAL"));
        Assert.assertThat((Object)modelNode.getProperty("modelClass").getString(), (Matcher)Is.is((Object)"Relational"));
        Assert.assertThat((Object)modelNode.getProperty("indexName").getString(), (Matcher)Is.is((Object)"3982965936.INDEX"));
        Node modelImport = modelNode.getNode("Books_Oracle");
        Assert.assertNotNull((Object)modelImport);
        Assert.assertThat((Object)modelImport.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"mmcore:import"));
        Assert.assertThat((Object)modelImport.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"PHYSICAL"));
        Assert.assertThat((Object)modelImport.getProperty("mmcore:primaryMetamodelUri").getString(), (Matcher)Is.is((Object)"http://www.metamatrix.com/metamodels/Relational"));
        Assert.assertThat((Object)modelImport.getProperty("mmcore:modelLocation").getString(), (Matcher)Is.is((Object)"Books_Oracle.xmi"));
        Assert.assertThat((Object)modelImport.getProperty("mmcore:path").getString(), (Matcher)Is.is((Object)"/BooksProject/Books_Oracle.xmi"));
        Node dataRolesGroupNode = outputNode.getNode("vdb:dataRoles");
        Assert.assertNotNull((Object)dataRolesGroupNode);
        Assert.assertThat((Object)dataRolesGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:dataRoles"));
        Assert.assertThat((Object)dataRolesGroupNode.getNodes().getSize(), (Matcher)Is.is((Object)2L));
        Node dataRoleNode = dataRolesGroupNode.getNode("Another Data role");
        Assert.assertNotNull((Object)dataRoleNode);
        Assert.assertThat((Object)dataRoleNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:dataRole"));
        Assert.assertThat((Object)dataRoleNode.getProperty("vdb:allowCreateTemporaryTables").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)dataRoleNode.getProperty("vdb:anyAuthenticated").getBoolean(), (Matcher)Is.is((Object)false));
        Value[] roleNames = dataRoleNode.getProperty("vdb:mappedRoleNames").getValues();
        Assert.assertThat((Object)roleNames.length, (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)("Role name 1".equals(roleNames[0].getString()) || "Role name 1".equals(roleNames[1].getString()) ? 1 : 0), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)("Another role name".equals(roleNames[0].getString()) || "Another role name".equals(roleNames[1].getString()) ? 1 : 0), (Matcher)Is.is((Object)true));
        Node permissionsGroupNode = dataRoleNode.getNode("vdb:permissions");
        Assert.assertNotNull((Object)permissionsGroupNode);
        Assert.assertThat((Object)permissionsGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permissions"));
        Assert.assertThat((Object)permissionsGroupNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node permNode = permissionsGroupNode.getNode("Books_Oracle");
        Assert.assertNotNull((Object)permNode);
        Assert.assertThat((Object)permNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permission"));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowCreate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowRead").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowUpdate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowDelete").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowExecute").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowAlter").getBoolean(), (Matcher)Is.is((Object)false));
        dataRoleNode = dataRolesGroupNode.getNode("MyDataRole");
        Assert.assertNotNull((Object)dataRoleNode);
        Assert.assertThat((Object)dataRoleNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:dataRole"));
        Assert.assertThat((Object)dataRoleNode.getProperty("vdb:description").getString(), (Matcher)Is.is((Object)"This is a data role description"));
        Assert.assertThat((Object)dataRoleNode.getProperty("vdb:allowCreateTemporaryTables").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)dataRoleNode.getProperty("vdb:anyAuthenticated").getBoolean(), (Matcher)Is.is((Object)false));
        permissionsGroupNode = dataRoleNode.getNode("vdb:permissions");
        Assert.assertNotNull((Object)permissionsGroupNode);
        Assert.assertThat((Object)permissionsGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permissions"));
        Assert.assertThat((Object)permissionsGroupNode.getNodes().getSize(), (Matcher)Is.is((Object)2L));
        permNode = permissionsGroupNode.getNode("Books_Oracle");
        Assert.assertNotNull((Object)permNode);
        Assert.assertThat((Object)permNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permission"));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowCreate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowRead").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowUpdate").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowDelete").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowExecute").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowAlter").getBoolean(), (Matcher)Is.is((Object)true));
        permNode = permissionsGroupNode.getNode("sysadmin");
        Assert.assertNotNull((Object)permNode);
        Assert.assertThat((Object)permNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:permission"));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowCreate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowRead").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowUpdate").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowDelete").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowExecute").getBoolean(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)permNode.getProperty("vdb:allowAlter").getBoolean(), (Matcher)Is.is((Object)false));
    }

    @Test
    @SkipLongRunning
    public void shouldSequenceVdbBqtVdb() throws Exception {
        this.createNodeWithContentFromFile("vdb/BqtVdb.vdb", "vdb/BqtVdb.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/BqtVdb.vdb", 60);
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
        Assert.assertThat((Object)outputNode.getNodes("*.xmi").getSize(), (Matcher)Is.is((Object)60L));
        Node entriesGroupNode = outputNode.getNode("vdb:entries");
        Assert.assertNotNull((Object)entriesGroupNode);
        Assert.assertThat((Object)entriesGroupNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:entries"));
        NodeIterator itr = entriesGroupNode.getNodes();
        Assert.assertThat((Object)itr.getSize(), (Matcher)Is.is((Object)2L));
    }

    @Test
    public void shouldSequenceVdbFirstPartsVdb() throws Exception {
        this.createNodeWithContentFromFile("vdb/FirstParts.vdb", "vdb/FirstParts.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/FirstParts.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
    }

    @Test
    public void shouldSequenceVdbPartsVdb() throws Exception {
        this.createNodeWithContentFromFile("vdb/PartsVdb.vdb", "vdb/PartsVdb.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/PartsVdb.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
    }

    @Test
    public void shouldSequenceVdbPortfolioViewVdb() throws Exception {
        this.createNodeWithContentFromFile("vdb/PortfolioView.vdb", "vdb/PortfolioView.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/PortfolioView.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
    }

    @Test
    public void shouldSequenceVdbPortfolioVdb() throws Exception {
        this.createNodeWithContentFromFile("vdb/Portfolio.vdb", "vdb/Portfolio.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/Portfolio.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
        Assert.assertThat((Object)outputNode.getNodes().getSize(), (Matcher)Is.is((Object)4L));
    }

    @Test
    public void shouldSequenceVdbPortfolioVdb2() throws Exception {
        this.createNodeWithContentFromFile("vdb/Portfolio2.vdb", "vdb/Portfolio2.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/Portfolio2.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
        Assert.assertThat((Object)outputNode.getNodes().getSize(), (Matcher)Is.is((Object)4L));
        Node modelNode = outputNode.getNode("MarketData.xmi");
        Assert.assertNotNull((Object)modelNode);
        Node medGroupNode = modelNode.getNode("mmcore:modelExtensionDefinitions");
        Assert.assertNotNull((Object)modelNode);
        Node relationalMedNode = medGroupNode.getNode("relational");
        Assert.assertNotNull((Object)modelNode);
        Assert.assertThat((Object)relationalMedNode.hasProperty("modelExtensionDefinition:version"), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)relationalMedNode.getProperty("modelExtensionDefinition:version").getLong(), (Matcher)Is.is((Object)4L));
        Assert.assertThat((Object)this.session.getNamespacePrefix("http://www.teiid.org/ext/relational/2012/4"), (Matcher)Is.is((Object)"relational4"));
        Node procedureNode = modelNode.getNode("getFiles");
        Assert.assertNotNull((Object)procedureNode);
        Assert.assertThat((Object)procedureNode.hasProperty("relational4:aggregate"), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldSequenceVdbGatewayVDBVdb() throws Exception {
        this.createNodeWithContentFromFile("vdb/GatewayVDB.vdb", "vdb/GatewayVDB.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/GatewayVDB.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
        Assert.assertThat((Object)outputNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
        Node modelNode = outputNode.getNode("HSQLDB.xmi");
        Assert.assertNotNull((Object)modelNode);
        Node tableNode = modelNode.getNode("GATEWAY_TABLE");
        Assert.assertNotNull((Object)tableNode);
    }

    @Test
    public void shouldSequenceVdbBooksOTestVdb() throws Exception {
        this.createNodeWithContentFromFile("vdb/BooksOTest.vdb", "vdb/BooksOTest.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/BooksOTest.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
        Assert.assertThat((Object)outputNode.getNodes().getSize(), (Matcher)Is.is((Object)1L));
    }

    @Test
    public void shouldSequenceVdbFinancialsLinuxVdb() throws Exception {
        this.createNodeWithContentFromFile("vdb/Financials_Linux.vdb", "vdb/Financials_Linux.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/Financials_Linux.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
        Assert.assertThat((Object)outputNode.getNodes().getSize(), (Matcher)Is.is((Object)5L));
        Node modelNode = outputNode.getNode("US_CustomerAccounts_VBL.xmi");
        Assert.assertNotNull((Object)modelNode);
        Assert.assertThat((Object)modelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:model"));
        Assert.assertThat((Object)modelNode.getProperty("vdb:pathInVdb").getString(), (Matcher)Is.is((Object)"Financials/VirtualBaseLayer/US_CustomerAccounts_VBL.xmi"));
    }

    @Test
    public void shouldSequenceVdbTwitterVdb() throws Exception {
        this.createNodeWithContentFromFile("vdb/twitter.vdb", "vdb/twitter.vdb");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/twitter.vdb");
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
        Assert.assertThat((Object)outputNode.getNodes().getSize(), (Matcher)Is.is((Object)3L));
        Node declarativeModelNode = outputNode.getNode("twitter");
        Assert.assertNotNull((Object)declarativeModelNode);
        Assert.assertThat((Object)declarativeModelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:declarativeModel"));
        Assert.assertThat((Object)declarativeModelNode.getProperty("vdb:visible").getBoolean(), (Matcher)Is.is((Object)true));
        Node sourcesNode = declarativeModelNode.getNode("vdb:sources");
        Assert.assertNotNull((Object)sourcesNode);
        Assert.assertThat((Object)sourcesNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:sources"));
        Node sourceNode = sourcesNode.getNode("twitter");
        Assert.assertNotNull((Object)sourceNode);
        Assert.assertThat((Object)sourceNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:source"));
        Assert.assertThat((Object)sourceNode.getProperty("vdb:sourceTranslator").getString(), (Matcher)Is.is((Object)"rest"));
        Assert.assertThat((Object)sourceNode.getProperty("vdb:sourceJndiName").getString(), (Matcher)Is.is((Object)"java:/twitterDS"));
        Assert.assertThat((Object)declarativeModelNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"PHYSICAL"));
        declarativeModelNode = outputNode.getNode("twitterview");
        Assert.assertNotNull((Object)declarativeModelNode);
        Assert.assertThat((Object)declarativeModelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:declarativeModel"));
        Assert.assertThat((Object)declarativeModelNode.getProperty("vdb:visible").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)declarativeModelNode.getProperty("vdb:metadataType").getString(), (Matcher)Is.is((Object)"DDL"));
        Assert.assertThat((Object)declarativeModelNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"VIRTUAL"));
        String metadata = "CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140)) AS select tweet.* from (call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w, XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns created_on string PATH 'created_at', from_user string PATH 'from_user', to_user string PATH 'to_user', profile_image_url string PATH 'profile_image_url', source string PATH 'source', text string PATH 'text') tweet; CREATE VIEW Tweet AS select * FROM twitterview.getTweets;";
        Assert.assertThat((Object)declarativeModelNode.getProperty("vdb:modelDefinition").getString(), (Matcher)Is.is((Object)"CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140)) AS select tweet.* from (call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w, XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns created_on string PATH 'created_at', from_user string PATH 'from_user', to_user string PATH 'to_user', profile_image_url string PATH 'profile_image_url', source string PATH 'source', text string PATH 'text') tweet; CREATE VIEW Tweet AS select * FROM twitterview.getTweets;"));
    }

    @Test
    public void shouldSequenceDynamicTwitterVdb() throws Exception {
        this.createNodeWithContentFromFile("vdb/declarativeModels-vdb.xml", "vdb/declarativeModels-vdb.xml");
        Node outputNode = this.getOutputNode(this.rootNode, "vdbs/declarativeModels-vdb.xml", 100);
        Assert.assertNotNull((Object)outputNode);
        Assert.assertThat((Object)outputNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:virtualDatabase"));
        Assert.assertThat((Object)outputNode.getNodes().getSize(), (Matcher)Is.is((Object)3L));
        Node declarativeModelNode = outputNode.getNode("twitter");
        Assert.assertNotNull((Object)declarativeModelNode);
        Assert.assertThat((Object)declarativeModelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:declarativeModel"));
        Assert.assertThat((Object)declarativeModelNode.getProperty("vdb:visible").getBoolean(), (Matcher)Is.is((Object)true));
        Node sourcesNode = declarativeModelNode.getNode("vdb:sources");
        Assert.assertNotNull((Object)sourcesNode);
        Assert.assertThat((Object)sourcesNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:sources"));
        Node sourceNode = sourcesNode.getNode("twitter");
        Assert.assertNotNull((Object)sourceNode);
        Assert.assertThat((Object)sourceNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:source"));
        Assert.assertThat((Object)sourceNode.getProperty("vdb:sourceTranslator").getString(), (Matcher)Is.is((Object)"rest"));
        Assert.assertThat((Object)sourceNode.getProperty("vdb:sourceJndiName").getString(), (Matcher)Is.is((Object)"java:/twitterDS"));
        Assert.assertThat((Object)declarativeModelNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"PHYSICAL"));
        declarativeModelNode = outputNode.getNode("twitterview");
        Assert.assertNotNull((Object)declarativeModelNode);
        Assert.assertThat((Object)declarativeModelNode.getPrimaryNodeType().getName(), (Matcher)Is.is((Object)"vdb:declarativeModel"));
        Assert.assertThat((Object)declarativeModelNode.getProperty("vdb:visible").getBoolean(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)declarativeModelNode.getProperty("vdb:metadataType").getString(), (Matcher)Is.is((Object)"DDL"));
        Assert.assertThat((Object)declarativeModelNode.getProperty("mmcore:modelType").getString(), (Matcher)Is.is((Object)"VIRTUAL"));
        String metadata = "CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140)) AS select tweet.* from (call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w, XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns created_on string PATH 'created_at', from_user string PATH 'from_user', to_user string PATH 'to_user', profile_image_url string PATH 'profile_image_url', source string PATH 'source', text string PATH 'text') tweet; CREATE VIEW Tweet AS select * FROM twitterview.getTweets;";
        Assert.assertThat((Object)declarativeModelNode.getProperty("vdb:modelDefinition").getString(), (Matcher)Is.is((Object)"CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25), profile_image_url varchar(25), source varchar(25), text varchar(140)) AS select tweet.* from (call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w, XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns created_on string PATH 'created_at', from_user string PATH 'from_user', to_user string PATH 'to_user', profile_image_url string PATH 'profile_image_url', source string PATH 'source', text string PATH 'text') tweet; CREATE VIEW Tweet AS select * FROM twitterview.getTweets;"));
    }

    @Test
    @FixFor(value={"MODE-2476"})
    public void shouldSequenceSuccessiveVDBs() throws Exception {
        this.createNodeWithContentFromFile("first.vdb", "vdb/BooksVdb.vdb");
        Assert.assertNotNull((Object)this.getOutputNode(this.rootNode, "vdbs/first.vdb"));
        this.createNodeWithContentFromFile("second.vdb", "vdb/FirstParts.vdb");
        Assert.assertNotNull((Object)this.getOutputNode(this.rootNode, "vdbs/second.vdb"));
        this.createNodeWithContentFromFile("third.vdb", "vdb/BooksVdb.vdb");
        Assert.assertNotNull((Object)this.getOutputNode(this.rootNode, "vdbs/third.vdb"));
    }

    @Test
    @FixFor(value={"MODE-2477"})
    public void shouldSequenceVanillaVDB() throws Exception {
        this.createNodeWithContentFromFile("vanilla.vdb", "vdb/QT_Vanilla_Hive_Push.vdb");
        Assert.assertNotNull((Object)this.getOutputNode(this.rootNode, "vdbs/vanilla.vdb"));
    }

    protected void assertVersionInfo(String fileNameWithoutExtension, String expectedName, int expectedVersion) {
        AtomicInteger actual = new AtomicInteger(1);
        String name = VdbSequencer.extractVersionInformation((String)fileNameWithoutExtension, (AtomicInteger)actual);
        Assert.assertThat((Object)name, (Matcher)Is.is((Object)expectedName));
        Assert.assertThat((Object)actual.get(), (Matcher)Is.is((Object)expectedVersion));
    }
}

