/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dna.repository.util;

import org.jboss.dna.common.util.ArgCheck;
import org.jboss.dna.repository.util.ExecutionContext;
import org.jboss.dna.repository.util.JcrNamespaceRegistry;
import org.jboss.dna.repository.util.JcrTools;
import org.jboss.dna.repository.util.SessionFactory;
import org.jboss.dna.spi.graph.NamespaceRegistry;
import org.jboss.dna.spi.graph.PropertyFactory;
import org.jboss.dna.spi.graph.ValueFactories;
import org.jboss.dna.spi.graph.impl.BasicPropertyFactory;
import org.jboss.dna.spi.graph.impl.StandardValueFactories;

public class SimpleExecutionContext
implements ExecutionContext {
    private final JcrTools tools = new JcrTools();
    private final PropertyFactory propertyFactory;
    private final SessionFactory sessionFactory;
    private final ValueFactories valueFactories;
    private final NamespaceRegistry namespaceRegistry;

    public SimpleExecutionContext(SessionFactory sessionFactory, String repositoryWorkspaceForNamespaceRegistry) {
        this(sessionFactory, new JcrNamespaceRegistry(sessionFactory, repositoryWorkspaceForNamespaceRegistry), null, null);
    }

    public SimpleExecutionContext(SessionFactory sessionFactory, NamespaceRegistry namespaceRegistry) {
        this(sessionFactory, namespaceRegistry, null, null);
    }

    public SimpleExecutionContext(SessionFactory sessionFactory, NamespaceRegistry namespaceRegistry, ValueFactories valueFactories, PropertyFactory propertyFactory) {
        ArgCheck.isNotNull((Object)sessionFactory, (String)"session factory");
        ArgCheck.isNotNull((Object)namespaceRegistry, (String)"namespace registry");
        this.sessionFactory = sessionFactory;
        this.namespaceRegistry = namespaceRegistry;
        this.valueFactories = valueFactories != null ? valueFactories : new StandardValueFactories(this.namespaceRegistry);
        this.propertyFactory = propertyFactory != null ? propertyFactory : new BasicPropertyFactory(this.valueFactories);
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.namespaceRegistry;
    }

    public ValueFactories getValueFactories() {
        return this.valueFactories;
    }

    public PropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public JcrTools getTools() {
        return this.tools;
    }
}

