/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.teiid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;

public class VdbDataRole
implements Comparable<VdbDataRole> {
    private final String name;
    private boolean anyAuthenticated;
    private boolean allowCreateTempTables;
    private boolean grantAll;
    private String description;
    private final List<Permission> permissions = new ArrayList<Permission>();
    private final List<String> roleNames = new ArrayList<String>();

    public VdbDataRole(String name) {
        CheckArg.isNotEmpty((String)name, (String)"name");
        this.name = name;
    }

    @Override
    public int compareTo(VdbDataRole that) {
        CheckArg.isNotNull((Object)that, (String)"that");
        if (this == that) {
            return 0;
        }
        return this.name.compareTo(that.name);
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getMappedRoleNames() {
        return this.roleNames;
    }

    public String getName() {
        return this.name;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public boolean isAllowCreateTempTables() {
        return this.allowCreateTempTables;
    }

    public boolean isAnyAuthenticated() {
        return this.anyAuthenticated;
    }

    public boolean isGrantAll() {
        return this.grantAll;
    }

    public void setAllowCreateTempTables(boolean newValue) {
        this.allowCreateTempTables = newValue;
    }

    public void setAnyAuthenticated(boolean newValue) {
        this.anyAuthenticated = newValue;
    }

    public void setDescription(String newValue) {
        this.description = StringUtil.isBlank((String)newValue) ? "" : newValue;
    }

    public void setGrantAll(boolean grantAll) {
        this.grantAll = grantAll;
    }

    public class Mask {
        private int order;
        private String rule;

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public String getRule() {
            return this.rule;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }
    }

    public class Condition {
        private boolean constraint = true;
        private String rule;

        public boolean isConstraint() {
            return this.constraint;
        }

        public void setConstraint(boolean constraint) {
            this.constraint = constraint;
        }

        public String getRule() {
            return this.rule;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }
    }

    public class Permission {
        private boolean alter;
        private boolean create;
        private boolean delete;
        private boolean execute;
        private boolean read;
        private final String resourceName;
        private boolean update;
        private boolean language;
        private List<Condition> conditions = Collections.emptyList();
        private List<Mask> masks = Collections.emptyList();

        public Permission(String resourceName) {
            CheckArg.isNotEmpty((String)resourceName, (String)"resourceName");
            this.resourceName = resourceName;
        }

        public void allowAlter(boolean newValue) {
            this.alter = newValue;
        }

        public void allowCreate(boolean newValue) {
            this.create = newValue;
        }

        public void allowDelete(boolean newValue) {
            this.delete = newValue;
        }

        public void allowExecute(boolean newValue) {
            this.execute = newValue;
        }

        public void allowRead(boolean newValue) {
            this.read = newValue;
        }

        public void allowUpdate(boolean newValue) {
            this.update = newValue;
        }

        public void allowLanguage(boolean language) {
            this.language = language;
        }

        public boolean canAlter() {
            return this.alter;
        }

        public boolean canCreate() {
            return this.create;
        }

        public boolean canDelete() {
            return this.delete;
        }

        public boolean canExecute() {
            return this.execute;
        }

        public boolean canRead() {
            return this.read;
        }

        public boolean canUpdate() {
            return this.update;
        }

        public boolean useLanguage() {
            return this.language;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public List<Condition> getConditions() {
            return this.conditions;
        }

        public void setConditions(List<Condition> conditions) {
            this.conditions = conditions;
        }

        public List<Mask> getMasks() {
            return this.masks;
        }

        public void setMasks(List<Mask> masks) {
            this.masks = masks;
        }
    }
}

