/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import java.math.BigDecimal;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.modeshape.jcr.query.lucene.FieldUtil;
import org.modeshape.jcr.query.lucene.basic.DynamicField;

public class DynamicFieldBridge
implements FieldBridge {
    private static final Integer TRUE_INT = 1;
    private static final Integer FALSE_INT = 0;

    public final void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        for (DynamicField field = (DynamicField)value; field != null; field = field.getNext()) {
            this.addField(field, document, luceneOptions);
        }
    }

    protected final void addField(DynamicField field, Document document, LuceneOptions analyzedOptions) {
        LuceneOptions options;
        boolean analyzed = field.isAnalyzed();
        boolean stored = field.isStored();
        Object value = field.getValue();
        String name = field.getFieldName();
        LuceneOptions luceneOptions = analyzed ? analyzedOptions : (options = stored ? this.storedNotAnalyzedField(name) : this.notStoredNotAnalyzedField(name));
        if (value instanceof Object[]) {
            for (Object arrayValue : (Object[])value) {
                this.addField(options, name, arrayValue, document);
            }
        } else {
            this.addField(options, name, value, document);
        }
    }

    protected final void addField(LuceneOptions options, String fieldName, Object value, Document document) {
        if (value instanceof String) {
            options.addFieldToDocument(fieldName, (String)value, document);
            return;
        }
        if (value instanceof Boolean) {
            Boolean bValue = (Boolean)value;
            Integer iValue = bValue != false ? TRUE_INT : FALSE_INT;
            options.addNumericFieldToDocument(fieldName, (Object)iValue, document);
        } else if (value instanceof Integer) {
            options.addNumericFieldToDocument(fieldName, (Object)((Integer)value), document);
        } else if (value instanceof Long) {
            options.addNumericFieldToDocument(fieldName, value, document);
        } else if (value instanceof Float) {
            options.addNumericFieldToDocument(fieldName, (Object)((Float)value).floatValue(), document);
        } else if (value instanceof Double) {
            options.addNumericFieldToDocument(fieldName, value, document);
        } else if (value instanceof BigDecimal) {
            String strValue = FieldUtil.decimalToString((BigDecimal)value);
            options.addFieldToDocument(fieldName, strValue, document);
        } else {
            assert (value != null);
            assert (false) : "Unexpected field value of type " + value.getClass() + ": " + value;
        }
    }

    private LuceneOptions storedNotAnalyzedField(String fieldName) {
        DocumentFieldMetadata storedNotAnalyzedMetadata = new DocumentFieldMetadata.Builder(fieldName, Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO).boost(Float.valueOf(1.0f)).build();
        return new LuceneOptionsImpl(storedNotAnalyzedMetadata);
    }

    private LuceneOptions notStoredNotAnalyzedField(String fieldName) {
        DocumentFieldMetadata notStoredNotAnalyzedMetadata = new DocumentFieldMetadata.Builder(fieldName, Store.NO, Field.Index.NOT_ANALYZED, Field.TermVector.NO).boost(Float.valueOf(1.0f)).build();
        return new LuceneOptionsImpl(notStoredNotAnalyzedMetadata);
    }
}

