/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import java.util.Properties;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.modeshape.jcr.query.lucene.LuceneSearchConfiguration;
import org.modeshape.jcr.query.lucene.basic.DynamicFieldBridge;
import org.modeshape.jcr.query.lucene.basic.NodeInfo;

public class BasicLuceneConfiguration
extends LuceneSearchConfiguration {
    public BasicLuceneConfiguration(String repositoryName, Properties backend, Properties indexing, Properties storage) {
        super(NodeInfo.class, DynamicFieldBridge.class);
        String storageType = this.initStorageProperties(repositoryName, storage);
        this.initIndexingProperties(indexing);
        this.initBackendProperties(storageType, backend);
    }

    private String initStorageProperties(String repositoryName, Properties storage) {
        String storageType = storage.getProperty("type");
        if (storageType.equals("ram")) {
            this.setProperty("hibernate.search.default.directory_provider", "ram");
        } else if (storageType.equals("filesystem")) {
            String indexBase = storage.getProperty("location");
            String lockingStrategy = storage.getProperty("lockingStrategy");
            String accessType = storage.getProperty("fileSystemAccessType");
            this.setProperty("hibernate.search.default.directory_provider", "filesystem");
            this.setProperty("hibernate.search.default.indexBase", indexBase);
            this.setProperty("hibernate.search.default.locking_strategy", lockingStrategy);
            this.setProperty("hibernate.search.default.filesystem_access_type", accessType);
        } else if (storageType.equals("filesystem-master")) {
            String indexBase = storage.getProperty("location");
            String sourceBase = storage.getProperty("sourceLocation");
            String lockingStrategy = storage.getProperty("lockingStrategy");
            String accessType = storage.getProperty("fileSystemAccessType");
            String refresh = storage.getProperty("refreshInSeconds");
            String bufferSize = storage.getProperty("copyBufferSizeInMegabytes");
            this.setProperty("hibernate.search.default.directory_provider", "filesystem-master");
            this.setProperty("hibernate.search.default.indexBase", indexBase);
            this.setProperty("hibernate.search.default.sourceBase", sourceBase);
            this.setProperty("hibernate.search.default.refresh", refresh);
            this.setProperty("hibernate.search.default.buffer_size_on_copy", bufferSize);
            this.setProperty("hibernate.search.default.locking_strategy", lockingStrategy);
            this.setProperty("hibernate.search.default.filesystem_access_type", accessType);
        } else if (storageType.equals("filesystem-slave")) {
            String indexBase = storage.getProperty("location");
            String sourceBase = storage.getProperty("sourceLocation");
            String lockingStrategy = storage.getProperty("lockingStrategy");
            String accessType = storage.getProperty("fileSystemAccessType");
            String refresh = storage.getProperty("refreshInSeconds");
            String bufferSize = storage.getProperty("copyBufferSizeInMegabytes");
            String retryMarkerLookup = storage.getProperty("retryMarkerLookup");
            String retryInitializePeriod = storage.getProperty("retryInitializePeriodInSeconds");
            this.setProperty("hibernate.search.default.directory_provider", "filesystem-slave");
            this.setProperty("hibernate.search.default.indexBase", indexBase);
            this.setProperty("hibernate.search.default.sourceBase", sourceBase);
            this.setProperty("hibernate.search.default.refresh", refresh);
            this.setProperty("hibernate.search.default.buffer_size_on_copy", bufferSize);
            this.setProperty("hibernate.search.default.retry_marker_lookup", retryMarkerLookup);
            this.setProperty("hibernate.search.default.retry_initialize_period", retryInitializePeriod);
            this.setProperty("hibernate.search.default.locking_strategy", lockingStrategy);
            this.setProperty("hibernate.search.default.filesystem_access_type", accessType);
        } else if (storageType.equals("custom")) {
            storageType = storage.getProperty("classname");
            this.setProperty("hibernate.search.default.directory_provider", storageType);
            for (Object keyObj : storage.keySet()) {
                String key = keyObj.toString();
                if (key.equals("classname") || key.equals("classloader") || key.equals("type")) continue;
                this.setProperty("hibernate.search.default." + key, storage.getProperty(key));
            }
        }
        return storageType;
    }

    private void initIndexingProperties(Properties indexing) {
        String analyzer = indexing.getProperty("analyzer");
        if (!StandardAnalyzer.class.getName().equals(analyzer)) {
            this.setProperty("hibernate.search.analyzer", analyzer);
        }
        String similarity = indexing.getProperty("similarity");
        this.setProperty("hibernate.search.similarity", similarity);
        String batchSize = indexing.getProperty("batchSize");
        this.setProperty("hibernate.search.batch_size", batchSize);
        String indexFormat = indexing.getProperty("indexFormat");
        this.setProperty("hibernate.search.lucene_version", indexFormat);
        String readerStrategy = indexing.getProperty("readerStrategy");
        this.setProperty("hibernate.search.reader.strategy", readerStrategy);
        String mode = indexing.getProperty("mode");
        this.setProperty("hibernate.search.default.worker.execution", mode);
        String asyncThreadPoolSize = indexing.getProperty("asyncThreadPoolSize");
        this.setProperty("hibernate.search.default.worker.thread_pool.size", asyncThreadPoolSize);
        String asyncMaxQueueSize = indexing.getProperty("asyncMaxQueueSize");
        this.setProperty("hibernate.search.default.worker.buffer_queue.max", asyncMaxQueueSize);
        for (Object keyObj : indexing.keySet()) {
            String key = keyObj.toString();
            if (!key.startsWith("hibernate.search.")) continue;
            String value = indexing.getProperty(key);
            this.setProperty(key, value);
        }
    }

    private String initBackendProperties(String storageType, Properties backend) {
        String backendType = backend.getProperty("type");
        if (backendType.equals("lucene")) {
            this.setProperty("hibernate.search.default.worker.backend", "lucene");
        } else if (backendType.equals("blackhole")) {
            this.setProperty("hibernate.search.default.worker.backend", "blackhole");
        } else if (backendType.equals("jms-slave")) {
            String queueJndiName = backend.getProperty("queueJndiName");
            String factoryJndiName = backend.getProperty("connectionFactoryJndiName");
            this.setProperty("hibernate.search.default.worker.backend", "jms");
            this.setProperty("hibernate.search.default.worker.jms.queue", queueJndiName);
            this.setProperty("hibernate.search.default.worker.jms.connection_factory", factoryJndiName);
            for (Object keyObj : backend.keySet()) {
                String key = keyObj.toString();
                if (key.equals("type") || key.equals("queueJndiName") || key.equals("connectionFactoryJndiName")) continue;
                this.setProperty("hibernate.search.default.worker." + key, backend.getProperty(key));
            }
        } else if (backendType.equals("jgroups-master") || backendType.equals("jgroups-slave")) {
            String type = backendType.equals("jgroups-master") ? "jgroupsMaster" : "jgroupsSlave";
            String channel = backend.getProperty("channelName");
            String config = backend.getProperty("channelConfiguration");
            this.setProperty("hibernate.search.default.worker.backend", type);
            this.setProperty("hibernate.search.services.jgroups.clusterName", channel);
            this.setProperty("hibernate.search.services.jgroups.configurationFile", config);
        } else if (storageType.equals("custom")) {
            String classname = backend.getProperty("classname");
            this.setProperty("hibernate.search.default.worker.backend", classname);
        }
        return backendType;
    }

    public boolean isIndexMetadataComplete() {
        return true;
    }
}

