/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.document.DelegatingIterator;
import org.modeshape.jcr.cache.document.PatternIterator;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;

public abstract class AbstractChildReferences
implements ChildReferences {
    @Override
    public boolean supportsGetChildReferenceByKey() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public ChildReference getChild(Name name) {
        return this.getChild(name, 1, new ChildReferences.BasicContext());
    }

    @Override
    public ChildReference getChild(Path.Segment segment) {
        return this.getChild(segment.getName(), segment.getIndex(), new ChildReferences.BasicContext());
    }

    @Override
    public ChildReference getChild(Name name, int snsIndex) {
        return this.getChild(name, snsIndex, new ChildReferences.BasicContext());
    }

    @Override
    public Iterator<ChildReference> iterator(Name name) {
        return this.iterator(name, new ChildReferences.BasicContext());
    }

    @Override
    public Iterator<ChildReference> iterator() {
        return this.iterator(new ChildReferences.BasicContext());
    }

    @Override
    public Iterator<ChildReference> iterator(Name name, ChildReferences.Context context) {
        return this.contextSensitiveIterator(this.iterator(name), context);
    }

    @Override
    public Iterator<ChildReference> iterator(ChildReferences.Context context) {
        return this.contextSensitiveIterator(this.iterator(), context);
    }

    protected Iterator<ChildReference> contextSensitiveIterator(final Iterator<ChildReference> original, final ChildReferences.Context context) {
        if (context == null) {
            return original;
        }
        final ChildReferences.Changes changes = context.changes();
        if (changes == null || changes.isEmpty()) {
            return new Iterator<ChildReference>(){

                @Override
                public boolean hasNext() {
                    return original.hasNext();
                }

                @Override
                public ChildReference next() {
                    ChildReference ref = (ChildReference)original.next();
                    return ref.with(context.consume(ref.getName(), ref.getKey()));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<ChildReference>(){
            private Iterator<ChildReference> delegate;
            private Iterator<ChildReference> iter;
            private ChildReference next;
            private ChildReference nextAfterIter;
            {
                this.delegate = original;
                this.iter = this.delegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                while (this.next == null && this.iter.hasNext()) {
                    ChildReference next = this.iter.next();
                    ChildReferences.ChildInsertions insertions = changes.insertionsBefore(next);
                    if (insertions != null && this.nextAfterIter != next) {
                        if (this.nextAfterIter == null) {
                            this.nextAfterIter = next;
                        }
                        this.iter = insertions.inserted().iterator();
                        continue;
                    }
                    if (changes.isRemoved(next) && changes.inserted(next.getKey()) == null) continue;
                    Name newName = changes.renamed(next.getKey());
                    if (newName != null) {
                        next = next.with(newName, 1);
                    }
                    this.next = next;
                }
                if (this.iter != this.delegate) {
                    try {
                        this.iter = this.delegate;
                        this.next = this.nextAfterIter;
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        this.nextAfterIter = null;
                    }
                }
                return this.next != null;
            }

            @Override
            public ChildReference next() {
                try {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ChildReference childReference = this.next.with(context.consume(this.next.getName(), this.next.getKey()));
                    return childReference;
                }
                finally {
                    this.next = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<ChildReference> iterator(Collection<?> namePatterns, NamespaceRegistry registry) {
        return this.iterator(new ChildReferences.BasicContext(), namePatterns, registry);
    }

    @Override
    public Iterator<ChildReference> iterator(ChildReferences.Context context, Collection<?> namePatterns, final NamespaceRegistry registry) {
        return new PatternIterator<ChildReference>(this.iterator(context), namePatterns){

            @Override
            protected String matchable(ChildReference value) {
                return value.getName().getString(registry);
            }
        };
    }

    public Iterator<ChildReference> iterator(ChildReferences.Context context, Name name) {
        return new ChildReferenceWithNameIterator(this.iterator(context), name);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    public abstract StringBuilder toString(StringBuilder var1);

    protected static class ChildReferenceWithNameIterator
    extends DelegatingIterator<ChildReference> {
        private final Name name;
        private ChildReference last;

        protected ChildReferenceWithNameIterator(Iterator<ChildReference> delegate, Name name) {
            super(delegate);
            this.name = name;
        }

        @Override
        public boolean hasNext() {
            if (this.last != null) {
                return true;
            }
            while (super.hasNext()) {
                this.last = (ChildReference)super.next();
                if (!this.last.getName().equals(this.name)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ChildReference next() {
            if (this.last == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.last != null) {
                try {
                    ChildReference childReference = this.last;
                    return childReference;
                }
                finally {
                    this.last = null;
                }
            }
            throw new NoSuchElementException();
        }
    }
}

