/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.modeshape.common.logging.Logger;

public class InfinispanUtil {
    protected static final Logger LOGGER = Logger.getLogger(InfinispanUtil.class);

    private InfinispanUtil() {
    }

    public static <K, V, T> T execute(Cache<K, V> cache, Location location, DistributedCallable<K, V, T> callable, Combiner<T> combiner) throws InterruptedException, ExecutionException {
        if (location == null) {
            location = Location.LOCALLY;
        }
        DefaultExecutorService distributedExecutor = new DefaultExecutorService(cache);
        boolean shared = cache.getCacheConfiguration().loaders().shared();
        Object result = null;
        if (!shared) {
            List<Future> futures = null;
            switch (location) {
                case EVERYWHERE: {
                    futures = distributedExecutor.submitEverywhere(callable);
                    break;
                }
                case LOCALLY: {
                    futures = Collections.singletonList(distributedExecutor.submit(callable));
                }
            }
            while (futures != null && !futures.isEmpty()) {
                Iterator<Future> futureIter = futures.iterator();
                while (futureIter.hasNext()) {
                    Future future = futureIter.next();
                    try {
                        Object value = future.get(100L, TimeUnit.MILLISECONDS);
                        futureIter.remove();
                        result = combiner.combine(result, value);
                    }
                    catch (TimeoutException timeoutException) {}
                }
                if (!futures.isEmpty()) continue;
                break;
            }
        } else {
            result = distributedExecutor.submit(callable).get();
        }
        return result;
    }

    public static <K, V> Sequence<K> getAllKeys(Cache<K, V> cache) throws CacheLoaderException, InterruptedException, ExecutionException {
        LOGGER.debug("getAllKeys of {0}", new Object[]{cache.getName()});
        GetAllKeys task = new GetAllKeys();
        KeyMerger merger = new KeyMerger();
        Set cacheKeys = (Set)InfinispanUtil.execute(cache, Location.EVERYWHERE, task, merger);
        return new IteratorSequence(cacheKeys.iterator());
    }

    protected static final class GetAllKeys<K, V>
    implements DistributedCallable<K, V, Set<K>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Cache<K, V> cache;

        protected GetAllKeys() {
        }

        public void setEnvironment(Cache<K, V> cache, Set<K> inputKeys) {
            this.cache = cache;
        }

        public Set<K> call() throws Exception {
            CacheLoaderManager cacheLoaderManager = (CacheLoaderManager)this.cache.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class);
            if (cacheLoaderManager == null) {
                return this.cache.keySet();
            }
            CacheLoader cacheLoader = cacheLoaderManager.getCacheLoader();
            if (cacheLoader == null) {
                return this.cache.keySet();
            }
            HashSet cacheKeys = new HashSet(this.cache.keySet());
            cacheKeys.addAll(cacheLoader.loadAllKeys(cacheKeys));
            return cacheKeys;
        }
    }

    protected static final class GetAllMemoryKeys<K, V>
    implements DistributedCallable<K, V, Set<K>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Cache<K, V> cache;

        protected GetAllMemoryKeys() {
        }

        public void setEnvironment(Cache<K, V> cache, Set<K> inputKeys) {
            this.cache = cache;
        }

        public Set<K> call() throws Exception {
            return this.cache.keySet();
        }
    }

    private static final class IteratorSequence<T>
    implements Sequence<T> {
        private final Iterator<T> iterator;

        public IteratorSequence(Iterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public T next() {
            return this.iterator.hasNext() ? (T)this.iterator.next() : null;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    public static interface Sequence<T> {
        public T next() throws ExecutionException, CancellationException, InterruptedException;

        public boolean hasNext();
    }

    protected static class KeyMerger<K>
    implements Combiner<Set<K>> {
        protected KeyMerger() {
        }

        @Override
        public Set<K> combine(Set<K> priorResult, Set<K> newResult) {
            if (priorResult == null) {
                priorResult = new HashSet<K>();
            }
            if (newResult != null) {
                priorResult.addAll(newResult);
            }
            return priorResult;
        }
    }

    public static interface Combiner<T> {
        public T combine(T var1, T var2) throws InterruptedException, ExecutionException;
    }

    public static enum Location {
        EVERYWHERE,
        LOCALLY;

    }
}

