/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.util;

import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicLong;

public class SizeMeasuringReader
extends Reader {
    private final Reader stream;
    private final AtomicLong size;

    public SizeMeasuringReader(Reader Reader2, AtomicLong size) {
        this.stream = Reader2;
        this.size = size;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int n = this.stream.read(cbuf, off, len);
        if (n != -1) {
            this.size.addAndGet(n);
        }
        return n;
    }

    @Override
    public int read() throws IOException {
        int result = this.stream.read();
        if (result != -1) {
            this.size.addAndGet(1L);
        }
        return result;
    }

    @Override
    public synchronized void mark(int readlimit) throws IOException {
        this.stream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

