/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.common.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.modeshape.common.CommonI18n;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.ClasspathLocalizationRepository;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.ClassUtil;
import org.modeshape.common.util.StringUtil;

@ThreadSafe
public final class I18n
implements I18nResource {
    static final ConcurrentMap<Locale, Map<Class<?>, Set<String>>> LOCALE_TO_CLASS_TO_PROBLEMS_MAP = new ConcurrentHashMap();
    private static final Logger LOGGER = Logger.getLogger(I18n.class);
    private final String id;
    private final Class<?> i18nClass;
    final ConcurrentHashMap<Locale, String> localeToTextMap = new ConcurrentHashMap();
    final ConcurrentHashMap<Locale, String> localeToProblemMap = new ConcurrentHashMap();

    public static Set<Locale> getLocalizationProblemLocales(Class<?> i18nClass) {
        CheckArg.isNotNull(i18nClass, "i18nClass");
        HashSet<Locale> locales = new HashSet<Locale>(LOCALE_TO_CLASS_TO_PROBLEMS_MAP.size());
        block0: for (Map.Entry localeEntry : LOCALE_TO_CLASS_TO_PROBLEMS_MAP.entrySet()) {
            for (Map.Entry classEntry : ((Map)localeEntry.getValue()).entrySet()) {
                if (((Set)classEntry.getValue()).isEmpty()) continue;
                locales.add((Locale)localeEntry.getKey());
                continue block0;
            }
        }
        return locales;
    }

    public static Set<String> getLocalizationProblems(Class<?> i18nClass) {
        return I18n.getLocalizationProblems(i18nClass, Locale.getDefault());
    }

    public static Set<String> getLocalizationProblems(Class<?> i18nClass, Locale locale) {
        CheckArg.isNotNull(i18nClass, "i18nClass");
        Map classToProblemsMap = (Map)LOCALE_TO_CLASS_TO_PROBLEMS_MAP.get(locale == null ? Locale.getDefault() : locale);
        if (classToProblemsMap == null) {
            return Collections.emptySet();
        }
        Set problems = (Set)classToProblemsMap.get(i18nClass);
        if (problems == null) {
            return Collections.emptySet();
        }
        return problems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Class<?> i18nClass) {
        I18n.validateI18nClass(i18nClass);
        Class<?> clazz = i18nClass;
        synchronized (clazz) {
            try {
                for (Field fld : i18nClass.getDeclaredFields()) {
                    if (fld.getType() != I18n.class) continue;
                    I18n.initializeI18nField(fld);
                }
                I18n.cleanupPreviousProblems(i18nClass);
            }
            catch (IllegalAccessException err) {
                throw new IllegalArgumentException(CommonI18n.i18nClassNotPublic.text(i18nClass));
            }
        }
    }

    private static void cleanupPreviousProblems(Class<?> i18nClass) {
        for (Map.Entry entry : LOCALE_TO_CLASS_TO_PROBLEMS_MAP.entrySet()) {
            ((Map)entry.getValue()).remove(i18nClass);
        }
    }

    private static void initializeI18nField(Field fld) throws IllegalAccessException {
        if ((fld.getModifiers() & 1) != 1) {
            throw new SystemFailureException(CommonI18n.i18nFieldNotPublic.text(fld.getName(), fld.getDeclaringClass()));
        }
        if ((fld.getModifiers() & 8) != 8) {
            throw new SystemFailureException(CommonI18n.i18nFieldNotStatic.text(fld.getName(), fld.getDeclaringClass()));
        }
        if ((fld.getModifiers() & 0x10) == 16) {
            throw new SystemFailureException(CommonI18n.i18nFieldFinal.text(fld.getName(), fld.getDeclaringClass()));
        }
        ClassUtil.makeAccessible(fld);
        fld.set(null, new I18n(fld.getName(), fld.getDeclaringClass()));
    }

    private static void validateI18nClass(Class<?> i18nClass) {
        CheckArg.isNotNull(i18nClass, "i18nClass");
        if (i18nClass.isInterface()) {
            throw new IllegalArgumentException(CommonI18n.i18nClassInterface.text(i18nClass.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void localize(Class<?> i18nClass, Locale locale) {
        assert (i18nClass != null);
        assert (locale != null);
        Map<Class<?>, CopyOnWriteArraySet<String>> classToProblemsMap = new ConcurrentHashMap();
        Map existingClassToProblemsMap = LOCALE_TO_CLASS_TO_PROBLEMS_MAP.putIfAbsent(locale, classToProblemsMap);
        if (existingClassToProblemsMap != null) {
            classToProblemsMap = existingClassToProblemsMap;
        }
        if (classToProblemsMap.get(i18nClass) != null) {
            return;
        }
        Class<?> clazz = i18nClass;
        synchronized (clazz) {
            CopyOnWriteArraySet<String> problems = (CopyOnWriteArraySet<String>)classToProblemsMap.get(i18nClass);
            if (problems != null) {
                return;
            }
            problems = new CopyOnWriteArraySet<String>();
            classToProblemsMap.put(i18nClass, problems);
            String localizationBaseName = i18nClass.getName();
            URL bundleUrl = ClasspathLocalizationRepository.getLocalizationBundle(i18nClass.getClassLoader(), localizationBaseName, locale);
            if (bundleUrl == null && i18nClass == CommonI18n.class) {
                throw new SystemFailureException("CommonI18n.properties file not found in classpath !");
            }
            if (bundleUrl == null) {
                LOGGER.warn(CommonI18n.i18nBundleNotFoundInClasspath, ClasspathLocalizationRepository.getPathsToSearchForBundle(localizationBaseName, locale));
                Locale defaultLocale = Locale.getDefault();
                if (!defaultLocale.equals(locale)) {
                    bundleUrl = ClasspathLocalizationRepository.getLocalizationBundle(i18nClass.getClassLoader(), localizationBaseName, defaultLocale);
                }
                if (bundleUrl == null) {
                    LOGGER.error(CommonI18n.i18nBundleNotFoundInClasspath, ClasspathLocalizationRepository.getPathsToSearchForBundle(localizationBaseName, defaultLocale));
                    LOGGER.error(CommonI18n.i18nLocalizationFileNotFound, localizationBaseName);
                    problems.add(CommonI18n.i18nLocalizationFileNotFound.text(localizationBaseName));
                    return;
                }
            }
            Properties props = I18n.prepareBundleLoading(i18nClass, locale, bundleUrl, problems);
            try {
                InputStream propStream = bundleUrl.openStream();
                try {
                    props.load(propStream);
                    for (Field fld : i18nClass.getDeclaredFields()) {
                        if (fld.getType() != I18n.class) continue;
                        try {
                            I18n i18n = (I18n)fld.get(null);
                            if (i18n.localeToTextMap.get(locale) != null) continue;
                            i18n.localeToProblemMap.put(locale, CommonI18n.i18nPropertyMissing.text(fld.getName(), bundleUrl));
                        }
                        catch (IllegalAccessException notPossible) {
                            problems.add(notPossible.getMessage());
                        }
                    }
                }
                finally {
                    propStream.close();
                }
            }
            catch (IOException err) {
                problems.add(err.getMessage());
            }
        }
    }

    private static Properties prepareBundleLoading(final Class<?> i18nClass, final Locale locale, final URL bundleUrl, final Set<String> problems) {
        return new Properties(){
            private static final long serialVersionUID = 3920620306881072843L;

            @Override
            public synchronized Object put(Object key, Object value) {
                String id = (String)key;
                String text = (String)value;
                try {
                    Field fld = i18nClass.getDeclaredField(id);
                    if (fld.getType() != I18n.class) {
                        problems.add(CommonI18n.i18nFieldInvalidType.text(id, bundleUrl, this.getClass().getName()));
                    } else {
                        I18n i18n = (I18n)fld.get(null);
                        if (i18n.localeToTextMap.putIfAbsent(locale, text) != null) {
                            String prevProblem = i18n.localeToProblemMap.putIfAbsent(locale, CommonI18n.i18nPropertyDuplicate.text(id, bundleUrl));
                            assert (prevProblem == null);
                        }
                    }
                }
                catch (NoSuchFieldException err) {
                    problems.add(CommonI18n.i18nPropertyUnused.text(id, bundleUrl));
                }
                catch (IllegalAccessException notPossible) {
                    problems.add(notPossible.getMessage());
                }
                return null;
            }
        };
    }

    private I18n(String id, Class<?> i18nClass) {
        this.id = id;
        this.i18nClass = i18nClass;
    }

    public String id() {
        return this.id;
    }

    public boolean hasProblem() {
        return this.problem() != null;
    }

    public boolean hasProblem(Locale locale) {
        return this.problem(locale) != null;
    }

    public String problem() {
        return this.problem(null);
    }

    public String problem(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        I18n.localize(this.i18nClass, locale);
        String problem = this.localeToProblemMap.get(locale);
        if (problem != null) {
            return problem;
        }
        if (this.localeToTextMap.get(locale) != null) {
            return null;
        }
        problem = CommonI18n.i18nLocalizationProblems.text(this.i18nClass, locale);
        this.localeToProblemMap.put(locale, problem);
        return problem;
    }

    private String rawText(Locale locale) {
        assert (locale != null);
        I18n.localize(this.i18nClass, locale);
        String text = this.localeToTextMap.get(locale);
        if (text != null) {
            return text;
        }
        throw new SystemFailureException(this.problem(locale));
    }

    @Override
    public String text(Object ... arguments) {
        return this.text(null, arguments);
    }

    @Override
    public String text(Locale locale, Object ... arguments) {
        try {
            String rawText = this.rawText(locale == null ? Locale.getDefault() : locale);
            return StringUtil.createString(rawText, arguments);
        }
        catch (IllegalArgumentException err) {
            throw new IllegalArgumentException(CommonI18n.i18nRequiredToSuppliedParameterMismatch.text(this.id, this.i18nClass, err.getMessage()));
        }
        catch (SystemFailureException err) {
            return '<' + err.getMessage() + '>';
        }
    }

    public String toString() {
        try {
            return this.rawText(Locale.getDefault());
        }
        catch (SystemFailureException err) {
            return '<' + err.getMessage() + '>';
        }
    }
}

