# Turkish (tr) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                                | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ---------------------------------------------- | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987.                                          | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                             | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987.                                          | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5.                                             | 0004-12-27T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1.                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                             | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1Ç                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2Ç                                             | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | İlk çeyrek                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | İkinci Çeyrek                                  | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                              | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                              | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1.                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2.                                             | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1Ç                                             | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2Ç                                             | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | İlk çeyrek                                     | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | İkinci Çeyrek                                  | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2.                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                             | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | Şub                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Tem                                            | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | Şubat                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Temmuz                                         | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | Ş                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | T                                              | 2019-07-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2.                                             | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7.                                             | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | Şub                                            | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Tem                                            | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | Şubat                                          | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | Temmuz                                         | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | Ş                                              | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | T                                              | 2019-07-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1.                                             | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                            | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1.                                             | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48.                                            | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28.                                            | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42.                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365.                                           | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | Pts                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cum                                            | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | Pts                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cum                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | Pts                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cum                                            | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | Pazartesi                                      | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | Cuma                                           | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | P                                              | 2019-02-17T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | C                                              | 2019-02-15T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | Pt                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cu                                             | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1.                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                             | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | Pts                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cum                                            | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | Pazartesi                                      | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | Cuma                                           | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | P                                              | 2019-02-17T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | C                                              | 2019-02-15T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | Pt                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cu                                             | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1.                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                             | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | Pts                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cum                                            | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | Pazartesi                                      | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | Cuma                                           | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | P                                              | 2019-02-17T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | C                                              | 2019-02-15T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | Pt                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cu                                             | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1.                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5.                                             | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | Pts                                            | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cum                                            | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | Pazartesi                                      | Invalid Date             |
|                                 |              | 2019-02-15T12:13:14.015Z | Cuma                                           | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | P                                              | 2019-02-17T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | C                                              | 2019-02-15T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | Pt                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | Cu                                             | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | ÖÖ                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ÖS                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ÖS                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ÖÖ                                             | 2019-02-11T00:00:00.000Z |
|                                 | aa           | 2019-02-11T11:13:14.015Z | ÖÖ                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ÖS                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ÖS                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ÖÖ                                             | 2019-02-11T00:00:00.000Z |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | ÖÖ                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ÖS                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ÖS                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ÖÖ                                             | 2019-02-11T00:00:00.000Z |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | ö.ö.                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ö.s.                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ö.s.                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ö.ö.                                           | 2019-02-11T00:00:00.000Z |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | öö                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ös                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ös                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | öö                                             | 2019-02-11T00:00:00.000Z |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | ÖÖ                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ÖS                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ÖS                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ÖÖ                                             | 2019-02-11T00:00:00.000Z |
|                                 | bb           | 2019-02-11T11:13:14.015Z | ÖÖ                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ÖS                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ÖS                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ÖÖ                                             | 2019-02-11T00:00:00.000Z |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | ÖÖ                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ÖS                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ÖS                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ÖÖ                                             | 2019-02-11T00:00:00.000Z |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | ö.ö.                                           | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ö.s.                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ö.s.                                           | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ö.ö.                                           | 2019-02-11T00:00:00.000Z |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | öö                                             | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ös                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ös                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | öö                                             | 2019-02-11T00:00:00.000Z |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | sabahleyin                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | öğleden sonra                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | akşamleyin                                     | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | geceleyin                                      | 2019-02-11T00:00:00.000Z |
|                                 | BB           | 2019-02-11T11:13:14.015Z | sabahleyin                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | öğleden sonra                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | akşamleyin                                     | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | geceleyin                                      | 2019-02-11T00:00:00.000Z |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | sabahleyin                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | öğleden sonra                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | akşamleyin                                     | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | geceleyin                                      | 2019-02-11T00:00:00.000Z |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | sabahleyin                                     | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | öğleden sonra                                  | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | akşamleyin                                     | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | geceleyin                                      | 2019-02-11T00:00:00.000Z |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | sa                                             | 2019-02-11T04:00:00.000Z |
|                                 |              | 2019-02-11T14:13:14.015Z | ös                                             | 2019-02-11T12:00:00.000Z |
|                                 |              | 2019-02-11T19:13:14.015Z | ak                                             | 2019-02-11T17:00:00.000Z |
|                                 |              | 2019-02-11T02:13:14.015Z | ge                                             | 2019-02-11T00:00:00.000Z |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11.                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                            | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11.                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                            | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11.                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11.                                            | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11.                                            | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23.                                            | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1.                                             | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55.                                            | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1.                                             | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55.                                            | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11.02.1987                                     | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453                                     | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 Şub 1987                                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 May 1453                                    | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 Şubat 1987                                  | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mayıs 1453                                  | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | 11 Şubat 1987 Çarşamba                         | 1987-02-04T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mayıs 1453 Pazar                            | 1453-05-08T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                          | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                          | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                       | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                       | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                                 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                                 | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                             | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                             | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11.02.1987, 12:13                              | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29.05.1453, 23:59                              | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 Şub 1987, 12:13:14                          | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 May 1453, 23:59:59                          | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 Şubat 1987 saat 12:13:14 GMT+0              | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mayıs 1453 saat 23:59:59 GMT+0              | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | 11 Şubat 1987 Çarşamba saat 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 Mayıs 1453 Pazar saat 23:59:59 GMT+00:00    | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result           | `includeSeconds: true` | `addSuffix: true`      |
| ------------------------ | ---------------- | ---------------------- | ---------------------- |
| 2006-01-01T00:00:00.000Z | yaklaşık 6 yıl   | yaklaşık 6 yıl         | yaklaşık 6 yıl sonra   |
| 2005-01-01T00:00:00.000Z | yaklaşık 5 yıl   | yaklaşık 5 yıl         | yaklaşık 5 yıl sonra   |
| 2004-01-01T00:00:00.000Z | yaklaşık 4 yıl   | yaklaşık 4 yıl         | yaklaşık 4 yıl sonra   |
| 2003-01-01T00:00:00.000Z | yaklaşık 3 yıl   | yaklaşık 3 yıl         | yaklaşık 3 yıl sonra   |
| 2002-01-01T00:00:00.000Z | yaklaşık 2 yıl   | yaklaşık 2 yıl         | yaklaşık 2 yıl sonra   |
| 2001-06-01T00:00:00.000Z | 1 yıldan fazla   | 1 yıldan fazla         | 1 yıldan fazla sonra   |
| 2001-02-01T00:00:00.000Z | yaklaşık 1 yıl   | yaklaşık 1 yıl         | yaklaşık 1 yıl sonra   |
| 2001-01-01T00:00:00.000Z | yaklaşık 1 yıl   | yaklaşık 1 yıl         | yaklaşık 1 yıl sonra   |
| 2000-06-01T00:00:00.000Z | 5 ay             | 5 ay                   | 5 ay sonra             |
| 2000-03-01T00:00:00.000Z | 2 ay             | 2 ay                   | 2 ay sonra             |
| 2000-02-01T00:00:00.000Z | yaklaşık 1 ay    | yaklaşık 1 ay          | yaklaşık 1 ay sonra    |
| 2000-01-15T00:00:00.000Z | 14 gün           | 14 gün                 | 14 gün sonra           |
| 2000-01-02T00:00:00.000Z | 1 gün            | 1 gün                  | 1 gün sonra            |
| 2000-01-01T06:00:00.000Z | yaklaşık 6 saat  | yaklaşık 6 saat        | yaklaşık 6 saat sonra  |
| 2000-01-01T01:00:00.000Z | yaklaşık 1 saat  | yaklaşık 1 saat        | yaklaşık 1 saat sonra  |
| 2000-01-01T00:45:00.000Z | yaklaşık 1 saat  | yaklaşık 1 saat        | yaklaşık 1 saat sonra  |
| 2000-01-01T00:30:00.000Z | 30 dakika        | 30 dakika              | 30 dakika sonra        |
| 2000-01-01T00:15:00.000Z | 15 dakika        | 15 dakika              | 15 dakika sonra        |
| 2000-01-01T00:01:00.000Z | 1 dakika         | 1 dakika               | 1 dakika sonra         |
| 2000-01-01T00:00:25.000Z | bir dakikadan az | yarım dakika           | bir dakikadan az sonra |
| 2000-01-01T00:00:15.000Z | bir dakikadan az | 20 saniyeden az        | bir dakikadan az sonra |
| 2000-01-01T00:00:05.000Z | bir dakikadan az | 10 saniyeden az        | bir dakikadan az sonra |
| 2000-01-01T00:00:00.000Z | bir dakikadan az | 5 saniyeden az         | bir dakikadan az önce  |
| 1999-12-31T23:59:55.000Z | bir dakikadan az | 10 saniyeden az        | bir dakikadan az önce  |
| 1999-12-31T23:59:45.000Z | bir dakikadan az | 20 saniyeden az        | bir dakikadan az önce  |
| 1999-12-31T23:59:35.000Z | bir dakikadan az | yarım dakika           | bir dakikadan az önce  |
| 1999-12-31T23:59:00.000Z | 1 dakika         | 1 dakika               | 1 dakika önce          |
| 1999-12-31T23:45:00.000Z | 15 dakika        | 15 dakika              | 15 dakika önce         |
| 1999-12-31T23:30:00.000Z | 30 dakika        | 30 dakika              | 30 dakika önce         |
| 1999-12-31T23:15:00.000Z | yaklaşık 1 saat  | yaklaşık 1 saat        | yaklaşık 1 saat önce   |
| 1999-12-31T23:00:00.000Z | yaklaşık 1 saat  | yaklaşık 1 saat        | yaklaşık 1 saat önce   |
| 1999-12-31T18:00:00.000Z | yaklaşık 6 saat  | yaklaşık 6 saat        | yaklaşık 6 saat önce   |
| 1999-12-30T00:00:00.000Z | 2 gün            | 2 gün                  | 2 gün önce             |
| 1999-12-15T00:00:00.000Z | 17 gün           | 17 gün                 | 17 gün önce            |
| 1999-12-01T00:00:00.000Z | yaklaşık 1 ay    | yaklaşık 1 ay          | yaklaşık 1 ay önce     |
| 1999-11-01T00:00:00.000Z | 2 ay             | 2 ay                   | 2 ay önce              |
| 1999-06-01T00:00:00.000Z | 7 ay             | 7 ay                   | 7 ay önce              |
| 1999-01-01T00:00:00.000Z | yaklaşık 1 yıl   | yaklaşık 1 yıl         | yaklaşık 1 yıl önce    |
| 1998-12-01T00:00:00.000Z | yaklaşık 1 yıl   | yaklaşık 1 yıl         | yaklaşık 1 yıl önce    |
| 1998-06-01T00:00:00.000Z | 1 yıldan fazla   | 1 yıldan fazla         | 1 yıldan fazla önce    |
| 1998-01-01T00:00:00.000Z | yaklaşık 2 yıl   | yaklaşık 2 yıl         | yaklaşık 2 yıl önce    |
| 1997-01-01T00:00:00.000Z | yaklaşık 3 yıl   | yaklaşık 3 yıl         | yaklaşık 3 yıl önce    |
| 1996-01-01T00:00:00.000Z | yaklaşık 4 yıl   | yaklaşık 4 yıl         | yaklaşık 4 yıl önce    |
| 1995-01-01T00:00:00.000Z | yaklaşık 5 yıl   | yaklaşık 5 yıl         | yaklaşık 5 yıl önce    |
| 1994-01-01T00:00:00.000Z | yaklaşık 6 yıl   | yaklaşık 6 yıl         | yaklaşık 6 yıl önce    |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result    | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | --------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 yıl     | 6 yıl sonra       | 52608 saat                     |
| 2005-01-01T00:00:00.000Z | 5 yıl     | 5 yıl sonra       | 43848 saat                     |
| 2004-01-01T00:00:00.000Z | 4 yıl     | 4 yıl sonra       | 35064 saat                     |
| 2003-01-01T00:00:00.000Z | 3 yıl     | 3 yıl sonra       | 26304 saat                     |
| 2002-01-01T00:00:00.000Z | 2 yıl     | 2 yıl sonra       | 17544 saat                     |
| 2001-06-01T00:00:00.000Z | 1 yıl     | 1 yıl sonra       | 12408 saat                     |
| 2001-02-01T00:00:00.000Z | 1 yıl     | 1 yıl sonra       | 9528 saat                      |
| 2001-01-01T00:00:00.000Z | 1 yıl     | 1 yıl sonra       | 8784 saat                      |
| 2000-06-01T00:00:00.000Z | 5 ay      | 5 ay sonra        | 3648 saat                      |
| 2000-03-01T00:00:00.000Z | 2 ay      | 2 ay sonra        | 1440 saat                      |
| 2000-02-01T00:00:00.000Z | 1 ay      | 1 ay sonra        | 744 saat                       |
| 2000-01-15T00:00:00.000Z | 14 gün    | 14 gün sonra      | 336 saat                       |
| 2000-01-02T00:00:00.000Z | 1 gün     | 1 gün sonra       | 24 saat                        |
| 2000-01-01T06:00:00.000Z | 6 saat    | 6 saat sonra      | 6 saat                         |
| 2000-01-01T01:00:00.000Z | 1 saat    | 1 saat sonra      | 1 saat                         |
| 2000-01-01T00:45:00.000Z | 45 dakika | 45 dakika sonra   | 1 saat                         |
| 2000-01-01T00:30:00.000Z | 30 dakika | 30 dakika sonra   | 1 saat                         |
| 2000-01-01T00:15:00.000Z | 15 dakika | 15 dakika sonra   | 0 saat                         |
| 2000-01-01T00:01:00.000Z | 1 dakika  | 1 dakika sonra    | 0 saat                         |
| 2000-01-01T00:00:25.000Z | 25 saniye | 25 saniye sonra   | 0 saat                         |
| 2000-01-01T00:00:15.000Z | 15 saniye | 15 saniye sonra   | 0 saat                         |
| 2000-01-01T00:00:05.000Z | 5 saniye  | 5 saniye sonra    | 0 saat                         |
| 2000-01-01T00:00:00.000Z | 0 saniye  | 0 saniye önce     | 0 saat                         |
| 1999-12-31T23:59:55.000Z | 5 saniye  | 5 saniye önce     | 0 saat                         |
| 1999-12-31T23:59:45.000Z | 15 saniye | 15 saniye önce    | 0 saat                         |
| 1999-12-31T23:59:35.000Z | 25 saniye | 25 saniye önce    | 0 saat                         |
| 1999-12-31T23:59:00.000Z | 1 dakika  | 1 dakika önce     | 0 saat                         |
| 1999-12-31T23:45:00.000Z | 15 dakika | 15 dakika önce    | 0 saat                         |
| 1999-12-31T23:30:00.000Z | 30 dakika | 30 dakika önce    | 1 saat                         |
| 1999-12-31T23:15:00.000Z | 45 dakika | 45 dakika önce    | 1 saat                         |
| 1999-12-31T23:00:00.000Z | 1 saat    | 1 saat önce       | 1 saat                         |
| 1999-12-31T18:00:00.000Z | 6 saat    | 6 saat önce       | 6 saat                         |
| 1999-12-30T00:00:00.000Z | 2 gün     | 2 gün önce        | 48 saat                        |
| 1999-12-15T00:00:00.000Z | 17 gün    | 17 gün önce       | 408 saat                       |
| 1999-12-01T00:00:00.000Z | 1 ay      | 1 ay önce         | 744 saat                       |
| 1999-11-01T00:00:00.000Z | 2 ay      | 2 ay önce         | 1464 saat                      |
| 1999-06-01T00:00:00.000Z | 7 ay      | 7 ay önce         | 5136 saat                      |
| 1999-01-01T00:00:00.000Z | 1 yıl     | 1 yıl önce        | 8760 saat                      |
| 1998-12-01T00:00:00.000Z | 1 yıl     | 1 yıl önce        | 9504 saat                      |
| 1998-06-01T00:00:00.000Z | 2 yıl     | 2 yıl önce        | 13896 saat                     |
| 1998-01-01T00:00:00.000Z | 2 yıl     | 2 yıl önce        | 17520 saat                     |
| 1997-01-01T00:00:00.000Z | 3 yıl     | 3 yıl önce        | 26280 saat                     |
| 1996-01-01T00:00:00.000Z | 4 yıl     | 4 yıl önce        | 35064 saat                     |
| 1995-01-01T00:00:00.000Z | 5 yıl     | 5 yıl önce        | 43824 saat                     |
| 1994-01-01T00:00:00.000Z | 6 yıl     | 6 yıl önce        | 52584 saat                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                           |
| ------------------------ | -------------------------------- |
| 2000-01-10T00:00:00.000Z | 10.01.2000                       |
| 2000-01-05T00:00:00.000Z | Çarşamba saat 00:00              |
| 2000-01-02T00:00:00.000Z | yarın saat 00:00                 |
| 2000-01-01T00:00:00.000Z | bugün saat 00:00                 |
| 1999-12-31T00:00:00.000Z | dün saat 00:00                   |
| 1999-12-27T00:00:00.000Z | geçen hafta Pazartesi saat 00:00 |
| 1999-12-21T00:00:00.000Z | 21.12.1999                       |
