"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiTasks = void 0;
const tslib_1 = require("tslib");
const kube_1 = require("../../api/kube");
class ApiTasks {
    /**
     * Returns tasks which tests if K8s or OpenShift API is configured in the current context.
     *
     * `isOpenShift` property is provisioned into context.
     */
    testApiTasks(flags, command) {
        let kube = new kube_1.KubeHelper(flags);
        return {
            title: 'Verify Kubernetes API',
            skip: () => flags['skip-kubernetes-health-check'],
            task: (ctx, task) => tslib_1.__awaiter(this, void 0, void 0, function* () {
                try {
                    yield kube.checkKubeApi();
                    task.title = `${task.title}...OK`;
                    if (ctx.isOpenShift) {
                        task.title = `${task.title} (it's OpenShift)`;
                    }
                }
                catch (error) {
                    command.error(`Failed to connect to Kubernetes API, error: ${error.message}. If you're sure that your Kubernetes cluster is healthy - you can skip this check with '--skip-kubernetes-health-check' flag.`);
                }
            })
        };
    }
}
exports.ApiTasks = ApiTasks;
//# sourceMappingURL=api.js.map