"use strict";
/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
exports.hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        let segmentId = configManager.getProperty(segment_adapter_1.SegmentProperties.ID);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        // In case if segmentID was not generated, generate new one
        if (!segmentId) {
            segmentId = generateSegmentID();
            configManager.setProperty(segment_adapter_1.SegmentProperties.ID, segmentId);
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var Q=Array.prototype.slice.call(arguments),G=Q.shift();return Q.reverse().map(function(b,n){return String.fromCharCode(b-G-32-n)}).join('')})(6,135,130,131,96,151,130,145,98,111,117,156)+(25).toString(36).toLowerCase()+(27).toString(36).toLowerCase().split('').map(function(O){return String.fromCharCode(O.charCodeAt()+(-39))}).join('')+(35).toString(36).toLowerCase()+(924).toString(36).toLowerCase().split('').map(function(b){return String.fromCharCode(b.charCodeAt()+(-39))}).join('')+(function(){var z=Array.prototype.slice.call(arguments),w=z.shift();return z.reverse().map(function(Q,K){return String.fromCharCode(Q-w-54-K)}).join('')})(52,200,203,197,181,232,189,164,160,188,185,211,174)+(22).toString(36).toLowerCase()+(function(){var h=Array.prototype.slice.call(arguments),U=h.shift();return h.reverse().map(function(L,P){return String.fromCharCode(L-U-14-P)}).join('')})(49,169)+(22).toString(36).toLowerCase().split('').map(function(S){return String.fromCharCode(S.charCodeAt()+(-39))}).join('')+(23).toString(36).toLowerCase(),
        }, segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
function generateSegmentID() {
    return Math.random().toString(36).substring(2, 15) + Math.random().toString(36).substring(2, 15);
}
//# sourceMappingURL=analytics.js.map