/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { Command, flags } from '@oclif/command';
export default class Start extends Command {
    static description: string;
    static flags: flags.Input<any>;
    setPlaformDefaults(flags: any): Promise<void>;
    /**
     * Determine if a directory is empty.
     */
    isDirEmpty(dirname: string): Promise<boolean>;
    /**
     * Checks if TLS is disabled via operator custom resource.
     * Returns true if TLS is enabled (or omitted) and false if it is explicitly disabled.
     */
    checkTlsMode(flags: any): Promise<boolean>;
    checkPlatformCompatibility(flags: any): void;
    run(): Promise<void>;
    /**
     * Sets default installer which is `olm` for OpenShift 4 with stable version of crwctl
     * and `operator` for other cases.
     */
    setDefaultInstaller(flags: any): Promise<void>;
}
