"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenShiftHelper = void 0;
const tslib_1 = require("tslib");
const execa = require("execa");
class OpenShiftHelper {
    status() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const command = 'oc';
            const args = ['status'];
            const { exitCode } = yield execa(command, args, { timeout: 60000, reject: false });
            if (exitCode === 0) {
                return true;
            }
            else {
                return false;
            }
        });
    }
    getRouteHost(name, namespace = '') {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const command = 'oc';
            const args = ['get', 'route', '--namespace', namespace, '-o', `jsonpath={range.items[?(.metadata.name=='${name}')]}{.spec.host}{end}`];
            const { stdout } = yield execa(command, args, { timeout: 60000 });
            return stdout.trim();
        });
    }
    getRouteProtocol(name, namespace = '') {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const command = 'oc';
            const args = ['get', 'route', '--namespace', namespace, '-o', `jsonpath={range.items[?(.metadata.name=='${name}')]}{.spec.tls.termination}{end}`];
            const { stdout } = yield execa(command, args, { timeout: 60000 });
            const termination = stdout.trim();
            if (termination && termination.includes('edge') || termination.includes('passthrough') || termination.includes('reencrypt')) {
                return 'https';
            }
            else {
                return 'http';
            }
        });
    }
    routeExist(name, namespace = '') {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const command = 'oc';
            const args = ['get', 'route', '--namespace', namespace, '-o', `jsonpath={range.items[?(.metadata.name=='${name}')]}{.metadata.name}{end}`];
            const { stdout } = yield execa(command, args, { timeout: 60000 });
            return stdout.trim().includes(name);
        });
    }
    deleteAllRoutes(namespace = '') {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const command = 'oc';
            const args = ['delete', 'route', '--all', '--namespace', namespace];
            yield execa(command, args, { timeout: 60000 });
        });
    }
    deleteAllDeploymentConfigs(namespace = '') {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const command = 'oc';
            const args = ['delete', 'deploymentconfig', '--all', '--namespace', namespace];
            yield execa(command, args, { timeout: 60000 });
        });
    }
}
exports.OpenShiftHelper = OpenShiftHelper;
//# sourceMappingURL=openshift.js.map