/*********************************************************************
 * Copyright (c) 2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { Command } from '@oclif/command';
export declare const KUBERNETES_CLI = "kubectl";
export declare const OPENSHIFT_CLI = "oc";
export declare function getClusterClientCommand(): string;
export declare function isKubernetesPlatformFamily(platform: string): boolean;
export declare function isOpenshiftPlatformFamily(platform: string): boolean;
export declare function generatePassword(passwodLength: number, charactersSet?: string): string;
export declare function base64Decode(arg: string): string;
/**
 * Indicates if stable version of `crwctl` is used.
 */
export declare function isStableVersion(flags: any): boolean;
/**
 * Returns the tag of the image.
 */
export declare function getImageTag(image: string): string | undefined;
export declare function sleep(ms: number): Promise<void>;
/**
 * Initialize command context.
 */
export declare function initializeContext(): any;
/**
 * Returns command success message with execution time.
 */
export declare function getCommandSuccessMessage(command: Command, ctx: any): string;
