"use strict";
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const cli_ux_1 = require("cli-ux");
const notifier = require("node-notifier");
const che_1 = require("../../api/che");
const che_api_client_1 = require("../../api/che-api-client");
const kube_1 = require("../../api/kube");
const common_flags_1 = require("../../common-flags");
class Stop extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Stop);
            const { args } = this.parse(Stop);
            const workspaceId = args.workspace;
            let cheApiEndpoint = flags[common_flags_1.CHE_API_ENDPOINT_KEY];
            if (!cheApiEndpoint) {
                const kube = new kube_1.KubeHelper(flags);
                if (!(yield kube.hasReadPermissionsForNamespace(flags.chenamespace))) {
                    throw new Error(`CodeReady Workspaces API endpoint is required. Use flag --${common_flags_1.CHE_API_ENDPOINT_KEY} to provide it.`);
                }
                const cheHelper = new che_1.CheHelper(flags);
                cheApiEndpoint = (yield cheHelper.cheURL(flags.chenamespace)) + '/api';
            }
            const cheApiClient = che_api_client_1.CheApiClient.getInstance(cheApiEndpoint);
            yield cheApiClient.checkCheApiEndpointUrl();
            yield cheApiClient.stopWorkspace(workspaceId, flags[common_flags_1.ACCESS_TOKEN_KEY]);
            cli_ux_1.cli.log('Workspace successfully stopped.');
            notifier.notify({
                title: 'crwctl',
                message: 'Command workspace:stop has completed successfully.'
            });
            this.exit(0);
        });
    }
}
exports.default = Stop;
Stop.description = 'Stop a running workspace';
Stop.flags = {
    help: command_1.flags.help({ char: 'h' }),
    [common_flags_1.CHE_API_ENDPOINT_KEY]: common_flags_1.cheApiEndpoint,
    [common_flags_1.ACCESS_TOKEN_KEY]: common_flags_1.accessToken,
    chenamespace: common_flags_1.cheNamespace,
    'skip-kubernetes-health-check': common_flags_1.skipKubeHealthzCheck
};
Stop.args = [
    {
        name: 'workspace',
        description: 'The workspace id to stop',
        required: true
    }
];
//# sourceMappingURL=stop.js.map