/*********************************************************************
 * Copyright (c) 2019-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { che as chetypes } from '@eclipse-che/api';
import { OpenShiftHelper } from '../api/openshift';
import { KubeHelper } from './kube';
export declare class CheHelper {
    private readonly flags;
    defaultCheResponseTimeoutMs: number;
    kube: KubeHelper;
    oc: OpenShiftHelper;
    private readonly axios;
    constructor(flags: any);
    /**
     * Finds a pod where workspace is running.
     * Rejects if no workspace is found for the given workspace ID
     * or if workspace ID wasn't specified but more than one workspace is found.
     */
    getWorkspacePodName(namespace: string, cheWorkspaceId: string): Promise<string>;
    getWorkspacePodContainers(namespace: string, cheWorkspaceId?: string): Promise<string[]>;
    cheURL(namespace?: string): Promise<string>;
    chePluginRegistryURL(namespace?: string): Promise<string>;
    isSelfSignedCertificateSecretExist(namespace: string): Promise<boolean>;
    /**
     * Gets self-signed Che CA certificate from 'self-signed-certificate' secret.
     * If secret doesn't exist, undefined is returned.
     */
    retrieveCheCaCert(cheNamespace: string): Promise<string | undefined>;
    /**
     * Retrieves content of Che self-signed-certificate secret or undefined if the secret doesn't exist.
     * Note, it contains certificate chain in pem format.
     */
    private getCheSelfSignedSecretContent;
    saveCheCaCert(cheCaCert: string, destinaton?: string): Promise<string>;
    /**
     * Retreives Keycloak admin user credentials.
     * Works only with installers which use Che CR (operator, olm).
     * Returns credentials as an array of two values: [login, password]
     * In case of an error an array with undefined values will be returned.
     */
    retrieveKeycloakAdminCredentials(cheNamespace: string): Promise<string[]>;
    chePluginRegistryK8sURL(namespace?: string): Promise<string>;
    chePluginRegistryOpenShiftURL(namespace?: string): Promise<string>;
    cheK8sURL(namespace?: string): Promise<string>;
    cheOpenShiftURL(namespace?: string): Promise<string>;
    cheNamespaceExist(namespace?: string): Promise<boolean>;
    createWorkspaceFromDevfile(cheApiEndpoint: string, devfilePath: string, workspaceName?: string, accessToken?: string): Promise<chetypes.workspace.Workspace>;
    parseDevfile(devfilePath?: string): Promise<string>;
    buildDashboardURL(ideURL: string): Promise<string>;
    /**
     * Finds workspace pods and reads logs from it.
     */
    readWorkspacePodLog(namespace: string, workspaceId: string, directory: string): Promise<boolean>;
    /**
     * Reads logs from pods that match a given selector.
     */
    readPodLog(namespace: string, podLabelSelector: string | undefined, directory: string, follow: boolean): Promise<void>;
    /**
     * Reads containers logs inside pod that match a given selector.
     */
    readNamespacedPodLog(namespace: string, podLabelSelector: string | undefined, directory: string): Promise<void>;
    /**
     * Reads all namespace events and store into a file.
     */
    readNamespaceEvents(namespace: string, directory: string, follow: boolean): Promise<void>;
    watchNamespacedPods(namespace: string, podLabelSelector: string | undefined, directory: string): Promise<void>;
    /**
     * Indicates if pod matches given labels.
     */
    private matchLabels;
    /**
     * Returns containers names.
     */
    private getContainers;
    /**
     * Reads pod log from a specific container of the pod.
     */
    private doReadNamespacedPodLog;
    private doCreateLogFile;
}
