"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.cheApiEndpoint = exports.CHE_API_ENDPOINT_KEY = exports.skipKubeHealthzCheck = exports.accessToken = exports.ACCESS_TOKEN_KEY = exports.listrRenderer = exports.cheDeployment = exports.devWorkspaceControllerNamespace = exports.cheNamespace = void 0;
/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
const flags_1 = require("@oclif/parser/lib/flags");
const constants_1 = require("./constants");
exports.cheNamespace = flags_1.string({
    char: 'n',
    description: 'Openshift Project where CodeReady Workspaces server is supposed to be deployed',
    default: 'workspaces',
    env: 'CHE_NAMESPACE'
});
exports.devWorkspaceControllerNamespace = flags_1.string({
    description: 'Namespace for the DevWorkspace controller.  This parameter is used only when the workspace engine is the DevWorkspace',
    default: constants_1.DEFAULT_DEV_WORKSPACE_CONTROLLER_NAMESPACE,
    env: 'DEV_WORKSPACE_OPERATOR_NAMESPACE',
});
exports.cheDeployment = flags_1.string({
    description: 'CodeReady Workspaces deployment name',
    default: 'codeready',
    env: 'CHE_DEPLOYMENT'
});
exports.listrRenderer = flags_1.string({
    description: 'Listr renderer',
    options: ['default', 'silent', 'verbose'],
    default: 'default'
});
exports.ACCESS_TOKEN_KEY = 'access-token';
exports.accessToken = flags_1.string({
    description: `CodeReady Workspaces OIDC Access Token. See the documentation how to obtain token: ${constants_1.DOC_LINK_OBTAIN_ACCESS_TOKEN} and ${constants_1.DOC_LINK_OBTAIN_ACCESS_TOKEN_OAUTH}.`,
    env: 'CHE_ACCESS_TOKEN'
});
exports.skipKubeHealthzCheck = flags_1.boolean({
    description: 'Skip Kubernetes health check',
    default: false
});
exports.CHE_API_ENDPOINT_KEY = 'che-api-endpoint';
exports.cheApiEndpoint = flags_1.string({
    description: 'CodeReady Workspaces server API endpoint',
    env: 'CHE_API_ENDPOINT',
    required: false,
});
//# sourceMappingURL=common-flags.js.map