/*********************************************************************
 * Copyright (c) 2019 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 **********************************************************************/
import { Command, flags } from '@oclif/command';
export default class Inject extends Command {
    static description: string;
    static flags: flags.Input<any>;
    private readonly command;
    run(): Promise<void>;
    injectKubeconfig(flags: any, workspaceNamespace: string, workspacePodName: string, workspaceId: string): Promise<void>;
    /**
     * Tests whether a file can be injected into the specified container.
     */
    private canInject;
    /**
     * Copies the local kubeconfig into the specified container.
     * If returns, it means injection was completed successfully. If throws an error, injection failed
     */
    private doInjectKubeconfig;
    private fileExists;
    private containerExists;
}
