"use strict";
/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const command_1 = require("@oclif/command");
const cli_ux_1 = require("cli-ux");
const che_1 = require("../../api/che");
const context_1 = require("../../api/context");
const common_flags_1 = require("../../common-flags");
const constants_1 = require("../../constants");
const util_1 = require("../../util");
class Open extends command_1.Command {
    run() {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            const { flags } = this.parse(Open);
            flags.chenamespace = yield util_1.findWorkingNamespace(flags);
            yield context_1.ChectlContext.init(flags, this);
            try {
                yield this.config.runHook(constants_1.DEFAULT_ANALYTIC_HOOK_NAME, { command: Open.id, flags });
                const cheHelper = new che_1.CheHelper(flags);
                const cheURL = yield cheHelper.cheURL(flags.chenamespace);
                const dashboardUrl = `${cheURL}/dashboard/`;
                cli_ux_1.cli.info(`Opening ... ${dashboardUrl}`);
                yield cli_ux_1.cli.open(dashboardUrl);
            }
            catch (error) {
                this.error(error);
            }
            this.exit(0);
        });
    }
}
exports.default = Open;
Open.description = 'Open CodeReady Workspaces dashboard';
Open.flags = {
    help: command_1.flags.help({ char: 'h' }),
    chenamespace: common_flags_1.cheNamespace,
    telemetry: common_flags_1.CHE_TELEMETRY,
};
//# sourceMappingURL=open.js.map