"use strict";
/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.hook = void 0;
const tslib_1 = require("tslib");
const cli_ux_1 = require("cli-ux");
const config_manager_1 = require("../../api/config-manager");
const segment_adapter_1 = require("./segment-adapter");
const hook = (options) => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
    // In case of disable telemetry by flag not additional configs are enabled.
    if (options.flags && options.flags.telemetry === 'off') {
        return this;
    }
    try {
        const configManager = config_manager_1.ConfigManager.getInstance();
        let segmentTelemetry = configManager.getProperty(segment_adapter_1.SegmentProperties.Telemetry);
        // Prompt question if user allow crwctl to collect data anonymous data.
        if (!options.flags.telemetry && !segmentTelemetry) {
            const confirmed = yield cli_ux_1.cli.confirm('Enable CLI usage data to be sent to Red Hat online services. More info: https://developers.redhat.com/article/tool-data-collection [y/n]');
            segmentTelemetry = confirmed ? 'on' : 'off';
            configManager.setProperty(segment_adapter_1.SegmentProperties.Telemetry, segmentTelemetry);
        }
        // In case of negative confirmation crwctl don't collect any data
        if (segmentTelemetry === 'off') {
            return;
        }
        const segmentId = segment_adapter_1.SegmentAdapter.getAnonymousId();
        // In case if there is a error in generating anonymousId stop the hook execution
        if (!segmentId) {
            return;
        }
        const segment = new segment_adapter_1.SegmentAdapter({
            // tslint:disable-next-line:no-single-line-block-comment
            segmentWriteKey: (function(){var F=Array.prototype.slice.call(arguments),p=F.shift();return F.reverse().map(function(G,j){return String.fromCharCode(G-p-28-j)}).join('')})(21,184,136,172,146,141,142,107,162,141,156,109,122,128,167)+(33284).toString(36).toLowerCase().split('').map(function(q){return String.fromCharCode(q.charCodeAt()+(-39))}).join('')+(17).toString(36).toLowerCase()+(1075).toString(36).toLowerCase().split('').map(function(P){return String.fromCharCode(P.charCodeAt()+(-39))}).join('')+(77).toString(36).toLowerCase()+(29).toString(36).toLowerCase().split('').map(function(L){return String.fromCharCode(L.charCodeAt()+(-39))}).join('')+(32).toString(36).toLowerCase()+(718).toString(36).toLowerCase().split('').map(function(K){return String.fromCharCode(K.charCodeAt()+(-39))}).join('')+(13).toString(36).toLowerCase().split('').map(function(h){return String.fromCharCode(h.charCodeAt()+(-13))}).join('')+(35).toString(36).toLowerCase().split('').map(function(M){return String.fromCharCode(M.charCodeAt()+(-39))}).join('')+(22).toString(36).toLowerCase()+(function(){var I=Array.prototype.slice.call(arguments),k=I.shift();return I.reverse().map(function(y,X){return String.fromCharCode(y-k-19-X)}).join('')})(9,99,134)+(23).toString(36).toLowerCase(),
        }, segmentId);
        yield segment.identifySegmentEvent(segmentId);
        yield segment.trackSegmentEvent(options);
    }
    catch (_a) {
        return this;
    }
});
exports.hook = hook;
//# sourceMappingURL=analytics.js.map