/**
 * Copyright (c) 2019-2021 Red Hat, Inc.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *   Red Hat, Inc. - initial API and implementation
 */
import Listr = require('listr');
export declare const CHECTL_DEVELOPMENT_VERSION = "0.0.2";
export declare namespace VersionHelper {
    const MINIMAL_OPENSHIFT_VERSION = "3.11";
    const MINIMAL_K8S_VERSION = "1.19";
    const MINIMAL_HELM_VERSION = "2.15";
    const CHE_POD_MANIFEST_FILE = "/home/user/eclipse-che/tomcat/webapps/ROOT/META-INF/MANIFEST.MF";
    const CHE_PREFFIX_VERSION = "Implementation-Version: ";
    function getOpenShiftCheckVersionTask(flags: any): Listr.ListrTask;
    function getK8sCheckVersionTask(flags: any): Listr.ListrTask;
    function getOpenShiftVersion(): Promise<string | undefined>;
    function getK8sVersionWithOC(): Promise<string | undefined>;
    function getK8sVersionWithKubectl(): Promise<string | undefined>;
    function checkMinimalK8sVersion(actualVersion: string): boolean;
    function checkMinimalOpenShiftVersion(actualVersion: string): boolean;
    function checkMinimalHelmVersion(actualVersion: string): boolean;
    /**
     * Compare versions and return true if actual version is greater or equal to minimal.
     * The comparison will be done by major and minor versions.
     */
    function checkMinimalVersion(actual: string, minimal: string): boolean;
    function getMinimalVersionError(actualVersion: string, minimalVersion: string, component: string): Error;
    /**
     * Returns CodeReady Workspaces version.
     */
    function getCheVersion(flags: any): Promise<string>;
    /**
     * Returns latest crwctl version for the given channel.
     */
    function getLatestChectlVersion(channel: string): Promise<string | undefined>;
    /**
     * Checks whether there is an update available for current crwctl.
     */
    function isChectlUpdateAvailable(cacheDir: string, forceRecheck?: boolean): Promise<boolean>;
    /**
     * Returns true if verA > verB
     */
    function gtChectlVersion(verA: string, verB: string): Promise<boolean>;
    /**
     * Indicates if stable version of CodeReady Workspaces is specified or meant implicitly.
     */
    function isDeployingStableVersion(flags: any): boolean;
    /**
     * Removes 'v' prefix from version string.
     * @param version version to process
     * @param checkForNumber if true remove prefix only if a numeric version follow it (e.g. v7.x -> 7.x, vNext -> vNext)
     */
    function removeVPrefix(version: string, checkForNumber?: boolean): string;
}
