package com.jboss.jbds.product.splash;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.branding.IProductConstants;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.splash.BasicSplashHandler;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

/**
 * This SplashHandler add's in the version number onto JBoss Developer Studio splash screen.
 * 
 * Supports the same location info as Eclipse but introduces "startupVersionLocation" property to 
 * render version right aligned to a lower right position.
 * 
 * @author max
 *
 */
public class SplashHandler extends BasicSplashHandler {

	
	/** which font data to use for the version string - defaults to "Arial-bold-9" **/
	private static final String STARTUP_VERSION_FONT_DATA = "startupVersionFont";
	/** the lower right position of the version number. The version will be rendered to align with this point */
	private static final String STARTUP_VERSION_LOCATION = "startupVersionLocation";

	public SplashHandler() {
		super();
	}

	public void init(Shell splash) {
		super.init(splash);
		String progressRectString = null;
		String messageRectString = null;
		String foregroundColorString = null;
		String versionLocation = null;
	    String versionFont = null;
		
		IProduct product = Platform.getProduct();
		
		if (product != null) {
			progressRectString = product
					.getProperty(IProductConstants.STARTUP_PROGRESS_RECT);
			messageRectString = product
					.getProperty(IProductConstants.STARTUP_MESSAGE_RECT);
			foregroundColorString = product
					.getProperty(IProductConstants.STARTUP_FOREGROUND_COLOR);
			versionLocation = product.getProperty(STARTUP_VERSION_LOCATION);
			versionFont = product.getProperty(STARTUP_VERSION_FONT_DATA);
		}
		
		Rectangle progressRect = StringConverter.asRectangle(
				progressRectString, new Rectangle(10, 10, 300, 15));
		setProgressRect(progressRect);

		Rectangle messageRect = StringConverter.asRectangle(messageRectString,
				new Rectangle(10, 35, 300, 15));
		setMessageRect(messageRect);

		int foregroundColorInteger;
		try {
			foregroundColorInteger = Integer
					.parseInt(foregroundColorString, 16);
		} catch (Exception ex) {
			foregroundColorInteger = 0xD2D7FF; // off white
		}

		setForeground(new RGB((foregroundColorInteger & 0xFF0000) >> 16,
				(foregroundColorInteger & 0xFF00) >> 8,
				foregroundColorInteger & 0xFF));
		
		final String versionString = getVersionString();

		final Point versionLocationPoint = StringConverter.asPoint(
				versionLocation, new Point(228, 209));
	
		final FontData fd = StringConverter.asFontData(versionFont, new FontData("Arial", 9, SWT.BOLD));
		
		getContent().addPaintListener(new PaintListener() {

			public void paintControl(PaintEvent e) {
				e.gc.setTextAntialias(SWT.ON);
				
				Font newF = new Font(e.gc.getDevice(), fd);
				e.gc.setFont(newF);

				Point point = e.gc.textExtent(versionString);
				e.gc.setForeground(getForeground());
				e.gc.drawText(versionString, versionLocationPoint.x - point.x,
						versionLocationPoint.y, true);
			}
		});
	}

	private String getVersionString() {
		Bundle bundle = Platform.getBundle("com.jboss.jbds.product");

		String versionString = (String) bundle.getHeaders().get(
				"Bundle-Version");
		
		if (versionString != null) {
			Version version = new Version(versionString);
			String qualifier = null;
			if(Boolean.getBoolean("SHOW_BUILDID_ON_STARTUP") || PrefUtil.getInternalPreferenceStore().getBoolean(
			"SHOW_BUILDID_ON_STARTUP")) {
				qualifier = version.getQualifier();
			} else {
				qualifier = version.getQualifier();
				int ix = qualifier.lastIndexOf('-'); // 3.0.1.v201006010437R-H98-GA
													// should leave just -GA in
													// there.
				if (ix > 0) {
					qualifier = qualifier.substring(ix + 1);
				} 
			}

			return version.getMajor() + "." + version.getMinor() + "."
					+ version.getMicro() + "." + qualifier;
		}
		
		return "";
	}
}
