/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.properties.FindbugsPropertyPage;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFilesTab
extends Composite {
    private static IPath lastUsedPath;
    private final FindbugsPropertyPage propertyPage;
    private final FilterProvider filterIncl;
    private final FilterProvider filterExcl;
    private final FilterProvider filterExclBugs;

    public FilterFilesTab(TabFolder parent, FindbugsPropertyPage page, int style) {
        super((Composite)parent, style);
        this.propertyPage = page;
        this.setLayout((Layout)new GridLayout(2, true));
        TabItem tabDetector = new TabItem(parent, 0);
        tabDetector.setText(this.getMessage("property.filterFilesTab"));
        tabDetector.setControl((Control)this);
        tabDetector.setToolTipText("Configure external bug reporting filters");
        this.filterIncl = this.createFilter(this, FilterKind.INCLUDE);
        this.filterExcl = this.createFilter(this, FilterKind.EXCLUDE);
        this.filterExclBugs = this.createFilter(this, FilterKind.EXCLUDE_BUGS);
        this.validateAllFilters();
    }

    public void validateAllFilters() {
        this.propertyPage.setErrorMessage(null);
        this.filterIncl.refresh();
        this.filterExcl.refresh();
        this.filterExclBugs.refresh();
    }

    public static void setLastUsedPath(IPath lastUsed) {
        lastUsedPath = lastUsed;
    }

    public static IPath getLastUsedPath() {
        return lastUsedPath;
    }

    protected String getMessage(String key) {
        return FindbugsPlugin.getDefault().getMessage(key);
    }

    private FilterProvider createFilter(Composite parent, FilterKind kind) {
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label titleLabel = new Label(tableComposite, 0);
        String title = this.getMessage(kind.propertyName);
        titleLabel.setText(title);
        titleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        final ListViewer viewer = new ListViewer(tableComposite, 2818);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        final FilterProvider contentProvider = this.createFilterProvider(viewer, kind);
        viewer.setContentProvider((IContentProvider)contentProvider);
        Button addButton = new Button(tableComposite, 8);
        String addButtonLabel = this.getMessage(kind.propertyName + "addbutton");
        addButton.setText(addButtonLabel);
        addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        addButton.addSelectionListener((SelectionListener)contentProvider);
        final Button removeButton = new Button(tableComposite, 8);
        removeButton.setLayoutData((Object)new GridData(4, 1, false, true));
        String removeButtonLabel = this.getMessage(kind.propertyName + "removebutton");
        removeButton.setText(removeButtonLabel);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterator selectionIter = ((IStructuredSelection)viewer.getSelection()).iterator();
                while (selectionIter.hasNext()) {
                    contentProvider.remove((PathElement)selectionIter.next());
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        return contentProvider;
    }

    protected FilterProvider createFilterProvider(ListViewer viewer, FilterKind kind) {
        return new FilterProvider(viewer, kind);
    }

    private List<PathElement> getFilterFiles(FilterKind kind, UserPreferences prefs) {
        IProject project = this.propertyPage.getProject();
        ArrayList<PathElement> paths = new ArrayList<PathElement>();
        Collection<String> filterPaths = kind.selectedPaths(prefs);
        if (filterPaths != null) {
            for (String path : filterPaths) {
                IPath filterPath = FindBugsWorker.getFilterPath(path, project);
                if (!filterPath.toFile().exists()) continue;
                paths.add(new PathElement(filterPath, Status.OK_STATUS));
            }
        }
        return paths;
    }

    private Set<String> pathsToStrings(List<PathElement> paths) {
        IProject project = this.propertyPage.getProject();
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (PathElement path : paths) {
            IPath filterPath = FindBugsWorker.toFilterPath(path.getPath(), project);
            result.add(filterPath.toOSString());
        }
        return result;
    }

    public void setEnabled(boolean enabled) {
        this.filterExcl.setControlEnabled(enabled);
        this.filterIncl.setControlEnabled(enabled);
        this.filterExclBugs.setControlEnabled(enabled);
        super.setEnabled(enabled);
    }

    void refreshUI(UserPreferences prefs) {
        this.filterExcl.setFilters(prefs);
        this.filterExclBugs.setFilters(prefs);
        this.filterIncl.setFilters(prefs);
        this.validateAllFilters();
    }

    protected FilterProvider getFilterIncl() {
        return this.filterIncl;
    }

    protected FilterProvider getFilterExcl() {
        return this.filterExcl;
    }

    protected FilterProvider getFilterExclBugs() {
        return this.filterExclBugs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FilterKind {
        INCLUDE("property.includefilter"){

            @Override
            Collection<String> selectedPaths(UserPreferences u) {
                return u.getIncludeFilterFiles();
            }

            @Override
            Collection<String> excludedPaths(UserPreferences u) {
                HashSet<String> excl = new HashSet<String>();
                excl.addAll(u.getExcludeFilterFiles());
                excl.addAll(u.getExcludeBugsFiles());
                return excl;
            }

            @Override
            void setPaths(UserPreferences u, Collection<String> files) {
                u.setIncludeFilterFiles(files);
            }
        }
        ,
        EXCLUDE("property.excludefilter"){

            @Override
            Collection<String> selectedPaths(UserPreferences u) {
                return u.getExcludeFilterFiles();
            }

            @Override
            Collection<String> excludedPaths(UserPreferences u) {
                HashSet<String> excl = new HashSet<String>();
                excl.addAll(u.getIncludeFilterFiles());
                excl.addAll(u.getExcludeBugsFiles());
                return excl;
            }

            @Override
            void setPaths(UserPreferences u, Collection<String> files) {
                u.setExcludeFilterFiles(files);
            }
        }
        ,
        EXCLUDE_BUGS("property.excludebugs"){

            @Override
            Collection<String> selectedPaths(UserPreferences u) {
                return u.getExcludeBugsFiles();
            }

            @Override
            Collection<String> excludedPaths(UserPreferences u) {
                HashSet<String> excl = new HashSet<String>();
                excl.addAll(u.getIncludeFilterFiles());
                excl.addAll(u.getExcludeFilterFiles());
                return excl;
            }

            @Override
            void setPaths(UserPreferences u, Collection<String> files) {
                u.setExcludeBugsFiles(files);
            }
        };

        final String propertyName;

        private FilterKind(String propertyName) {
            this.propertyName = propertyName;
        }

        abstract Collection<String> selectedPaths(UserPreferences var1);

        abstract Collection<String> excludedPaths(UserPreferences var1);

        abstract void setPaths(UserPreferences var1, Collection<String> var2);
    }

    protected static final class PathElement {
        private final IPath path;
        private IStatus status;

        public PathElement(IPath path, IStatus status) {
            this.path = path;
            this.status = status;
        }

        public void setStatus(IStatus status) {
            this.status = status;
        }

        public String toString() {
            return this.path.toString() + (this.status.isOK() ? "" : " (" + this.status.getMessage() + ")");
        }

        public String getPath() {
            return this.path.toOSString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PathElement) {
                return this.path.equals(((PathElement)obj).path);
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }

    protected class FilterProvider
    extends SelectionAdapter
    implements IStructuredContentProvider {
        protected final List<PathElement> paths = new ArrayList<PathElement>();
        private final FilterKind kind;
        private final Control control;
        private final ListViewer viewer;

        protected FilterProvider(ListViewer viewer, FilterKind kind) {
            this.viewer = viewer;
            this.control = viewer.getList();
            this.kind = kind;
            this.setFilters(FilterFilesTab.this.propertyPage.getCurrentUserPreferences());
        }

        void setFilters(UserPreferences prefs) {
            this.paths.clear();
            this.paths.addAll(FilterFilesTab.this.getFilterFiles(this.kind, prefs));
        }

        public void widgetSelected(SelectionEvent e) {
            this.addFiles(e.display.getActiveShell());
        }

        public void addFiles(Shell parentShell) {
            FileDialog dialog = this.createFileDialog(parentShell);
            String pathStr = this.openFileDialog(dialog);
            if (pathStr == null) {
                return;
            }
            this.addSelectedPaths(dialog);
            this.applyToPreferences();
            FilterFilesTab.this.validateAllFilters();
        }

        private FileDialog createFileDialog(Shell parentShell) {
            FileDialog dialog = new FileDialog(parentShell, 4098);
            dialog.setFilterExtensions(new String[]{"*.xml"});
            dialog.setText(FilterFilesTab.this.getMessage(this.kind.propertyName) + ": select xml file(s) containing filters");
            IPath lastUsed = FilterFilesTab.getLastUsedPath();
            String filterPath = null;
            if (lastUsed != null && lastUsed.toFile().isDirectory()) {
                filterPath = lastUsed.toOSString();
                dialog.setFilterPath(filterPath);
            }
            return dialog;
        }

        protected String openFileDialog(FileDialog dialog) {
            return dialog.open();
        }

        protected String[] getFileNames(FileDialog dialog) {
            return dialog.getFileNames();
        }

        protected String getFilterPath(FileDialog dialog) {
            return dialog.getFilterPath();
        }

        private void addSelectedPaths(FileDialog dialog) {
            String[] names = this.getFileNames(dialog);
            String filterPath = this.getFilterPath(dialog);
            for (String fileName : names) {
                IPath path = new Path(filterPath).append(fileName);
                PathElement pathElt = new PathElement(path, Status.OK_STATUS);
                if (this.paths.contains(pathElt)) continue;
                this.paths.add(pathElt);
            }
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer1, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.paths.toArray();
        }

        boolean contains(Object o) {
            return this.paths.contains(o);
        }

        void setControlEnabled(boolean enabled) {
            this.control.setEnabled(enabled);
        }

        void refresh() {
            this.validate();
            this.viewer.setSelection(null);
            this.viewer.setInput(new Object());
            this.viewer.refresh(true);
        }

        private void validate() {
            SelectionValidator validator = new SelectionValidator(this.kind);
            IStatus bad = null;
            IProject project = FilterFilesTab.this.propertyPage.getProject();
            for (PathElement path : this.paths) {
                String filterPath = FindBugsWorker.toFilterPath(path.getPath(), project).toOSString();
                IStatus status = validator.validate(filterPath);
                path.setStatus(status);
                if (status.isOK()) continue;
                bad = status;
            }
            if (bad != null) {
                FilterFilesTab.this.propertyPage.setErrorMessage(bad.getMessage());
            }
        }

        public void remove(PathElement holder) {
            this.paths.remove(holder);
            this.applyToPreferences();
            FilterFilesTab.this.validateAllFilters();
        }

        private void applyToPreferences() {
            this.validate();
            this.kind.setPaths(FilterFilesTab.this.propertyPage.getCurrentUserPreferences(), FilterFilesTab.this.pathsToStrings(this.paths));
        }
    }

    private final class SelectionValidator {
        private final UserPreferences prefs;
        private final Collection<String> exclFiles;

        public SelectionValidator(FilterKind kind) {
            this.prefs = FilterFilesTab.this.propertyPage.getCurrentUserPreferences();
            this.exclFiles = kind.excludedPaths(this.prefs);
        }

        public IStatus validate(String path) {
            if (this.exclFiles.contains(path)) {
                return FindbugsPlugin.createErrorStatus("Filter selected in a conflicting list", null);
            }
            return FindbugsPlugin.createStatus(0, "", null);
        }
    }
}

