/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.FileInfo;
import org.jboss.tools.common.model.util.JavacErrorHeadLine;
import org.jboss.tools.common.model.util.SegmentInfo;
import org.jboss.tools.common.model.util.StackTraceLine;

public class FindObjectHelper
implements SpecialWizard {
    public static int EVERY_WHERE = 0;
    public static int IN_EDITOR_ONLY = 1;
    public static int IN_NAVIGATOR_ONLY = 2;
    public static int IN_NAVIGATOR_AND_IN_EDITOR_IF_OPEN = 3;
    static SpecialWizard select = FindObjectHelper.createSelectWizard();
    private XModel model = null;
    private String command = null;
    private int off = -1;
    private FileInfo file = new FileInfo();
    private SegmentInfo segment = new SegmentInfo();
    private int line = -1;

    public static SpecialWizard createSelectWizard() {
        return SpecialWizardFactory.createSpecialWizard("org.jboss.tools.common.model.ui.select.SelectObjectWizard");
    }

    public static int findModelObject(XModelObject o, int where) {
        if (o == null) {
            return 1;
        }
        SpecialWizard wizard = FindObjectHelper.createSelectWizard();
        wizard.setObject(where);
        wizard.setObject(o);
        return wizard.execute();
    }

    public static int findModelObject(XModelObject o, int where, String preferredPage) {
        if (o == null) {
            return 1;
        }
        SpecialWizard wizard = FindObjectHelper.createSelectWizard();
        wizard.setObject(where);
        wizard.setObject(o);
        wizard.setObject(preferredPage);
        return wizard.execute();
    }

    public static String makeRef(XModelObject o) {
        return o.getAttributeValue("element type") + " " + FindObjectHelper.makeRef(o.getPath(), o.getPresentationString());
    }

    public static String makeRef(XModelObject o, int line) {
        return o.getAttributeValue("element type") + " " + FindObjectHelper.makeRef(String.valueOf(o.getPath()) + ":" + line, o.getPresentationString());
    }

    public static String makeRef(String hidden, String visible) {
        return "@" + hidden + "@" + visible + "@";
    }

    public void setObject(Object object) {
        Object[] os = (Object[])object;
        this.model = (XModel)os[0];
        this.command = (String)os[1];
        this.off = (Integer)os[2];
    }

    public int execute() {
        XModelObject o = this.findRef();
        if (o == null) {
            o = this.findJava();
        }
        if (o != null) {
            o.set("_error_line_", "" + this.line);
            select.setObject(o);
            select.execute();
            o.set("_error_line_", "");
        }
        return 0;
    }

    private XModelObject findRef() {
        int i = 0;
        while (i < this.command.length()) {
            int i1 = this.command.indexOf("@", i);
            if (i1 < 0 || i1 > this.off) {
                return null;
            }
            int i2 = this.command.indexOf("@", i1 + 1);
            if (i2 < 0) {
                return null;
            }
            String p = this.command.substring(i1 + 1, i2);
            int i3 = this.command.indexOf("@", i2 + 1);
            if (i3 < 0) {
                return null;
            }
            if (i3 >= this.off) {
                int q = p.indexOf(":");
                if (q >= 0) {
                    try {
                        this.line = Integer.parseInt(p.substring(q + 1));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    p = p.substring(0, q);
                }
                return this.model.getByPath(p);
            }
            i = i3 + 1;
        }
        return null;
    }

    private XModelObject findJava() {
        JavacErrorHeadLine h = new JavacErrorHeadLine(this.model, this.command);
        if (h.jf() != null) {
            this.file.setData(h.jf(), h.line(), this.model);
        } else if (h.cls() != null) {
            this.file.setData(h.cls(), h.line(), this.model);
        } else {
            return null;
        }
        XModelObject o = this.model.getByPath(this.file.getJPath());
        this.line = this.file.getLine() - 1;
        if (o != null) {
            return o;
        }
        if (this.file.getText().length() == 0) {
            return null;
        }
        this.segment.setData(this.file);
        this.segment.parse();
        String path = this.segment.getPath();
        if (path == null) {
            return null;
        }
        o = this.model.getByPath(path);
        this.line = this.segment.getLine();
        return o;
    }

    public static String enhanceStackTraceEntry(XModel model, String st) {
        StackTraceLine q = new StackTraceLine(st);
        if (q.cls() == null) {
            return st;
        }
        FileInfo f = new FileInfo();
        f.setData(q.cls(), q.line() + 1, model);
        XModelObject o = model.getByPath(f.getJPath());
        if (o != null) {
            return String.valueOf(q.getLineStart()) + FindObjectHelper.makeRef(String.valueOf(o.getPath()) + ":" + q.line(), q.toString());
        }
        if (q.line() < 0) {
            return st;
        }
        SegmentInfo s = new SegmentInfo();
        s.setData(f);
        s.parse();
        String path = s.getPath();
        XModelObject xModelObject = o = path == null ? null : model.getByPath(path);
        if (o == null) {
            return st;
        }
        return String.valueOf(q.getLineStart()) + FindObjectHelper.makeRef(String.valueOf(o.getPath()) + ":" + s.getLine(), q.toString());
    }
}

