/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.jboss.tools.common.EclipseUtil;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelFactory;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FilePathHelper;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.filesystems.impl.JarSystemImpl;
import org.jboss.tools.common.model.icons.impl.XModelObjectIcon;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.project.ModelNature;
import org.jboss.tools.common.model.project.ModelNatureExtension;
import org.jboss.tools.common.model.util.ModelImages;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.common.util.FileUtil;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseResourceUtil
extends EclipseUtil {
    private static String[] MODEL_NATURES = new String[0];
    static int count;
    static Map<IProject, XModel> models;
    static String[] SYSTEM_JARS;
    public static Set<String> SYSTEM_JAR_SET;

    static {
        ModelNatureExtension[] es = ModelNatureExtension.getInstances();
        MODEL_NATURES = new String[es.length];
        int i = 0;
        while (i < es.length) {
            EclipseResourceUtil.MODEL_NATURES[i] = es[i].getName();
            ++i;
        }
        count = 0;
        models = new HashMap<IProject, XModel>();
        SYSTEM_JARS = new String[]{"rt.jar", "jsse.jar", "jce.jar", "charsets.jar"};
        SYSTEM_JAR_SET = new HashSet<String>();
        int i2 = 0;
        while (i2 < SYSTEM_JARS.length) {
            SYSTEM_JAR_SET.add(SYSTEM_JARS[i2]);
            ++i2;
        }
    }

    public static IProject getProject(XModelObject o) {
        return o == null ? null : (IProject)o.getModel().getProperties().get("project");
    }

    public static boolean isProjectFragment(XModel model) {
        return "true".equals(model.getProperties().getProperty("isProjectFragment"));
    }

    public static IResource getResource(XModelObject object) {
        XModelObject f = ((XModelObjectImpl)object).getResourceAncestor();
        return f == null ? null : (IResource)f.getAdapter(IResource.class);
    }

    public static String getJavaClassQualifiedName(XModelObject object) {
        if (object.getFileType() != 1) {
            return null;
        }
        String ext = object.getAttributeValue("extension");
        if (!"java".equals(ext) && !"class".equals(ext)) {
            return null;
        }
        String q = object.getAttributeValue("name");
        String p = EclipseResourceUtil.getJavaPackageName(object.getParent());
        return p == null ? q : String.valueOf(p) + "." + q;
    }

    public static String getJavaPackageName(XModelObject object) {
        if (object == null || object.getFileType() != 2) {
            return null;
        }
        String q = object.getAttributeValue("name");
        XModelObject o = object.getParent();
        while (o != null && o.getFileType() == 2) {
            q = String.valueOf(o.getAttributeValue("name")) + "." + q;
            o = o.getParent();
        }
        return q;
    }

    public static String getIconPath(XModelObject o) {
        String s = o.getMainIconName();
        return o.getModelEntity().getMetaModel().getIconList().getIconPath(s, "default.unknown");
    }

    public static Image getImage(String path) {
        return ModelImages.getImage(path);
    }

    public static Image getImage(XModelObject object) {
        return new XModelObjectIcon(object).getEclipseImage();
    }

    public static XModelObject getObjectByResource(IResource resource) {
        if (resource == null) {
            return null;
        }
        IProject p = resource.getProject();
        IModelNature sp = EclipseResourceUtil.getModelNature(p);
        if (sp == null) {
            return null;
        }
        return EclipseResourceUtil.getObjectByResource(sp.getModel(), resource);
    }

    public static XModelObject getObjectByResource(XModel model, IResource resource) {
        if (resource == null) {
            return null;
        }
        IPath path = resource.getLocation();
        if (model != null) {
            String location;
            FileSystemsImpl fso = (FileSystemsImpl)FileSystemsHelper.getFileSystems(model);
            if (fso == null) {
                return null;
            }
            fso.updateOverlapped();
            XModelObject[] fs = fso.getChildren("FileSystemFolder");
            int i = 0;
            while (i < fs.length) {
                FileSystemImpl s = (FileSystemImpl)fs[i];
                XModelObject o = EclipseResourceUtil.findResourceInFileSystem(s, resource);
                if (o != null) {
                    return o;
                }
                ++i;
            }
            fs = fso.getChildren("FileSystemJar");
            String string = location = path == null ? null : path.toString().replace('\\', '/');
            if (location != null && EclipseResourceUtil.isJar(location)) {
                int i2 = 0;
                while (i2 < fs.length) {
                    JarSystemImpl jar = (JarSystemImpl)fs[i2];
                    String jl = jar.getLocation();
                    if (jl.equals(location)) {
                        return jar;
                    }
                    ++i2;
                }
            }
        }
        return null;
    }

    public static XModelObject getObjectByPath(IProject p, String path) {
        if (p == null) {
            return null;
        }
        IModelNature sp = EclipseResourceUtil.getModelNature(p);
        return sp == null ? null : sp.getModel().getByPath(path);
    }

    public static XModelObject findFileSystem(IResource resource, XModel model) {
        XModelObject fss = FileSystemsHelper.getFileSystems(model);
        if (fss == null) {
            return null;
        }
        XModelObject[] fs = fss.getChildren();
        XModelObject result = null;
        IPath resourcePath = resource == null ? null : resource.getFullPath();
        IPath path = null;
        int i = 0;
        while (i < fs.length) {
            IResource r;
            if (fs[i] instanceof FileSystemImpl && (r = (IResource)fs[i].getAdapter(IResource.class)) != null) {
                IPath p = r.getFullPath();
                if (r != null && p.isPrefixOf(resourcePath) && (path == null || path.isPrefixOf(p))) {
                    result = fs[i];
                    path = p;
                }
            }
            ++i;
        }
        return result;
    }

    public static XModelObject addFileSystem(IResource resource, XModel model) {
        XModelObject fss = FileSystemsHelper.getFileSystems(model);
        if (fss == null || resource == null) {
            return null;
        }
        Properties properties = new Properties();
        String fsLoc = resource.getLocation() != null ? resource.getLocation().toString() : resource.getLocationURI().toString();
        fsLoc = resource == resource.getProject() ? "%eclipse.project%" : EclipseResourceUtil.getRelativeLocation(model, fsLoc);
        XModelObject[] cs = fss.getChildren("FileSystemFolder");
        int i = 0;
        while (i < cs.length) {
            String loc = cs[i].getAttributeValue("location");
            if (fsLoc.equals(loc)) {
                return null;
            }
            ++i;
        }
        properties.setProperty("location", fsLoc);
        String name = resource.getName();
        name = XModelObjectUtil.createNewChildName(name, fss);
        properties.setProperty("name", name);
        FileSystemImpl s = (FileSystemImpl)model.createModelObject("FileSystemFolder", properties);
        boolean b = fss.addChild(s);
        if (b) {
            fss.setModified(true);
            return s;
        }
        return null;
    }

    public static String[] getModelNatureNames() {
        return MODEL_NATURES;
    }

    public static boolean hasNature(XModel model, String nature) {
        if (model == null) {
            return false;
        }
        IProject p = (IProject)model.getProperties().get("project");
        if (p == null || !p.isOpen()) {
            return false;
        }
        try {
            if (p.hasNature(nature)) {
                return true;
            }
        }
        catch (CoreException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        return false;
    }

    public static IModelNature getModelNature(IProject p) {
        if (p == null || !p.isOpen()) {
            return null;
        }
        String[] natures = EclipseResourceUtil.getModelNatureNames();
        int i = 0;
        while (i < natures.length) {
            block6: {
                IModelNature n;
                block7: {
                    if (!p.hasNature(natures[i])) break block6;
                    long t1 = System.currentTimeMillis();
                    ++count;
                    if (!ModelNature.checkModelNature(p, natures[i])) break block6;
                    long dt = System.currentTimeMillis() - t1;
                    count += (int)dt;
                    n = (IModelNature)p.getNature(natures[i]);
                    if (n != null) break block7;
                    return null;
                }
                try {
                    n = EclipseResourceUtil.testNature(n);
                    if (n == null) {
                        ModelPlugin.getPluginLog().logWarning("Project " + p + " has corrupted nature: " + natures[i]);
                        EclipseResourceUtil.removeNatureFromProject((IProject)p, (String)natures[i]);
                    }
                    return n;
                }
                catch (CoreException e) {
                    ModelPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            ++i;
        }
        return null;
    }

    private static IModelNature testNature(IModelNature n) {
        if (n == null || n.getModel() == null) {
            return null;
        }
        XModel model = n.getModel();
        XModelObject object = model.getRoot();
        if (object == null) {
            return null;
        }
        if (!"Root".equals(object.getModelEntity().getName())) {
            return null;
        }
        return n;
    }

    public static IModelNature getModelNature(IProject p, String id) {
        block6: {
            IModelNature n;
            block8: {
                block7: {
                    if (p == null || !p.isOpen()) {
                        return null;
                    }
                    if (!p.hasNature(id)) break block6;
                    if (ModelNature.checkModelNature(p, id)) break block7;
                    return null;
                }
                n = (IModelNature)p.getNature(id);
                if (n != null) break block8;
                return null;
            }
            try {
                n = EclipseResourceUtil.testNature(n);
                if (n == null) {
                    ModelPlugin.getPluginLog().logWarning("Project " + p + " has corrupted nature: " + id);
                    EclipseResourceUtil.removeNatureFromProject((IProject)p, (String)id);
                }
                return n;
            }
            catch (CoreException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return null;
    }

    public static XModelObject createObjectForResource(IResource resource) {
        IFolder webInf;
        if (resource == null || !resource.exists()) {
            return null;
        }
        IProject project = resource.getProject();
        if (project == null || !project.isOpen()) {
            return null;
        }
        IModelNature sp = EclipseResourceUtil.getModelNature(project);
        if (sp != null) {
            XModelObject result = EclipseResourceUtil.getObjectByResource(resource);
            if (result == null) {
                IContainer r;
                XModelObject fs = EclipseResourceUtil.findFileSystem((IResource)resource.getProject(), sp.getModel());
                if (fs == null && (fs = EclipseResourceUtil.addFileSystem((IResource)resource.getProject(), sp.getModel())) != null) {
                    result = EclipseResourceUtil.getObjectByResource(resource);
                }
                if (result == null && resource != project && (r = resource.getParent()) != null && r != project && (fs = EclipseResourceUtil.addFileSystem((IResource)r, sp.getModel())) != null) {
                    result = EclipseResourceUtil.getObjectByResource(resource);
                }
            }
            return result;
        }
        XModel model = models.get(project);
        if (model != null) {
            XModelObject fs;
            IContainer r;
            EclipseResourceUtil.validateJarSystem(FileSystemsHelper.getFileSystems(model), resource);
            XModelObject result = EclipseResourceUtil.getObjectByResource(model, resource);
            if (result == null && resource instanceof IFile && (r = resource.getParent()) != null && project != r && (fs = EclipseResourceUtil.addFileSystem((IResource)r, model)) != null) {
                return EclipseResourceUtil.getObjectByResource(model, resource);
            }
            return result;
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        IResource r = resource;
        if (!(r instanceof IProject)) {
            while (r != null && !(r.getParent() instanceof IProject)) {
                r = r.getParent();
            }
        }
        if (r == null) {
            return null;
        }
        properties.setProperty(XModelConstants.WORKSPACE, r.getParent().getLocation().toString());
        properties.setProperty("eclipse.project", project.getLocation().toString());
        properties.put("project", project);
        properties.put("isProjectFragment", "true");
        model = XModelFactory.getModel(properties);
        models.put(project, model);
        XModelObject fs = FileSystemsHelper.getFileSystems(model);
        if (fs == null) {
            ModelPlugin.getPluginLog().logInfo("Cannot create file systems for project " + project);
            return null;
        }
        String fsLoc = null;
        FileSystemImpl s = null;
        properties = new Properties();
        fsLoc = project.getLocation().toString();
        properties.setProperty("location", fsLoc);
        properties.setProperty("name", project.getName());
        s = (FileSystemImpl)model.createModelObject("FileSystemFolder", properties);
        fs.addChild(s);
        HashSet<IResource> resources = new HashSet<IResource>();
        IResource webRoot = EclipseResourceUtil.getFirstWebContentResource(project);
        if (webRoot != null && webRoot.exists() && webRoot != project) {
            resources.add(webRoot);
            fsLoc = webRoot.getLocation().toString();
            properties.setProperty("location", fsLoc);
            properties.setProperty("name", "WEB-ROOT");
            s = (FileSystemImpl)model.createModelObject("FileSystemFolder", properties);
            fs.addChild(s);
        }
        if (webRoot != null && webRoot.exists() && (webInf = ((IContainer)webRoot).getFolder((IPath)new Path("WEB-INF"))) != null && webInf.exists()) {
            resources.add((IResource)webInf);
            fsLoc = webInf.getLocation().toString();
            properties.setProperty("location", fsLoc);
            properties.setProperty("name", "WEB-INF");
            s = (FileSystemImpl)model.createModelObject("FileSystemFolder", properties);
            fs.addChild(s);
        }
        EclipseResourceUtil.updateSrcs(project, fs, resources);
        EclipseResourceUtil.updateLibs(project, fs);
        if (!EclipseResourceUtil.isJar(resource) || EclipseResourceUtil.getObjectByResource(model, resource) == null) {
            properties = new Properties();
            fsLoc = r instanceof IFile ? r.getParent().getLocation().toString() : r.getLocation().toString();
            properties.setProperty("location", fsLoc);
            properties.setProperty("name", r.getName());
            s = (FileSystemImpl)model.createModelObject("FileSystemFolder", properties);
            fs.addChild(s);
        }
        IResource[] cs = null;
        try {
            cs = project.members();
        }
        catch (CoreException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        if (cs != null) {
            int i = 0;
            while (i < cs.length) {
                if (cs[i].isLinked() && cs[i].isAccessible() && !resources.contains(cs[i]) && cs[i].getLocation() != null && cs[i].getLocation().toFile() != null && cs[i].getLocation().toFile().isDirectory()) {
                    properties = new Properties();
                    fsLoc = cs[i].getLocation().toString();
                    properties.setProperty("location", fsLoc);
                    properties.setProperty("name", cs[i].getName());
                    s = (FileSystemImpl)model.createModelObject("FileSystemFolder", properties);
                    fs.addChild(s);
                }
                ++i;
            }
        }
        EclipseResourceUtil.validateJarSystem(fs, resource);
        return EclipseResourceUtil.getObjectByResource(model, resource);
    }

    public static IResource getFirstWebContentResource(IProject project) {
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        if (vc == null || vc.getRootFolder() == null) {
            return null;
        }
        if (ModuleCoreNature.isFlexibleProject((IProject)project)) {
            return vc.getRootFolder().getUnderlyingResource();
        }
        return null;
    }

    private static boolean isJar(IResource resource) {
        return resource instanceof IFile && EclipseResourceUtil.isJar(resource.getName());
    }

    private static void validateJarSystem(XModelObject fs, IResource resource) {
        if (fs == null || !EclipseResourceUtil.isJar(resource)) {
            return;
        }
        String jsname = "lib-" + resource.getName().toLowerCase();
        String location = resource.getLocation().toString().replace('\\', '/');
        if (fs.getChildByPath(jsname) == null) {
            XModelObject q = fs.getModel().createModelObject("FileSystemJar", null);
            q.setAttributeValue("name", jsname);
            q.setAttributeValue("location", location);
            fs.addChild(q);
        }
    }

    private static void updateSrcs(IProject p, XModelObject object, Set<IResource> resources) {
        if (p == null || !p.isAccessible()) {
            return;
        }
        String[] srcs = EclipseResourceUtil.getJavaProjectSrcLocations(p);
        HashSet<String> paths = new HashSet<String>();
        int i = 0;
        while (i < srcs.length) {
            String path = EclipseResourceUtil.getRelativeLocation(object.getModel(), srcs[i]);
            if (path != null) {
                paths.add(path);
            }
            ++i;
        }
        XModelObject[] cs = object.getChildren("FileSystemFolder");
        int i2 = 0;
        while (i2 < cs.length) {
            if (cs[i2].getAttributeValue("name").startsWith("src")) {
                String loc = cs[i2].getAttributeValue("location");
                if (!paths.contains(loc)) {
                    object.removeChild(cs[i2]);
                } else {
                    paths.remove(loc);
                    IResource r = (IResource)object.getAdapter(IResource.class);
                    if (r != null) {
                        resources.add(r);
                    }
                }
            }
            ++i2;
        }
        for (String path : paths) {
            String n = EclipseResourceUtil.getNextSrcName(object);
            Properties properties = new Properties();
            properties.setProperty("location", path);
            properties.setProperty("name", n);
            FileSystemImpl s = (FileSystemImpl)object.getModel().createModelObject("FileSystemFolder", properties);
            object.addChild(s);
            IResource r = (IResource)s.getAdapter(IResource.class);
            if (r == null) continue;
            resources.add(r);
        }
    }

    private static String getNextSrcName(XModelObject object) {
        if (object.getChildByPath("src") == null) {
            return "src";
        }
        int i = 1;
        String s;
        while (object.getChildByPath(s = "src-" + i) != null) {
            ++i;
        }
        return s;
    }

    private static void updateLibs(IProject project, XModelObject object) {
        FileSystemsHelper.getLibs(object).update();
    }

    public static XModelObject findResourceInFileSystem(FileSystemImpl s, IResource resource) {
        IResource r;
        String rootpath;
        String path;
        if (resource == null || resource.getLocation() == null) {
            return null;
        }
        IContainer sr = s.getResource();
        if (sr == null) {
            return null;
        }
        String relpath = null;
        if (sr.getFullPath().isPrefixOf(resource.getFullPath()) ? (relpath = (path = resource.getFullPath().toString()).substring((rootpath = sr.getFullPath().toString()).length()).replace('\\', '/')).length() == 0 : sr.getLocation() != null && resource.getLocation() != null && sr.getLocation().isPrefixOf(resource.getLocation()) && (relpath = (path = resource.getLocation().toString()).substring((rootpath = sr.getLocation().toString()).length()).replace('\\', '/')).length() == 0) {
            return s;
        }
        if (relpath == null) {
            return null;
        }
        XModelObject o = s.getChildByPath(relpath.substring(1));
        if (o == null && resource.exists()) {
            s.update();
            o = s.getChildByPath(relpath.substring(1));
        }
        if (o == null) {
            return null;
        }
        XModelObject p = o;
        while (p != null && !"true".equals(p.get("overlapped"))) {
            p = p.getParent();
        }
        if (!(p != null || (r = (IResource)o.getAdapter(IResource.class)) != null && (resource.getFullPath().equals((Object)r.getFullPath()) || resource.getLocation() != null && r.getLocation() != null && resource.getLocation().equals((Object)r.getLocation())))) {
            return null;
        }
        return p == null ? o : null;
    }

    public static boolean isOverlapped(XModelObject object) {
        XModelObject p = object;
        while (p != null && !"true".equals(p.get("overlapped"))) {
            p = p.getParent();
        }
        return p != null;
    }

    public static XModelObject createObjectForLocation(String location) {
        if (location == null) {
            return null;
        }
        File f = new File(location);
        if (!f.isFile()) {
            return null;
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        properties.setProperty(XModelConstants.WORKSPACE, f.getParent());
        properties.put("isProjectFragment", "true");
        XModel model = XModelFactory.getModel(properties);
        XModelObject fs = FileSystemsHelper.getFileSystems(model);
        if (fs == null) {
            ModelPlugin.getPluginLog().logInfo("Cannot create file systems for model at " + location);
            return null;
        }
        properties = new Properties();
        String fsLoc = f.getParent();
        properties.setProperty("location", fsLoc);
        properties.setProperty("name", f.getParentFile().getName());
        FileSystemImpl s = (FileSystemImpl)model.createModelObject("FileSystemFolder", properties);
        fs.addChild(s);
        String pp = FilePathHelper.toPathPath(f.getName());
        return model.getByPath("/" + pp);
    }

    public static String[] getJavaProjectSrcLocations(IProject project) {
        IResource[] rs = EclipseResourceUtil.getJavaSourceRoots((IProject)project);
        if (rs == null || rs.length == 0) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < rs.length) {
            IPath p = rs[i].getLocation();
            if (p != null) {
                result.add(p.toString());
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public static List<String> getClassPath(IProject project) throws CoreException, IOException {
        if (project == null || !project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
        int i = 0;
        while (i < es.length) {
            if (es[i].getEntryKind() == 1) {
                String s = null;
                String path = es[i].getPath().toString();
                try {
                    IResource findMember;
                    if (path.startsWith("/") && path.indexOf("/", 1) > 1) {
                        findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(es[i].getPath());
                        s = findMember != null ? findMember.getLocation().toString() : null;
                    }
                    if (s == null && path.startsWith("/" + project.getName() + "/")) {
                        findMember = project.findMember(es[i].getPath().removeFirstSegments(1));
                        s = findMember != null ? findMember.getLocation().toString() : null;
                    }
                    if (s == null && new File(path).exists()) {
                        s = path;
                    }
                    if (s != null) {
                        l.add(new File(s).getCanonicalPath());
                    }
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        return l;
    }

    public static List<String> getJREClassPath(IProject project) throws CoreException {
        if (project == null || !project.isAccessible() || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] es0 = javaProject.getRawClasspath();
        IClasspathEntry[] es = null;
        int i = 0;
        while (i < es0.length && es == null) {
            IClasspathContainer container;
            if (es0[i].getEntryKind() == 5 && es0[i].getPath().toString().equals("org.eclipse.jdt.launching.JRE_CONTAINER") && (container = JavaCore.getClasspathContainer((IPath)es0[i].getPath(), (IJavaProject)javaProject)) != null) {
                es = container.getClasspathEntries();
            }
            ++i;
        }
        if (es == null) {
            return l;
        }
        i = 0;
        while (i < es.length) {
            try {
                String s = null;
                String path = es[i].getPath().toString();
                if (path.startsWith("/" + project.getName() + "/")) {
                    s = project.findMember(es[i].getPath().removeFirstSegments(1)).getLocation().toString();
                } else if (new File(path).isFile()) {
                    s = path;
                }
                if (s != null) {
                    l.add(new File(s).getCanonicalPath());
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IJavaElement findJavaElement(XModelObject object) {
        int type = object.getFileType();
        IResource resource = EclipseResourceUtil.getResource(object);
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        if (javaProject == null) {
            return null;
        }
        try {
            if (type == 3) {
                return javaProject.findPackageFragmentRoot(resource.getFullPath());
            }
            Path path = null;
            if (type == 2) {
                String p = EclipseResourceUtil.getJavaPackageName(object);
                if (p == null) {
                    return null;
                }
                path = new Path(p.replace('.', '/'));
                return javaProject.findElement((IPath)path);
            }
            String p = EclipseResourceUtil.getJavaClassQualifiedName(object);
            if (p == null) {
                return null;
            }
            path = new Path(String.valueOf(p.replace('.', '/')) + ".java");
            return javaProject.findElement((IPath)path);
        }
        catch (CoreException ex) {
            ModelPlugin.getPluginLog().logError((Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IType getValidType(IProject project, String className) {
        if (className == null) return null;
        if (className.length() == 0) {
            return null;
        }
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        if (javaProject == null) {
            return null;
        }
        IFile f = null;
        try {
            IType t = javaProject.findType(className);
            if (t == null) return t;
            if (t.isBinary()) {
                return t;
            }
            if (!(t.getParent() instanceof ICompilationUnit)) return t;
            ICompilationUnit u = (ICompilationUnit)t.getParent();
            f = (IFile)u.getCorrespondingResource();
            IMarker[] ms = f.findMarkers("org.eclipse.jdt.core.problem", true, 0);
            int i = 0;
            while (true) {
                if (i >= ms.length) {
                    return t;
                }
                if (ms[i].getAttribute("severity", 0) == 2) {
                    return null;
                }
                ++i;
            }
        }
        catch (JavaModelException t) {
            ModelPlugin.getPluginLog().logError("Error while obtaining type " + className, (Throwable)t);
            return null;
        }
        catch (CoreException t) {
            ModelPlugin.getPluginLog().logError("Error occured while obtaining Java Problem markers  for " + f.getLocation(), (Throwable)t);
        }
        return null;
    }

    public static String getJavaClassName(IResource resource) {
        if (resource == null || !(resource instanceof IFile)) {
            return null;
        }
        IResource root = EclipseResourceUtil.getJavaSourceRoot(resource.getProject());
        if (root == null) {
            return null;
        }
        if (!root.getLocation().isPrefixOf(resource.getLocation())) {
            return null;
        }
        String relative = resource.getLocation().toString().substring(root.getLocation().toString().length());
        if (!relative.endsWith(".java")) {
            return null;
        }
        relative = relative.substring(0, relative.length() - 5);
        if ((relative = relative.replace('\\', '/')).startsWith("/")) {
            relative = relative.substring(1);
        }
        return relative.replace('/', '.');
    }

    public static boolean isContainedInOutput(IProject project, String className) {
        IResource r;
        block5: {
            if (className == null || className.length() == 0) {
                return false;
            }
            IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
            if (javaProject == null) {
                return false;
            }
            try {
                IPath p = javaProject.getOutputLocation();
                r = project.getWorkspace().getRoot().findMember(p);
                if (r != null && r.getLocation() != null) break block5;
                return false;
            }
            catch (JavaModelException t) {
                ModelPlugin.getPluginLog().logError("Error checking class " + className, (Throwable)t);
                return false;
            }
        }
        String output = r.getLocation().toString();
        String f = String.valueOf(output) + "/" + className.replace('.', '/') + ".class";
        return new File(f).isFile();
    }

    public static boolean hasSources(IJavaProject javaProject) throws JavaModelException {
        IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
        int i = 0;
        while (i < es.length) {
            if (es[i].getEntryKind() == 3) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IResource getJavaSourceRoot(IProject project) {
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        if (javaProject == null) {
            return null;
        }
        try {
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IResource findMember;
                if (es[i].getEntryKind() == 3 && (findMember = ModelPlugin.getWorkspace().getRoot().findMember(es[i].getPath())) != null && findMember.exists()) {
                    return findMember;
                }
                ++i;
            }
        }
        catch (JavaModelException ex) {
            ModelPlugin.getPluginLog().logError((Throwable)ex);
        }
        return null;
    }

    public static Set<IFolder> getSourceFolders(IProject project) {
        HashSet<IFolder> folders = new HashSet<IFolder>();
        try {
            IJavaProject javaProject = EclipseUtil.getJavaProject((IProject)project);
            if (javaProject != null) {
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IResource source;
                    if (roots[i].getKind() == 1 && (source = roots[i].getCorrespondingResource()) instanceof IFolder) {
                        folders.add((IFolder)source);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException e) {
            ModelPlugin.getDefault().logError(e);
        }
        return folders;
    }

    public static void openResource(IResource resource) {
        XModelObject o = EclipseResourceUtil.getObjectByResource(resource);
        if (o == null) {
            o = EclipseResourceUtil.createObjectForResource(resource);
        }
        if (o != null) {
            XActionInvoker.invoke("Open", o, null);
        }
    }

    public static String getInstallPath(Plugin plugin) {
        URL url = EclipseResourceUtil.getInstallURL(plugin);
        return url == null ? null : url.getPath();
    }

    public static URL getInstallURL(Plugin plugin) {
        return plugin == null ? null : EclipseResourceUtil.getInstallURL(plugin.getBundle());
    }

    public static String getInstallPath(Bundle bundle) {
        URL url = EclipseResourceUtil.getInstallURL(bundle);
        return url == null ? null : url.getPath();
    }

    public static URL getInstallURL(Bundle bundle) {
        try {
            return bundle == null ? null : FileLocator.resolve((URL)bundle.getEntry("/"));
        }
        catch (IOException iOException) {
            return bundle.getEntry("/");
        }
    }

    public static IFile getFile(String location) {
        IPath path = new Path(location).makeAbsolute();
        IFile result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(path);
        return result;
    }

    public static IResource getFolder(String location) {
        location = new File(location).getAbsolutePath();
        IProject[] projects = ModelPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (projects != null && i < projects.length) {
            if (projects[i].isOpen()) {
                String l = projects[i].getLocation().toFile().getAbsolutePath();
                if (!location.startsWith(l)) {
                    try {
                        IResource[] ms = projects[i].members();
                        int j = 0;
                        while (j < ms.length) {
                            IContainer c;
                            if (ms[j] instanceof IContainer && location.startsWith(l = (c = (IContainer)ms[j]).getLocation().toFile().getAbsolutePath())) {
                                String relative = location.substring(l.length()).replace('\\', '/');
                                return relative.length() == 0 ? c : c.getFolder((IPath)new Path(relative));
                            }
                            ++j;
                        }
                    }
                    catch (CoreException e) {
                        ModelPlugin.getPluginLog().logError((Throwable)e);
                    }
                } else {
                    String relative = location.substring(l.length()).replace('\\', '/');
                    return relative.length() == 0 ? projects[i] : projects[i].getFolder(relative);
                }
            }
            ++i;
        }
        return null;
    }

    public static IPath getRelativePath(IProject project, String path) {
        Path absolutePath;
        Path result = null;
        IPath projectPath = project.getLocation();
        if (projectPath.isPrefixOf((IPath)(absolutePath = new Path(path)))) {
            result = new Path(project.getFullPath() + absolutePath.toString().substring(projectPath.toString().length()));
        } else {
            try {
                IResource[] children = project.members(true);
                int i = 0;
                while (i < children.length && result == null) {
                    if (absolutePath.equals((Object)children[i].getLocation())) {
                        result = children[i].getFullPath();
                    }
                    ++i;
                }
                i = 0;
                while (i < children.length && result == null) {
                    IPath memberPath = children[i].getLocation();
                    if (memberPath != null && memberPath.isPrefixOf((IPath)absolutePath)) {
                        result = children[i].getFullPath().append(absolutePath.removeFirstSegments(memberPath.segmentCount()));
                    }
                    ++i;
                }
            }
            catch (CoreException ex) {
                ModelPlugin.getPluginLog().logError((Throwable)ex);
            }
        }
        if (result == null) {
            result = absolutePath;
        }
        return result;
    }

    public static IClasspathEntry[] getDefaultJRELibrary() {
        return PreferenceConstants.getDefaultJRELibrary();
    }

    public static IResource[] getClasspathResources(IProject project) {
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)project);
        if (javaProject == null) {
            return new IProject[0];
        }
        ArrayList<Object> l = new ArrayList<Object>();
        IClasspathEntry[] es = null;
        try {
            es = javaProject.getResolvedClasspath(true);
        }
        catch (JavaModelException javaModelException) {
            return new IProject[0];
        }
        if (es != null) {
            int i = 0;
            while (i < es.length) {
                IPath path;
                if (es[i].getEntryKind() == 2) {
                    path = es[i].getPath();
                    IProject p = (IProject)project.getWorkspace().getRoot().findMember(path);
                    l.add(p);
                } else if (es[i].getEntryKind() == 1) {
                    path = es[i].getPath();
                    IResource r = project.getWorkspace().getRoot().findMember(path);
                    if (r instanceof IContainer) {
                        l.add(r);
                    } else if (r != null && !project.getFullPath().isPrefixOf(r.getFullPath())) {
                        l.add(r);
                    }
                }
                ++i;
            }
        }
        return l.toArray(new IResource[0]);
    }

    public static String getRelativeLocation(XModel model, String path) {
        if (path == null || path.startsWith("%")) {
            return path;
        }
        String workspace = XModelConstants.getWorkspace(model);
        if (workspace == null) {
            return path;
        }
        String relative = FileUtil.getRelativePath((String)(workspace = new File(workspace).getAbsolutePath().replace('\\', '/')), (String)(path = path.replace('\\', '/')));
        return relative == null ? path : String.valueOf(XModelConstants.WORKSPACE_REF) + relative;
    }

    public static boolean projectExistsIgnoreCase(String name) {
        return EclipseResourceUtil.findProjectIgnoreCase(name) != null;
    }

    public static IProject findProjectIgnoreCase(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        IProject[] ps = ModelPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < ps.length) {
            if (ps[i].getName().equalsIgnoreCase(name)) {
                return ps[i];
            }
            ++i;
        }
        return null;
    }

    public static boolean isJar(String path) {
        if (path == null) {
            return false;
        }
        return (path = path.toLowerCase()).endsWith(".jar") || path.endsWith(".zip");
    }
}

