/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseJavaUtil
extends org.jboss.tools.common.util.EclipseJavaUtil {
    public static boolean isDerivedClass(String type, String superType, IProject project) {
        if (type == null) {
            return false;
        }
        if (superType == null || superType.equals("java.lang.Object")) {
            return true;
        }
        if (type.equals(superType)) {
            return true;
        }
        IType t = EclipseResourceUtil.getValidType(project, type);
        try {
            return t != null && EclipseJavaUtil.isDerivedClass(t, superType, new HashSet<String>());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    static boolean isDerivedClass(IType type, String superType, Set<String> checked) throws JavaModelException {
        if (type == null) {
            return false;
        }
        checked.add(type.getFullyQualifiedName());
        String[] is = type.getSuperInterfaceNames();
        if (is != null) {
            int i = 0;
            while (i < is.length) {
                IType t;
                String f = EclipseJavaUtil.resolveType((IType)type, (String)is[i]);
                if (f != null && f.equals(superType)) {
                    return true;
                }
                if (f != null && !checked.contains(f) && EclipseJavaUtil.isDerivedClass(t = EclipseResourceUtil.getValidType(type.getJavaProject().getProject(), f), superType, checked)) {
                    return true;
                }
                ++i;
            }
        }
        if (type.isInterface()) {
            return false;
        }
        String f = type.getSuperclassName();
        if (f == null || f.length() == 0 || "java.lang.Object".equals(f)) {
            return false;
        }
        if (f.equals(superType)) {
            return true;
        }
        if ((f = EclipseJavaUtil.resolveType((IType)type, (String)f)) == null || f.length() == 0 || "java.lang.Object".equals(f)) {
            return false;
        }
        if (f.equals(superType)) {
            return true;
        }
        if (checked.contains(f)) {
            return false;
        }
        type = EclipseResourceUtil.getValidType(type.getJavaProject().getProject(), f);
        return EclipseJavaUtil.isDerivedClass(type, superType, checked);
    }

    public static List<IType> getSupperTypes(IType type) throws JavaModelException {
        IType[] superTypes;
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType[] iTypeArray = superTypes = typeHierarchy == null ? null : typeHierarchy.getAllSupertypes(type);
        if (superTypes == null) {
            return Collections.emptyList();
        }
        ArrayList<IType> suppers = new ArrayList<IType>();
        int i = 0;
        while (i < superTypes.length) {
            suppers.add(superTypes[i]);
            ++i;
        }
        return suppers;
    }
}

