/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.options;

import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.plugin.ModelPlugin;

public class Preference {
    private String option;
    private String attributeName;
    public static final String OPTIONS_PATH = "%Options%";
    public static String EDITOR_PATH = "%Options%/Editors";
    public static final Preference SHOW_NATURE_WARNING = new Preference(EDITOR_PATH, "natureWarning");

    protected Preference(String optionPath, String attributeName) {
        this.option = optionPath;
        this.attributeName = attributeName;
    }

    public String getValue() {
        XModelObject obj = PreferenceModelUtilities.getPreferenceModel().getByPath(this.option);
        if (obj == null) {
            if (ModelPlugin.isDebugEnabled()) {
                ModelPlugin.getPluginLog().logInfo(String.valueOf(this.option) + " does not exist");
            }
            return "";
        }
        XAttribute attribute = obj.getModelEntity().getAttribute(this.attributeName);
        if (attribute == null) {
            if (ModelPlugin.isDebugEnabled()) {
                ModelPlugin.getPluginLog().logInfo(String.valueOf(this.attributeName) + " in " + this.option + " does not exist");
            }
            return "";
        }
        return obj.getAttributeValue(this.attributeName);
    }

    public String getModelPath() {
        return this.option;
    }

    public String getName() {
        return this.attributeName;
    }

    public void setValue(String value) throws XModelException {
        XModelObject obj = PreferenceModelUtilities.getPreferenceModel().getByPath(this.option);
        if (obj == null) {
            if (ModelPlugin.isDebugEnabled()) {
                ModelPlugin.getPluginLog().logInfo(String.valueOf(this.option) + " does not exist");
            }
            return;
        }
        obj.getModel().changeObjectAttribute(obj, this.attributeName, value);
        obj.getModel().saveOptions();
    }
}

